/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionAvailability;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionState;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.validator.constraints.Length;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="operation_executions", uniqueConstraints={@UniqueConstraint(columnNames={"code"})})
public class OperationExecutionPE
implements IIdHolder,
IIdentityHolder,
Serializable {
    private static final long serialVersionUID = 35L;
    private static final String SEPARATOR = "\n";
    protected Long id;
    private String code;
    private OperationExecutionState state;
    private PersonPE owner;
    private String description;
    private String notification;
    private OperationExecutionAvailability availability;
    private Long availabilityTime;
    private String summaryOperations;
    private String summaryProgress;
    private String summaryError;
    private String summaryResults;
    private OperationExecutionAvailability summaryAvailability;
    private Long summaryAvailabilityTime;
    private String detailsPath;
    private OperationExecutionAvailability detailsAvailability;
    private Long detailsAvailabilityTime;
    private Date creationDate;
    private Date startDate;
    private Date finishDate;

    @SequenceGenerator(name="OPERATION_EXECUTIONS_ID_SEQ", sequenceName="OPERATION_EXECUTIONS_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="OPERATION_EXECUTIONS_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Transient
    public String getPermId() {
        return this.getCode();
    }

    @Transient
    public String getIdentifier() {
        return this.getCode();
    }

    @NotNull(message="Code can not be null.")
    @Column(name="code", updatable=false)
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @NotNull(message="State can not be null.")
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    public OperationExecutionState getState() {
        return this.state;
    }

    public void setState(OperationExecutionState state) {
        this.state = state;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Owner can not be null.")
    @JoinColumn(name="owner", updatable=false)
    public PersonPE getOwner() {
        return this.owner;
    }

    public void setOwner(PersonPE owner) {
        this.owner = owner;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="notification")
    public String getNotification() {
        return this.notification;
    }

    public void setNotification(String notification) {
        this.notification = notification;
    }

    @Column(name="availability")
    @Enumerated(value=EnumType.STRING)
    public OperationExecutionAvailability getAvailability() {
        return this.availability;
    }

    public void setAvailability(OperationExecutionAvailability availability) {
        this.availability = availability;
    }

    @Column(name="availability_time")
    public Long getAvailabilityTime() {
        return this.availabilityTime;
    }

    public void setAvailabilityTime(Long availabilityTime) {
        this.availabilityTime = availabilityTime;
    }

    @Column(name="summary_operations")
    public String getSummaryOperations() {
        return this.summaryOperations;
    }

    public void setSummaryOperations(String summaryOperations) {
        this.summaryOperations = summaryOperations;
    }

    @Transient
    public List<String> getSummaryOperationsList() {
        return this.splitString(this.getSummaryOperations());
    }

    public void setSummaryOperationsList(List<String> summaryOperationsList) {
        this.summaryOperations = this.joinList(summaryOperationsList);
    }

    @Column(name="summary_progress")
    public String getSummaryProgress() {
        return this.summaryProgress;
    }

    public void setSummaryProgress(String summaryProgress) {
        this.summaryProgress = summaryProgress;
    }

    @Column(name="summary_error")
    public String getSummaryError() {
        return this.summaryError;
    }

    public void setSummaryError(String summaryError) {
        this.summaryError = summaryError;
    }

    @Column(name="summary_results")
    public String getSummaryResults() {
        return this.summaryResults;
    }

    public void setSummaryResults(String summaryResults) {
        this.summaryResults = summaryResults;
    }

    @Transient
    public List<String> getSummaryResultsList() {
        return this.splitString(this.getSummaryResults());
    }

    public void setSummaryResultsList(List<String> summaryResultsList) {
        this.summaryResults = this.joinList(summaryResultsList);
    }

    @Column(name="summary_availability")
    @Enumerated(value=EnumType.STRING)
    public OperationExecutionAvailability getSummaryAvailability() {
        return this.summaryAvailability;
    }

    public void setSummaryAvailability(OperationExecutionAvailability summaryAvailability) {
        this.summaryAvailability = summaryAvailability;
    }

    @Column(name="summary_availability_time")
    public Long getSummaryAvailabilityTime() {
        return this.summaryAvailabilityTime;
    }

    public void setSummaryAvailabilityTime(Long summaryAvailabilityTime) {
        this.summaryAvailabilityTime = summaryAvailabilityTime;
    }

    @Column(name="details_path")
    @Length(min=1, max=1000, message="Given details path '%s' is too long (maximal length: {max} characters).")
    public String getDetailsPath() {
        return this.detailsPath;
    }

    public void setDetailsPath(String detailsPath) {
        this.detailsPath = detailsPath;
    }

    @Column(name="details_availability")
    @Enumerated(value=EnumType.STRING)
    public OperationExecutionAvailability getDetailsAvailability() {
        return this.detailsAvailability;
    }

    public void setDetailsAvailability(OperationExecutionAvailability detailsAvailability) {
        this.detailsAvailability = detailsAvailability;
    }

    @Column(name="details_availability_time")
    public Long getDetailsAvailabilityTime() {
        return this.detailsAvailabilityTime;
    }

    public void setDetailsAvailabilityTime(Long detailsAvailabilityTime) {
        this.detailsAvailabilityTime = detailsAvailabilityTime;
    }

    @Column(name="creation_date", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public Date getCreationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.creationDate);
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Column(name="start_date")
    public Date getStartDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.startDate);
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Column(name="finish_date")
    public Date getFinishDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.finishDate);
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    @Transient
    public Long getAvailabilityTimeLeft() {
        return this.getAvailabilityTimeLeft(this.getAvailabilityTime());
    }

    @Transient
    public Long getSummaryAvailabilityTimeLeft() {
        return this.getAvailabilityTimeLeft(this.getSummaryAvailabilityTime());
    }

    @Transient
    public Long getDetailsAvailabilityTimeLeft() {
        return this.getAvailabilityTimeLeft(this.getDetailsAvailabilityTime());
    }

    private Long getAvailabilityTimeLeft(Long time) {
        if (this.getFinishDate() != null && time != null) {
            return this.getFinishDate().getTime() + time * 1000L - System.currentTimeMillis();
        }
        return null;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OperationExecutionPE)) {
            return false;
        }
        OperationExecutionPE that = (OperationExecutionPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    public final String toString() {
        return this.getCode();
    }

    private List<String> splitString(String string) {
        if (string != null) {
            String[] array = string.split(SEPARATOR);
            return Arrays.asList(array);
        }
        return Collections.emptyList();
    }

    private String joinList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String item = iterator.next();
            builder.append(item != null ? item.trim() : "");
            if (!iterator.hasNext()) continue;
            builder.append(SEPARATOR);
        }
        return builder.toString();
    }
}

