/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractExpressionPE;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="queries")
public class QueryPE
extends AbstractExpressionPE<QueryPE>
implements IIdentityHolder {
    private static final long serialVersionUID = 35L;
    private String queryDatabaseKey;
    private String name;
    private QueryType queryType;
    private String entityTypeCodePattern;

    @SequenceGenerator(name="QUERY_ID_SEQ", sequenceName="QUERY_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUERY_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @Column(name="name")
    @NotNull(message="Name can not be null.")
    @Length(min=1, max=200, message="Given name '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="db_key")
    @NotNull(message="Query Database Key can not be null.")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    public String getQueryDatabaseKey() {
        return this.queryDatabaseKey;
    }

    public void setQueryDatabaseKey(String queryDatabaseKey) {
        this.queryDatabaseKey = queryDatabaseKey;
    }

    @NotNull(message="Query Type can not be null.")
    @Column(name="query_type")
    @Enumerated(value=EnumType.STRING)
    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    @Column(name="entity_type_code")
    public String getEntityTypeCodePattern() {
        return this.entityTypeCodePattern;
    }

    public void setEntityTypeCodePattern(String entityTypeCodePattern) {
        this.entityTypeCodePattern = entityTypeCodePattern;
    }

    @Transient
    public String getIdentifier() {
        return this.name;
    }

    @Override
    @Transient
    public String getPermId() {
        return this.id != null ? this.id.toString() : null;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QueryPE)) {
            return false;
        }
        QueryPE that = (QueryPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getName(), (Object)that.getName());
        builder.append((Object)this.getQueryDatabaseKey(), (Object)that.getQueryDatabaseKey());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getName());
        return builder.toHashCode();
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(QueryPE that) {
        String thatName = that.getName();
        String thisName = this.getName();
        if (thisName == null) {
            return thatName == null ? 0 : -1;
        }
        if (thatName == null) {
            return 1;
        }
        return thisName.compareTo(thatName);
    }
}

