/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.UnmodifiableSetDecorator;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IMatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationshipTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="samples")
@Friend(toClasses={ProjectPE.class})
public class SamplePE
extends AttachmentHolderPE
implements IIdAndCodeHolder,
Comparable<SamplePE>,
IEntityInformationWithPropertiesHolder,
IMatchingEntity,
IDeletablePE,
IEntityWithMetaprojects,
IModifierAndModificationDateBean,
IIdentityHolder,
Serializable {
    private static final long serialVersionUID = 35L;
    public static final SamplePE[] EMPTY_ARRAY = new SamplePE[0];
    public static final List<SamplePE> EMPTY_LIST = Collections.emptyList();
    public static boolean projectSamplesEnabled = false;
    private Long id;
    private String code;
    private SampleTypePE sampleType;
    private boolean frozen;
    private boolean frozenForComponent;
    private boolean frozenForChildren;
    private boolean frozenForParents;
    private boolean frozenForDataSet;
    private SpacePE space;
    private boolean spaceFrozen;
    private SampleIdentifier sampleIdentifier;
    private SamplePE container;
    private boolean containerFrozen;
    private ProjectPE project;
    private boolean projectFrozen;
    private ExperimentPE experiment;
    private boolean experimentFrozen;
    private String permId;
    private Set<SampleRelationshipPE> parentRelationships = new LinkedHashSet<SampleRelationshipPE>();
    private Set<SampleRelationshipPE> childRelationships = new LinkedHashSet<SampleRelationshipPE>();
    private Set<MetaprojectAssignmentPE> metaprojectAssignments = new HashSet<MetaprojectAssignmentPE>();
    private DeletionPE deletion;
    private Integer originalDeletion;
    private Set<SamplePropertyPE> properties = new HashSet<SamplePropertyPE>();
    private PersonPE registrator;
    private PersonPE modifier;
    private Date registrationDate;
    private Date modificationDate;
    private int version;
    private Set<DataPE> datasets = new HashSet<DataPE>();
    private List<SamplePE> contained = new ArrayList<SamplePE>();

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentSample")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<SampleRelationshipPE> getSampleChildRelationships() {
        return this.childRelationships;
    }

    private void setSampleChildRelationships(Set<SampleRelationshipPE> childRelationships) {
        this.childRelationships = childRelationships;
    }

    @Transient
    public Set<SampleRelationshipPE> getChildRelationships() {
        return new UnmodifiableSetDecorator(this.getSampleChildRelationships());
    }

    @Transient
    public boolean isChildRelationshipsInitialized() {
        return HibernateUtils.isInitialized(this.getSampleChildRelationships());
    }

    public void addChildRelationship(SampleRelationshipPE relationship) {
        relationship.setParentSample(this);
        this.getSampleChildRelationships().add(relationship);
    }

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="childSample", orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<SampleRelationshipPE> getSampleParentRelationships() {
        return this.parentRelationships;
    }

    private void setSampleParentRelationships(Set<SampleRelationshipPE> parentRelationships) {
        this.parentRelationships = parentRelationships;
    }

    @Transient
    public Set<SampleRelationshipPE> getParentRelationships() {
        return new UnmodifiableSetDecorator(this.getSampleParentRelationships());
    }

    @Transient
    public boolean isParentRelationshipsInitialized() {
        return HibernateUtils.isInitialized(this.getSampleParentRelationships());
    }

    public void setParentRelationships(Set<SampleRelationshipPE> parentRelationships) {
        this.getSampleParentRelationships().clear();
        for (SampleRelationshipPE sampleRelationship : parentRelationships) {
            SamplePE parent = sampleRelationship.getChildSample();
            if (parent != null) {
                parent.getSampleParentRelationships().remove(sampleRelationship);
            }
            this.addParentRelationship(sampleRelationship);
        }
    }

    public void addParentRelationship(SampleRelationshipPE relationship) {
        relationship.setChildSample(this);
        this.getSampleParentRelationships().add(relationship);
    }

    public void removeParentRelationship(SampleRelationshipPE relationship) {
        this.getSampleParentRelationships().remove(relationship);
        relationship.getParentSample().getSampleChildRelationships().remove(relationship);
        relationship.setChildSample(null);
        relationship.setParentSample(null);
    }

    public void removeDataSet(DataPE dataset) {
        this.getDatasetsInternal().remove(dataset);
        dataset.setSampleInternal(null);
    }

    public void addDataSet(DataPE dataset) {
        SamplePE sample = dataset.tryGetSample();
        if (sample != null) {
            sample.getDatasetsInternal().remove(dataset);
        }
        dataset.setSampleInternal(this);
        this.getDatasetsInternal().add(dataset);
    }

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="sampleInternal")
    private Set<DataPE> getDatasetsInternal() {
        return this.datasets;
    }

    private void setDatasetsInternal(Set<DataPE> datasets) {
        this.datasets = datasets;
    }

    @Transient
    public Set<DataPE> getDatasets() {
        return new UnmodifiableSetDecorator(this.getDatasetsInternal());
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }

    @Column(name="orig_del", nullable=false)
    public Integer getOriginalDeletion() {
        return this.originalDeletion;
    }

    public void setOriginalDeletion(Integer originalDeletion) {
        this.originalDeletion = originalDeletion;
    }

    @Transient
    public SampleIdentifier getSampleIdentifier() {
        if (this.sampleIdentifier == null) {
            this.sampleIdentifier = IdentifierHelper.createSampleIdentifier(this);
        }
        return this.sampleIdentifier;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="space_id", updatable=true)
    public SpacePE getSpace() {
        return this.space;
    }

    public void setSpace(SpacePE space) {
        this.space = space;
        if (space != null) {
            this.spaceFrozen = space.isFrozen() && space.isFrozenForSample();
        }
    }

    @NotNull
    @Column(name="space_frozen", nullable=false)
    public boolean isSpaceFrozen() {
        if (this.space != null) {
            this.spaceFrozen = this.space.isFrozen() && this.space.isFrozenForSample();
        }
        return this.spaceFrozen;
    }

    public void setSpaceFrozen(boolean spaceFrozen) {
        this.spaceFrozen = spaceFrozen;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Sample type can not be null.")
    @JoinColumn(name="saty_id", updatable=false)
    public SampleTypePE getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(SampleTypePE sampleType) {
        this.sampleType = sampleType;
    }

    @NotNull
    @Column(name="frozen", nullable=false)
    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @NotNull
    @Column(name="frozen_for_comp", nullable=false)
    public boolean isFrozenForComponent() {
        return this.frozenForComponent;
    }

    public void setFrozenForComponent(boolean frozenForComponent) {
        this.frozenForComponent = frozenForComponent;
    }

    @NotNull
    @Column(name="frozen_for_children", nullable=false)
    public boolean isFrozenForChildren() {
        return this.frozenForChildren;
    }

    public void setFrozenForChildren(boolean frozenForChildren) {
        this.frozenForChildren = frozenForChildren;
    }

    @NotNull
    @Column(name="frozen_for_parents", nullable=false)
    public boolean isFrozenForParents() {
        return this.frozenForParents;
    }

    public void setFrozenForParents(boolean frozenForParents) {
        this.frozenForParents = frozenForParents;
    }

    @NotNull
    @Column(name="frozen_for_data", nullable=false)
    public boolean isFrozenForDataSet() {
        return this.frozenForDataSet;
    }

    public void setFrozenForDataSet(boolean frozenForDataSets) {
        this.frozenForDataSet = frozenForDataSets;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="entity", orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=100)
    private Set<SamplePropertyPE> getSampleProperties() {
        return this.properties;
    }

    private void setSampleProperties(Set<SamplePropertyPE> properties) {
        this.properties = properties;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="samp_id_part_of", updatable=true)
    public SamplePE getContainer() {
        return this.container;
    }

    @Transient
    private Long getContainerId() {
        Long result = null;
        if (this.getContainer() != null) {
            result = HibernateUtils.getId(this.getContainer());
            assert (result != null);
        }
        return result;
    }

    public void setContainer(SamplePE container) {
        this.container = container;
        if (container != null) {
            this.containerFrozen = container.isFrozen() && container.isFrozenForComponent();
        }
        this.sampleIdentifier = null;
    }

    @NotNull
    @Column(name="cont_frozen", nullable=false)
    public boolean isContainerFrozen() {
        if (this.container != null) {
            this.containerFrozen = this.container.isFrozen() && this.container.isFrozenForComponent();
        }
        return this.containerFrozen;
    }

    public void setContainerFrozen(boolean containerFrozen) {
        this.containerFrozen = containerFrozen;
    }

    @Transient
    public SamplePE getTop() {
        List<SamplePE> parents = this.getParents();
        if (parents.size() == 1) {
            return parents.get(0).getTop();
        }
        return this;
    }

    @Transient
    public SamplePE getGeneratedFrom() {
        List<SamplePE> parents = this.getParents();
        if (parents.size() == 0) {
            return null;
        }
        if (parents.size() > 1) {
            throw new IllegalStateException("Sample " + this.getIdentifier() + " has more than one parent");
        }
        return parents.get(0);
    }

    @Transient
    public List<SamplePE> getParents() {
        Set<SampleRelationshipPE> relationships = this.getParentRelationships();
        ArrayList<SamplePE> parents = new ArrayList<SamplePE>();
        for (SampleRelationshipPE r : relationships) {
            assert (r.getChildSample().equals(this));
            if (!r.getRelationship().getCode().equals("$PARENT_CHILD")) continue;
            parents.add(r.getParentSample());
        }
        return parents;
    }

    @Transient
    public List<SamplePE> getChildren() {
        Set<SampleRelationshipPE> relationships = this.getChildRelationships();
        ArrayList<SamplePE> children = new ArrayList<SamplePE>();
        for (SampleRelationshipPE r : relationships) {
            assert (r.getParentSample().equals(this));
            if (!r.getRelationship().getCode().equals("$PARENT_CHILD")) continue;
            children.add(r.getChildSample());
        }
        return children;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="proj_id", updatable=true)
    private ProjectPE getProjectInternal() {
        return this.project;
    }

    @Private
    void setProjectInternal(ProjectPE project) {
        if (projectSamplesEnabled) {
            this.project = project;
            if (project != null) {
                this.projectFrozen = project.isFrozen() && project.isFrozenForExperiment();
            }
            this.sampleIdentifier = null;
        }
    }

    @Transient
    public ProjectPE getProject() {
        return this.getProjectInternal();
    }

    public void setProject(ProjectPE project) {
        if (projectSamplesEnabled) {
            if (project != null) {
                project.addSample(this);
            } else if (this.project != null) {
                this.project.removeSample(this);
                this.project = null;
            }
        }
    }

    @NotNull
    @Column(name="proj_frozen", nullable=false)
    public boolean isProjectFrozen() {
        if (this.project != null) {
            this.projectFrozen = this.project.isFrozen() && this.project.isFrozenForSample();
        }
        return this.projectFrozen;
    }

    public void setProjectFrozen(boolean projectFrozen) {
        this.projectFrozen = projectFrozen;
    }

    public void setExperiment(ExperimentPE experiment) {
        if (experiment != null) {
            experiment.addSample(this);
        } else {
            ExperimentPE previousExperiment = this.getExperiment();
            if (previousExperiment != null) {
                previousExperiment.removeSample(this);
            }
        }
    }

    @Transient
    public ExperimentPE getExperiment() {
        return this.getExperimentInternal();
    }

    void setExperimentInternal(ExperimentPE experiment) {
        this.experiment = experiment;
        if (experiment != null) {
            this.experimentFrozen = experiment.isFrozen() && experiment.isFrozenForSample();
        }
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="expe_id", updatable=true)
    private ExperimentPE getExperimentInternal() {
        return this.experiment;
    }

    @Transient
    private Long getExperimentId() {
        return this.getId(this.getExperimentInternal());
    }

    @NotNull
    @Column(name="expe_frozen", nullable=false)
    public boolean isExperimentFrozen() {
        if (this.experiment != null) {
            this.experimentFrozen = this.experiment.isFrozen() && this.experiment.isFrozenForSample();
        }
        return this.experimentFrozen;
    }

    public void setExperimentFrozen(boolean experimentFrozen) {
        if (this.experiment != null) {
            experimentFrozen = this.experiment.isFrozen() && this.experiment.isFrozenForSample();
        }
        this.experimentFrozen = experimentFrozen;
    }

    @Transient
    private Long getProjectId() {
        return this.getId(this.getProject());
    }

    @Transient
    private Long getSpaceId() {
        return this.getId(this.getSpace());
    }

    private Long getId(IIdHolder idHolder) {
        Long result = null;
        if (idHolder != null) {
            result = HibernateUtils.getId(idHolder);
            assert (result != null);
        }
        return result;
    }

    @SequenceGenerator(name="SAMPLE_ID_SEQ", sequenceName="SAMPLE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SAMPLE_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @NotNull(message="Code can not be null.")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public String getCode() {
        return this.code;
    }

    @Transient
    private String getFullCode() {
        return (this.getContainer() != null ? this.getContainer().getCode() + ":" : "") + this.getCode();
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_registerer", updatable=false)
    public PersonPE getRegistrator() {
        return this.registrator;
    }

    public void setRegistrator(PersonPE registrator) {
        this.registrator = registrator;
    }

    @Override
    @OptimisticLock(excluded=true)
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_modifier")
    public PersonPE getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifier(PersonPE modifier) {
        this.modifier = modifier;
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SamplePE)) {
            return false;
        }
        SamplePE that = (SamplePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getContainer(), (Object)that.getContainer());
        builder.append((Object)this.getSpace(), (Object)that.getSpace());
        builder.append((Object)this.getProject(), (Object)that.getProject());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getSpace());
        builder.append((Object)this.getProject());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("sampleType", (Object)this.getSampleType());
        return builder.toString();
    }

    @Override
    public final int compareTo(SamplePE o) {
        return this.getSampleIdentifier().compareTo(o.getSampleIdentifier());
    }

    @Transient
    public Set<SamplePropertyPE> getProperties() {
        return new UnmodifiableSetDecorator(this.getSampleProperties());
    }

    @Override
    @Transient
    public boolean isPropertiesInitialized() {
        return HibernateUtils.isInitialized(this.getSampleProperties());
    }

    @Override
    public void setProperties(Set<? extends EntityPropertyPE> properties) {
        this.getSampleProperties().clear();
        for (EntityPropertyPE entityPropertyPE : properties) {
            SamplePropertyPE sampleProperty = (SamplePropertyPE)entityPropertyPE;
            SamplePE parent = sampleProperty.getEntity();
            if (parent != null) {
                parent.getSampleProperties().remove(sampleProperty);
            }
            this.addProperty(sampleProperty);
        }
    }

    @Override
    public void addProperty(EntityPropertyPE property) {
        property.setEntity(this);
        property.setEntityFrozen(this.isFrozen());
        this.getSampleProperties().add((SamplePropertyPE)property);
    }

    @Override
    public void removeProperty(EntityPropertyPE property) {
        this.getSampleProperties().remove(property);
        property.setEntity(null);
    }

    @Override
    @OptimisticLock(excluded=true)
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Version
    @Column(name="version", nullable=false)
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Transient
    public final String getIdentifier() {
        return this.getSampleIdentifier().toString();
    }

    @Override
    @Transient
    public final EntityTypePE getEntityType() {
        return this.getSampleType();
    }

    @Override
    @Transient
    public final EntityKind getEntityKind() {
        return EntityKind.SAMPLE;
    }

    @Override
    @Transient
    public AttachmentHolderKind getAttachmentHolderKind() {
        return AttachmentHolderKind.SAMPLE;
    }

    @Override
    @OneToMany(fetch=FetchType.LAZY, mappedBy="sampleParentInternal", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    protected Set<AttachmentPE> getInternalAttachments() {
        return this.attachments;
    }

    @Override
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Column(name="perm_id", nullable=false)
    public String getPermId() {
        return this.permId;
    }

    public void setPermId(String permId) {
        this.permId = permId;
    }

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="container")
    public List<SamplePE> getContained() {
        return this.contained;
    }

    public void setContained(List<SamplePE> contained) {
        this.contained = contained;
    }

    @Transient
    public List<SamplePE> getGenerated() {
        Set<SampleRelationshipPE> relationships = this.getChildRelationships();
        ArrayList<SamplePE> samples = new ArrayList<SamplePE>();
        for (SampleRelationshipPE r : relationships) {
            assert (r.getParentSample().equals(this));
            if (!r.getRelationship().getCode().equals("$PARENT_CHILD")) continue;
            samples.add(r.getChildSample());
        }
        return samples;
    }

    @Transient
    public Map<RelationshipTypePE, Set<SamplePE>> getParentsMap() {
        HashMap<RelationshipTypePE, Set<SamplePE>> map = new HashMap<RelationshipTypePE, Set<SamplePE>>();
        for (SampleRelationshipPE r : this.getParentRelationships()) {
            RelationshipTypePE type = r.getRelationship();
            if (map.get(type) == null) {
                map.put(type, new HashSet());
            }
            ((Set)map.get(type)).add(r.getParentSample());
        }
        return map;
    }

    @Override
    public void addMetaproject(MetaprojectPE metaprojectPE) {
        if (metaprojectPE == null) {
            throw new IllegalArgumentException("Metaproject cannot be null");
        }
        MetaprojectAssignmentPE assignmentPE = new MetaprojectAssignmentPE();
        assignmentPE.setMetaproject(metaprojectPE);
        assignmentPE.setSample(this);
        this.getMetaprojectAssignmentsInternal().add(assignmentPE);
        metaprojectPE.getAssignmentsInternal().add(assignmentPE);
    }

    @Override
    public void removeMetaproject(MetaprojectPE metaprojectPE) {
        if (metaprojectPE == null) {
            throw new IllegalArgumentException("Metaproject cannot be null");
        }
        MetaprojectAssignmentPE assignmentPE = new MetaprojectAssignmentPE();
        assignmentPE.setMetaproject(metaprojectPE);
        assignmentPE.setSample(this);
        this.getMetaprojectAssignmentsInternal().remove(assignmentPE);
        metaprojectPE.getAssignmentsInternal().remove(assignmentPE);
    }

    @Override
    @Transient
    public Set<MetaprojectPE> getMetaprojects() {
        HashSet<MetaprojectPE> metaprojects = new HashSet<MetaprojectPE>();
        for (MetaprojectAssignmentPE assignment : this.getMetaprojectAssignmentsInternal()) {
            metaprojects.add(assignment.getMetaproject());
        }
        return new UnmodifiableSetDecorator(metaprojects);
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="sample")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<MetaprojectAssignmentPE> getMetaprojectAssignmentsInternal() {
        return this.metaprojectAssignments;
    }

    private void setMetaprojectAssignmentsInternal(Set<MetaprojectAssignmentPE> metaprojectAssignments) {
        this.metaprojectAssignments = metaprojectAssignments;
    }
}

