/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="sample_types", uniqueConstraints={@UniqueConstraint(columnNames={"code"})})
public final class SampleTypePE
extends EntityTypePE {
    private static final long serialVersionUID = 35L;
    private Set<SampleTypePropertyTypePE> sampleTypePropertyTypes = new HashSet<SampleTypePropertyTypePE>();
    private Boolean listable;
    private Integer generatedFromHierarchyDepth;
    private Integer containerHierarchyDepth;
    private Boolean subcodeUnique;
    private Boolean autoGeneratedCode;
    private Boolean showParentMetadata;
    private String generatedCodePrefix;

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="entityTypeInternal", orphanRemoval=true)
    private Set<SampleTypePropertyTypePE> getSampleTypePropertyTypesInternal() {
        return this.sampleTypePropertyTypes;
    }

    private void setSampleTypePropertyTypesInternal(Set<SampleTypePropertyTypePE> sampleTypePropertyTypes) {
        this.sampleTypePropertyTypes = sampleTypePropertyTypes;
    }

    @Transient
    public Set<SampleTypePropertyTypePE> getSampleTypePropertyTypes() {
        return this.getSampleTypePropertyTypesInternal();
    }

    public final void setSampleTypePropertyTypes(Set<SampleTypePropertyTypePE> sampleTypePropertyTypes) {
        this.getSampleTypePropertyTypesInternal().clear();
        for (SampleTypePropertyTypePE child : sampleTypePropertyTypes) {
            this.addSampleTypePropertyType(child);
        }
    }

    public void addSampleTypePropertyType(SampleTypePropertyTypePE child) {
        SampleTypePE parent = (SampleTypePE)child.getEntityType();
        if (parent != null) {
            parent.getSampleTypePropertyTypesInternal().remove(child);
        }
        child.setEntityTypeInternal(this);
        this.getSampleTypePropertyTypesInternal().add(child);
    }

    @Column(name="IS_LISTABLE")
    public Boolean isListable() {
        return this.listable;
    }

    public void setListable(Boolean listable) {
        this.listable = listable;
    }

    @Column(name="is_subcode_unique")
    public Boolean isSubcodeUnique() {
        return this.subcodeUnique;
    }

    public void setSubcodeUnique(Boolean uniqueCode) {
        this.subcodeUnique = uniqueCode;
    }

    @Column(name="is_auto_generated_code")
    public Boolean isAutoGeneratedCode() {
        return this.autoGeneratedCode;
    }

    public void setAutoGeneratedCode(Boolean autoGeneratedCode) {
        this.autoGeneratedCode = autoGeneratedCode;
    }

    @Column(name="show_parent_metadata")
    public Boolean isShowParentMetadata() {
        return this.showParentMetadata;
    }

    public void setShowParentMetadata(Boolean showParentMetadata) {
        this.showParentMetadata = showParentMetadata;
    }

    @Column(name="generated_code_prefix")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @NotNull(message="Generated code prefix can not be null.")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public String getGeneratedCodePrefix() {
        return this.generatedCodePrefix;
    }

    public void setGeneratedCodePrefix(String generatedCodePrefix) {
        this.generatedCodePrefix = generatedCodePrefix;
    }

    @Column(name="generated_from_depth")
    public Integer getGeneratedFromHierarchyDepth() {
        return this.generatedFromHierarchyDepth;
    }

    public void setGeneratedFromHierarchyDepth(Integer generatedFromHierarchyDepth) {
        this.generatedFromHierarchyDepth = generatedFromHierarchyDepth;
    }

    @Column(name="part_of_depth")
    public Integer getContainerHierarchyDepth() {
        return this.containerHierarchyDepth;
    }

    public void setContainerHierarchyDepth(Integer partOfHierarchyDepth) {
        this.containerHierarchyDepth = partOfHierarchyDepth;
    }

    @SequenceGenerator(name="SAMPLE_TYPE_ID_SEQ", sequenceName="SAMPLE_TYPE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SAMPLE_TYPE_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @Override
    final ToStringBuilder createStringBuilder() {
        ToStringBuilder builder = super.createStringBuilder();
        builder.append("listable", (Object)this.isListable());
        builder.append("containerHierarchyDepth", (Object)this.getContainerHierarchyDepth());
        builder.append("generatedFromHierarchyDepth", (Object)this.getGeneratedFromHierarchyDepth());
        return builder;
    }

    @Override
    @Transient
    public EntityKind getEntityKind() {
        return EntityKind.SAMPLE;
    }

    @Override
    @Transient
    public Collection<? extends EntityTypePropertyTypePE> getEntityTypePropertyTypes() {
        return this.getSampleTypePropertyTypes();
    }
}

