/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePropertyTypePE;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="semantic_annotations")
public class SemanticAnnotationPE
implements IIdHolder,
IIdentityHolder,
Serializable {
    private static final long serialVersionUID = 35L;
    private Long id;
    private String permId;
    private SampleTypePE sampleType;
    private SampleTypePropertyTypePE sampleTypePropertyType;
    private PropertyTypePE propertyType;
    private String predicateOntologyId;
    private String predicateOntologyVersion;
    private String predicateAccessionId;
    private String descriptorOntologyId;
    private String descriptorOntologyVersion;
    private String descriptorAccessionId;
    private Date creationDate;

    @SequenceGenerator(name="SEMANTIC_ANNOTATION_ID_SEQ", sequenceName="SEMANTIC_ANNOTATION_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEMANTIC_ANNOTATION_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="perm_id")
    public String getPermId() {
        return this.permId;
    }

    public void setPermId(String permId) {
        this.permId = permId;
    }

    @Transient
    public String getIdentifier() {
        return this.getPermId();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="saty_id", updatable=false)
    public SampleTypePE getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(SampleTypePE sampleType) {
        this.sampleType = sampleType;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="stpt_id", updatable=false)
    public SampleTypePropertyTypePE getSampleTypePropertyType() {
        return this.sampleTypePropertyType;
    }

    public void setSampleTypePropertyType(SampleTypePropertyTypePE sampleTypePropertyType) {
        this.sampleTypePropertyType = sampleTypePropertyType;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="prty_id", updatable=false)
    public PropertyTypePE getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyTypePE propertyType) {
        this.propertyType = propertyType;
    }

    @Column(name="predicate_ontology_id")
    public String getPredicateOntologyId() {
        return this.predicateOntologyId;
    }

    public void setPredicateOntologyId(String predicateOntologyId) {
        this.predicateOntologyId = predicateOntologyId;
    }

    @Column(name="predicate_ontology_version")
    public String getPredicateOntologyVersion() {
        return this.predicateOntologyVersion;
    }

    public void setPredicateOntologyVersion(String predicateOntologyVersion) {
        this.predicateOntologyVersion = predicateOntologyVersion;
    }

    @Column(name="predicate_accession_id")
    public String getPredicateAccessionId() {
        return this.predicateAccessionId;
    }

    public void setPredicateAccessionId(String predicateAccessionId) {
        this.predicateAccessionId = predicateAccessionId;
    }

    @Column(name="descriptor_ontology_id")
    public String getDescriptorOntologyId() {
        return this.descriptorOntologyId;
    }

    public void setDescriptorOntologyId(String descriptorOntologyId) {
        this.descriptorOntologyId = descriptorOntologyId;
    }

    @Column(name="descriptor_ontology_version")
    public String getDescriptorOntologyVersion() {
        return this.descriptorOntologyVersion;
    }

    public void setDescriptorOntologyVersion(String descriptorOntologyVersion) {
        this.descriptorOntologyVersion = descriptorOntologyVersion;
    }

    @Column(name="descriptor_accession_id")
    public String getDescriptorAccessionId() {
        return this.descriptorAccessionId;
    }

    public void setDescriptorAccessionId(String descriptorAccessionId) {
        this.descriptorAccessionId = descriptorAccessionId;
    }

    @Column(name="creation_date", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public Date getCreationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.creationDate);
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SemanticAnnotationPE)) {
            return false;
        }
        SemanticAnnotationPE that = (SemanticAnnotationPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getPermId(), (Object)that.getPermId());
        builder.append((Object)this.getPredicateOntologyId(), (Object)that.getPredicateOntologyId());
        builder.append((Object)this.getPredicateOntologyVersion(), (Object)that.getPredicateOntologyVersion());
        builder.append((Object)this.getPredicateAccessionId(), (Object)that.getPredicateAccessionId());
        builder.append((Object)this.getDescriptorOntologyId(), (Object)that.getDescriptorOntologyId());
        builder.append((Object)this.getDescriptorOntologyVersion(), (Object)that.getDescriptorOntologyVersion());
        builder.append((Object)this.getDescriptorAccessionId(), (Object)that.getDescriptorAccessionId());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getPermId());
        builder.append((Object)this.getPredicateOntologyId());
        builder.append((Object)this.getPredicateOntologyVersion());
        builder.append((Object)this.getPredicateAccessionId());
        builder.append((Object)this.getDescriptorOntologyId());
        builder.append((Object)this.getDescriptorOntologyVersion());
        builder.append((Object)this.getDescriptorAccessionId());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("predicateOntologyId", (Object)this.getPredicateOntologyId());
        builder.append("predicateOntologyVersion", (Object)this.getPredicateOntologyVersion());
        builder.append("predicateAccessionId", (Object)this.getPredicateAccessionId());
        builder.append("descriptorOntologyId", (Object)this.getDescriptorOntologyId());
        builder.append("descriptorOntologyVersion", (Object)this.getDescriptorOntologyVersion());
        builder.append("descriptorAccessionId", (Object)this.getDescriptorAccessionId());
        return builder.toString();
    }
}

