/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.authentication.BasicSession;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.time.DateFormatUtils;

public final class Session
extends BasicSession
implements IAuthSession {
    private static final String BASE_URL_FALLBACK = "http://localhost/openbis/index.html";
    private static final long serialVersionUID = 1L;
    private PersonPE personOrNull;
    private PersonPE creatorPersonOrNull;
    private String baseIndexURL;
    private final Set<ISessionCleaner> cleanupListeners = new LinkedHashSet<ISessionCleaner>();

    @Deprecated
    public Session() {
    }

    public Session(String user, String sessionToken, Principal principal, String remoteHost, long sessionStart) {
        this(user, sessionToken, principal, remoteHost, sessionStart, 0);
    }

    public Session(String userName, String sessionToken, Principal principal, String remoteHost, long sessionStart, int expirationTime) {
        super(sessionToken, userName, principal, remoteHost, sessionStart, expirationTime);
    }

    public void cleanup() {
        super.cleanup();
        for (ISessionCleaner cleaner : this.cleanupListeners) {
            cleaner.cleanup();
        }
    }

    public final void setPerson(PersonPE person) {
        this.personOrNull = person;
    }

    public final void setCreatorPerson(PersonPE creatorPerson) {
        this.creatorPersonOrNull = creatorPerson;
    }

    @Override
    public final PersonPE tryGetPerson() {
        return this.personOrNull;
    }

    @Override
    public final PersonPE tryGetCreatorPerson() {
        return this.creatorPersonOrNull;
    }

    public final SpacePE tryGetHomeGroup() {
        if (this.personOrNull == null) {
            return null;
        }
        return this.personOrNull.getHomeSpace();
    }

    @Override
    public final String tryGetHomeGroupCode() {
        SpacePE homeGroup = this.tryGetHomeGroup();
        if (homeGroup == null) {
            return null;
        }
        return homeGroup.getCode();
    }

    public final String getBaseIndexURL() {
        return this.baseIndexURL != null ? this.baseIndexURL : BASE_URL_FALLBACK;
    }

    public final void setBaseIndexURL(String baseIndexURL) {
        this.baseIndexURL = baseIndexURL;
    }

    @Deprecated
    public PersonPE getPerson() {
        return this.personOrNull;
    }

    @Override
    public String getUserName() {
        return this.personOrNull == null ? super.getUserName() : this.personOrNull.getUserId();
    }

    public void addCleanupListener(ISessionCleaner sessionCleaner) {
        this.cleanupListeners.add(sessionCleaner);
    }

    public void removeCleanupListener(ISessionCleaner sessionCleaner) {
        this.cleanupListeners.remove(sessionCleaner);
    }

    public final String toString() {
        return "Session{user=" + this.getUserName() + ",space=" + this.tryGetHomeGroupCode() + ",sessionstart=" + DateFormatUtils.format((long)this.getSessionStart(), (String)"yyyy-MM-dd HH:mm:ss") + "}";
    }

    public String getUserEmail() {
        return this.personOrNull == null ? this.getPrincipal().getEmail() : this.personOrNull.getEmail();
    }

    public boolean isOnBehalfSession() {
        String creatorUserId;
        String personUserId = this.tryGetPerson() != null ? this.tryGetPerson().getUserId() : null;
        String string = creatorUserId = this.tryGetCreatorPerson() != null ? this.tryGetCreatorPerson().getUserId() : null;
        boolean areEqual = personUserId == null ? creatorUserId == null : personUserId.equals(creatorUserId);
        return !areEqual;
    }

    public static interface ISessionCleaner {
        public void cleanup();
    }
}

