/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="spaces", uniqueConstraints={@UniqueConstraint(columnNames={"code"})})
public final class SpacePE
extends HibernateAbstractRegistrationHolder
implements IIdAndCodeHolder,
IIdentityHolder,
Comparable<SpacePE>,
Serializable {
    private static final long serialVersionUID = 35L;
    public static final SpacePE[] EMPTY_ARRAY = new SpacePE[0];
    private transient Long id;
    private String code;
    private boolean frozen;
    private boolean frozenForProject;
    private boolean frozenForSample;
    private String description;
    private Boolean home;
    private Date modificationDate;
    private List<ProjectPE> projects = new ArrayList<ProjectPE>();
    private List<SamplePE> samples = new ArrayList<SamplePE>();

    public final void setCode(String code) {
        this.code = code;
    }

    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @Override
    @Transient
    public String getPermId() {
        return this.code;
    }

    @Transient
    public String getIdentifier() {
        return new SpaceIdentifier(this.code).toString();
    }

    @Transient
    public final Boolean isHome() {
        return this.home;
    }

    public final void setHome(Boolean home) {
        this.home = home;
    }

    @NotNull
    @Column(name="frozen", nullable=false)
    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @NotNull
    @Column(name="frozen_for_proj", nullable=false)
    public boolean isFrozenForProject() {
        return this.frozenForProject;
    }

    public void setFrozenForProject(boolean frozenForProject) {
        this.frozenForProject = frozenForProject;
    }

    @NotNull
    @Column(name="frozen_for_samp", nullable=false)
    public boolean isFrozenForSample() {
        return this.frozenForSample;
    }

    public void setFrozenForSample(boolean frozenForSample) {
        this.frozenForSample = frozenForSample;
    }

    @Version
    @Column(name="registration_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @SequenceGenerator(name="SPACE_ID_SEQ", sequenceName="SPACE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SPACE_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @NotNull(message="Code can not be null.")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public final String getCode() {
        return this.code;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpacePE)) {
            return false;
        }
        SpacePE that = (SpacePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("description", (Object)this.getDescription());
        builder.append("home", (Object)this.isHome());
        return builder.toString();
    }

    @Override
    public final int compareTo(SpacePE o) {
        return AbstractIdAndCodeHolder.compare(this, o);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="space")
    public List<ProjectPE> getProjects() {
        return this.projects;
    }

    private void setProjects(List<ProjectPE> projects) {
        this.projects = projects;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="space")
    public List<SamplePE> getSamples() {
        return this.samples;
    }

    private void setSamples(List<SamplePE> samples) {
        this.samples = samples;
    }
}

