/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="controlled_vocabulary_terms", uniqueConstraints={@UniqueConstraint(columnNames={"code", "covo_id"})})
public class VocabularyTermPE
extends HibernateAbstractRegistrationHolder
implements IIdAndCodeHolder,
Comparable<VocabularyTermPE>,
Serializable {
    private static final long serialVersionUID = 35L;
    public static final VocabularyTermPE[] EMPTY_ARRAY = new VocabularyTermPE[0];
    private transient Long id;
    private String code;
    private String label;
    private String description;
    private Long ordinal;
    private Boolean isOfficial;
    private VocabularyPE vocabulary;
    private Date modificationDate;

    @NotNull(message="Code can not be null.")
    @Length(min=1, max=50, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.:]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given term code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and '_', '-', ':', '.')")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = CodeConverter.tryToDatabase(code);
    }

    @Version
    @Column(name="registration_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descriptionOrNull) {
        this.description = descriptionOrNull;
    }

    @Column(name="label")
    @Length(max=128, message="Given label '%s' is too long (maximal length: {max} characters).")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Column(name="ordinal")
    @NotNull(message="Ordinal can not be null.")
    public Long getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Long ordinal) {
        this.ordinal = ordinal;
    }

    @Column(name="is_official")
    public Boolean isOfficial() {
        return this.isOfficial;
    }

    public void setOfficial(Boolean isOfficial) {
        this.isOfficial = isOfficial;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SequenceGenerator(name="CVTE_ID_SEQ", sequenceName="CVTE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CVTE_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    @NotNull(message="Vocabulary can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="covo_id", updatable=false)
    private VocabularyPE getVocabularyInternal() {
        return this.vocabulary;
    }

    void setVocabularyInternal(VocabularyPE vocabulary) {
        this.vocabulary = vocabulary;
    }

    public void setVocabulary(VocabularyPE vocabulary) {
        if (vocabulary == null) {
            if (this.getVocabulary() != null) {
                this.getVocabulary().removeTerm(this);
            }
        } else {
            vocabulary.addTerm(this);
        }
    }

    @Transient
    public VocabularyPE getVocabulary() {
        return this.getVocabularyInternal();
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        EqualsHashUtils.assertDefined(this.getVocabulary(), "vocabulary");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VocabularyTermPE)) {
            return false;
        }
        VocabularyTermPE that = (VocabularyTermPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getVocabulary(), (Object)that.getVocabulary());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getVocabulary());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("label", (Object)this.getLabel());
        return builder.toString();
    }

    @Override
    public final int compareTo(VocabularyTermPE o) {
        return this.getOrdinal().compareTo(o.getOrdinal());
    }

    @Transient
    public String getUrl() {
        String template = this.getVocabulary().getURLTemplate();
        if (null == template) {
            return null;
        }
        String url = template.replaceAll(BasicConstant.DEPRECATED_VOCABULARY_URL_TEMPLATE_TERM_PATTERN, this.getCode());
        url = url.replaceAll(BasicConstant.VOCABULARY_URL_TEMPLATE_TERM_PATTERN, this.getCode());
        return url;
    }
}

