/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ExperimentIdentifier
extends ProjectIdentifier {
    private static final long serialVersionUID = 35L;
    static final String CODE_SEPARATOR = "/";
    private String experimentCode;

    public ExperimentIdentifier(Experiment experiment) {
        this(experiment.getProject().getSpace().getCode(), experiment.getProject().getCode(), experiment.getCode());
    }

    public ExperimentIdentifier() {
        this(null, null, null);
    }

    public ExperimentIdentifier(ProjectIdentifier projectIdentifier, String experimentCode) {
        this(projectIdentifier.getSpaceCode(), projectIdentifier.getProjectCode(), experimentCode);
    }

    public ExperimentIdentifier(String projectCode, String experimentCode) {
        this(ExperimentIdentifier.getHomeSpaceCode(), projectCode, experimentCode);
    }

    public ExperimentIdentifier(String groupCode, String projectCode, String experimentCode) {
        super(groupCode, projectCode);
        this.setExperimentCode(experimentCode);
    }

    public String getExperimentCode() {
        return StringUtils.upperCase((String)this.experimentCode);
    }

    public void setExperimentCode(String experimentCode) {
        this.experimentCode = experimentCode;
    }

    public final String describe() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getProjectCode());
        builder.append(CODE_SEPARATOR);
        builder.append(this.getExperimentCode());
        return builder.toString();
    }

    @Override
    public final String toString() {
        return super.toString() + '/' + this.experimentCode;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExperimentIdentifier)) {
            return false;
        }
        ExperimentIdentifier that = (ExperimentIdentifier)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getSpaceCode(), (Object)that.getSpaceCode());
        builder.append((Object)this.getProjectCode(), (Object)that.getProjectCode());
        builder.append((Object)this.getExperimentCode(), (Object)that.getExperimentCode());
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getSpaceCode());
        builder.append((Object)this.getProjectCode());
        builder.append((Object)this.getExperimentCode());
        return builder.toHashCode();
    }
}

