/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.AbstractIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifierFactory;

public final class ProjectIdentifierFactory
extends AbstractIdentifierFactory {
    public ProjectIdentifierFactory(String textToParse) {
        super(textToParse);
    }

    public static ProjectIdentifier tryGetProjectIdentifier(Sample sample) {
        Project project = sample.getProject();
        if (project == null) {
            return null;
        }
        return ProjectIdentifierFactory.parse(project.getIdentifier());
    }

    public final ProjectIdentifier createIdentifier() throws UserFailureException {
        return ProjectIdentifierFactory.parse(this.getTextToParse(), null);
    }

    public final ProjectIdentifier createIdentifier(String defaultSpace) throws UserFailureException {
        return ProjectIdentifierFactory.parse(this.getTextToParse(), defaultSpace);
    }

    public static ProjectIdentifier parse(String text) {
        return ProjectIdentifierFactory.parse(text, null);
    }

    public static ProjectIdentifier parse(String text, String defaultSpace) {
        AbstractIdentifierFactory.TokenLexer lexer = new AbstractIdentifierFactory.TokenLexer(text);
        ProjectIdentifier projectIdentifier = ProjectIdentifierFactory.parseIdentifier(lexer, defaultSpace);
        lexer.ensureNoTokensLeft();
        return projectIdentifier;
    }

    public static ProjectIdentifier parseIdentifier(AbstractIdentifierFactory.TokenLexer lexer, String defaultSpace) {
        SpaceIdentifier spaceIdentifier = ProjectIdentifierFactory.parseSpace(lexer, defaultSpace);
        String projectCode = ProjectIdentifierFactory.assertValidCode(lexer.next());
        return ProjectIdentifierFactory.create(spaceIdentifier, projectCode);
    }

    private static SpaceIdentifier parseSpace(AbstractIdentifierFactory.TokenLexer lexer, String defaultSpace) {
        String firstToken = lexer.peek();
        if (firstToken.length() > 0) {
            if (defaultSpace == null) {
                return SpaceIdentifier.createHome();
            }
            return new SpaceIdentifierFactory(defaultSpace).createIdentifier();
        }
        return SpaceIdentifierFactory.parseIdentifier(lexer);
    }

    private static ProjectIdentifier create(SpaceIdentifier spaceIdentifier, String projectCode) {
        return new ProjectIdentifier(spaceIdentifier.getSpaceCode(), projectCode);
    }

    public static String getSchema() {
        return "[" + SpaceIdentifierFactory.getSchema() + '/' + "]<project-code>";
    }
}

