/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.AbstractIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierPattern;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifierFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class SampleIdentifierFactory
extends AbstractIdentifierFactory {
    public static final SampleIdentifier parse(String textToParse) throws UserFailureException {
        return new SampleIdentifierFactory(textToParse).createIdentifier(null);
    }

    public static final SampleIdentifier parse(Sample sample) throws UserFailureException {
        return new SampleIdentifierFactory(sample.getIdentifier()).createIdentifier(null);
    }

    public static final SampleIdentifier parse(NewSample sample) throws UserFailureException {
        SampleIdentifierFactory factory = new SampleIdentifierFactory(sample.getIdentifier());
        String defaultSpace = sample.getDefaultSpaceIdentifier();
        SampleIdentifier identifier = factory.createIdentifier(defaultSpace);
        String currentContainer = sample.getCurrentContainerIdentifier();
        if (!StringUtils.isEmpty((CharSequence)currentContainer) && !StringUtils.isBlank((CharSequence)identifier.tryGetContainerCode())) {
            throw new UserFailureException("Current container is specified, but the identifier '" + sample.getIdentifier() + "' includes the container code.");
        }
        if (identifier.tryGetContainerCode() == null && !StringUtils.isEmpty((CharSequence)currentContainer)) {
            SampleIdentifier defaultContainerIdentifier = SampleIdentifierFactory.parse(currentContainer, defaultSpace);
            identifier.addContainerCode(defaultContainerIdentifier.getSampleSubCode());
        }
        return identifier;
    }

    public static final SampleIdentifier parse(String textToParse, String defaultSpace) throws UserFailureException {
        return new SampleIdentifierFactory(textToParse).createIdentifier(defaultSpace);
    }

    public static final SampleIdentifierPattern parsePattern(String textToParse) throws UserFailureException {
        return new SampleIdentifierFactory(textToParse).createPattern();
    }

    public SampleIdentifierFactory(String textToParse) {
        super(textToParse);
    }

    public final SampleIdentifier createIdentifier() throws UserFailureException {
        return this.createIdentifier(null);
    }

    public final SampleIdentifier createIdentifier(String defaultSpace) throws UserFailureException {
        SampleIdentifierOrPattern ident = SampleIdentifierFactory.parse(this.getTextToParse(), defaultSpace, false);
        return SampleIdentifier.createOwnedBy(ident.getOwner(), ident.getCode());
    }

    private SampleIdentifierPattern createPattern() {
        SampleIdentifierOrPattern ident = SampleIdentifierFactory.parse(this.getTextToParse(), null, true);
        return SampleIdentifierPattern.createOwnedBy(ident.getOwner(), ident.getCode());
    }

    private static SampleIdentifierOrPattern parse(String text, String defaultSpace, boolean isPattern) {
        Object[] tokens = text.split("/");
        if (tokens.length == 0) {
            throw new UserFailureException("Illegal empty identifier");
        }
        String sampleCode = tokens[tokens.length - 1];
        String[] ownerTokens = (String[])ArrayUtils.subarray((Object[])tokens, (int)0, (int)(tokens.length - 1));
        SampleOwnerIdentifier owner = SampleIdentifierFactory.parseSampleOwner(ownerTokens, text, defaultSpace);
        SampleIdentifierFactory.validateSampleCode(sampleCode, isPattern);
        return new SampleIdentifierOrPattern(sampleCode, owner);
    }

    private static void validateSampleCode(String sampleCode, boolean isPattern) {
        String[] sampleCodeTokens = sampleCode.split(":");
        if (sampleCodeTokens.length > 2) {
            throw UserFailureException.fromTemplate((String)"The code '%s' contains illegal characters.", (Object[])new Object[]{sampleCode});
        }
        for (String token : sampleCodeTokens) {
            SampleIdentifierFactory.validateSampleCodeToken(token, isPattern);
        }
    }

    private static void validateSampleCodeToken(String token, boolean isPattern) {
        if (isPattern) {
            SampleIdentifierFactory.assertValidPatternCharacters(token);
        } else {
            SampleIdentifierFactory.assertValidCode(token);
        }
    }

    private static SampleOwnerIdentifier parseSampleOwner(String[] tokens, String originalText, String defaultSpace) {
        if (tokens.length == 0) {
            return SampleIdentifierFactory.getDefaultSpaceIdentifier(defaultSpace);
        }
        String firstToken = tokens[0];
        if (firstToken.length() == 0) {
            if (tokens.length == 2 && tokens[1].length() == 0) {
                return SampleIdentifierFactory.getDefaultSpaceIdentifier(defaultSpace);
            }
            return SampleIdentifierFactory.continueParsingSampleOwner(tokens, originalText);
        }
        throw SampleIdentifierFactory.createSlashMissingExcp(originalText);
    }

    private static SampleOwnerIdentifier getDefaultSpaceIdentifier(String defaultSpace) {
        if (defaultSpace == null) {
            return new SampleOwnerIdentifier(SpaceIdentifier.createHome());
        }
        return new SampleOwnerIdentifier(new SpaceIdentifierFactory(defaultSpace).createIdentifier());
    }

    private static SampleOwnerIdentifier continueParsingSampleOwner(String[] tokens, String originalText) {
        if (tokens.length == 1) {
            return new SampleOwnerIdentifier();
        }
        if (tokens.length == 2) {
            String spaceCode = tokens[1];
            return new SampleOwnerIdentifier(new SpaceIdentifier(SampleIdentifierFactory.assertValidCode(spaceCode)));
        }
        if (tokens.length == 3) {
            String spaceCode = tokens[1];
            String projectCode = tokens[2];
            return new SampleOwnerIdentifier(new ProjectIdentifier(SampleIdentifierFactory.assertValidCode(spaceCode), SampleIdentifierFactory.assertValidCode(projectCode)));
        }
        throw SampleIdentifierFactory.createTooManyTokensExcp(originalText);
    }

    private static class SampleIdentifierOrPattern {
        private final String code;
        private final SampleOwnerIdentifier owner;

        public SampleIdentifierOrPattern(String code, SampleOwnerIdentifier owner) {
            this.code = code;
            this.owner = owner;
        }

        public String getCode() {
            return this.code;
        }

        public SampleOwnerIdentifier getOwner() {
            return this.owner;
        }
    }
}

