/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.string.StringUtilities;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SpaceIdentifier
implements Comparable<SpaceIdentifier>,
Serializable {
    private static final long serialVersionUID = 35L;
    private String spaceCodeOrNull;

    public static SpaceIdentifier createHome() {
        return new SpaceIdentifier(SpaceIdentifier.getHomeSpaceCode());
    }

    public SpaceIdentifier(String spaceCode) {
        this.setSpaceCode(spaceCode);
    }

    public final String getSpaceCode() {
        return StringUtils.upperCase((String)this.spaceCodeOrNull);
    }

    public final void setSpaceCode(String spaceCode) {
        this.spaceCodeOrNull = spaceCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpaceIdentifier)) {
            return false;
        }
        SpaceIdentifier that = (SpaceIdentifier)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getSpaceCode(), (Object)that.getSpaceCode());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getSpaceCode());
        return builder.toHashCode();
    }

    public String toString() {
        return '/' + this.spaceCodeOrNull;
    }

    protected static String getHomeSpaceCode() {
        return SpaceCodeHelper.HOME_SPACE_CODE;
    }

    public boolean isHomeSpace() {
        return SpaceCodeHelper.isHomeSpace(this.spaceCodeOrNull);
    }

    private SpaceIdentifier() {
    }

    @Override
    public final int compareTo(SpaceIdentifier other) {
        return StringUtilities.compareNullable((String)this.getSpaceCode(), (String)other.getSpaceCode());
    }

    public static final class Constants {
        public static final char IDENTIFIER_SEPARATOR = '/';
    }
}

