/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.AbstractIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;

public final class SpaceIdentifierFactory
extends AbstractIdentifierFactory {
    public SpaceIdentifierFactory(String textToParse) throws UserFailureException {
        super(textToParse);
    }

    public final SpaceIdentifier createIdentifier() throws UserFailureException {
        return SpaceIdentifierFactory.parseSpaceIdentifier(this.getTextToParse());
    }

    private static SpaceIdentifier parseSpaceIdentifier(String text) {
        AbstractIdentifierFactory.TokenLexer lexer = new AbstractIdentifierFactory.TokenLexer(text);
        SpaceIdentifier SpaceIdentifier2 = SpaceIdentifierFactory.parseIdentifier(lexer);
        lexer.ensureNoTokensLeft();
        return SpaceIdentifier2;
    }

    public static SpaceIdentifier parseIdentifier(AbstractIdentifierFactory.TokenLexer lexer) {
        String firstToken = lexer.peek();
        if (firstToken.length() > 0) {
            throw SpaceIdentifierFactory.createSlashMissingExcp(lexer.getOriginalText());
        }
        lexer.next();
        String groupCodeOrNull = lexer.next();
        if (groupCodeOrNull.length() == 0) {
            groupCodeOrNull = null;
        } else {
            SpaceIdentifierFactory.assertValidCode(groupCodeOrNull);
        }
        return new SpaceIdentifier(groupCodeOrNull);
    }

    public static String getSchema() {
        return "/<space-code>";
    }
}

