/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins;

import ch.ethz.cisd.hotdeploy.PluginEvent;
import ch.ethz.cisd.hotdeploy.PluginEventListener;
import ch.ethz.cisd.hotdeploy.PluginMapHolder;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.server.IHotDeploymentController;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.ICommonPropertyBasedHotDeployPluginFactory;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.ICommonPropertyBasedHotDeployPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractCommonPropertyBasedHotDeployPluginFactory<T extends ICommonPropertyBasedHotDeployPlugin>
implements ICommonPropertyBasedHotDeployPluginFactory<T> {
    private static final String DEFAULT_PLUGINS_LOCATION = "../../entity-related-plugins/";
    private PluginMapHolder<T> predeployedPlugins;
    private final String pluginDirectoryPath;
    private IHotDeploymentController hotDeploymentController;

    public AbstractCommonPropertyBasedHotDeployPluginFactory(String pluginDirectoryPath) {
        this.pluginDirectoryPath = pluginDirectoryPath != null && pluginDirectoryPath.startsWith("${") && pluginDirectoryPath.endsWith("}") ? DEFAULT_PLUGINS_LOCATION + this.getDefaultPluginSubDirName() : pluginDirectoryPath;
    }

    @Override
    public List<String> listPredeployedPlugins() {
        if (this.predeployedPlugins == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.predeployedPlugins.getPluginNames());
    }

    @Override
    public T tryGetPredeployedPluginByName(String name) {
        if (this.predeployedPlugins == null) {
            throw new UserFailureException("Predeployed " + this.getPluginDescription() + " plugins are not configured properly.");
        }
        return (T)((ICommonPropertyBasedHotDeployPlugin)this.predeployedPlugins.tryGet(name));
    }

    @Override
    public void initializeHotDeployment(IHotDeploymentController controller) {
        this.hotDeploymentController = controller;
        if (!StringUtils.isBlank((String)this.pluginDirectoryPath)) {
            this.predeployedPlugins = this.hotDeploymentController.getPluginMap(this.getPluginClass());
            this.predeployedPlugins.addListener(new PluginEventListener(){

                public void pluginChanged(PluginEvent event) {
                    AbstractCommonPropertyBasedHotDeployPluginFactory.this.hotDeploymentController.pluginChanged(event, (ICommonPropertyBasedHotDeployPlugin)AbstractCommonPropertyBasedHotDeployPluginFactory.this.predeployedPlugins.tryGet(event.getPluginName()), AbstractCommonPropertyBasedHotDeployPluginFactory.this.getScriptType());
                }
            });
            this.hotDeploymentController.addPluginDirectory(new File(this.pluginDirectoryPath));
        } else {
            this.predeployedPlugins = null;
        }
    }

    @Override
    public IHotDeploymentController getHotDeploymentController() {
        return this.hotDeploymentController;
    }

    protected abstract String getPluginDescription();

    protected abstract String getDefaultPluginSubDirName();

    protected abstract Class<T> getPluginClass();

    protected abstract ScriptType getScriptType();
}

