/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property;

import ch.systemsx.cisd.common.jython.evaluator.Evaluator;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.jython.evaluator.IJythonEvaluator;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedUiActionDescriptionFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IPerson;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityPropertyAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IAtomicEvaluation;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IEvaluationRunner;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.ManagedPropertyFunctions;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IManagedPropertyEvaluator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class JythonManagedPropertyEvaluator
implements IManagedPropertyEvaluator {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, JythonManagedPropertyEvaluator.class);
    private static final String CONFIGURE_UI_FUNCTION = "configureUI";
    private static final String UPDATE_FROM_UI_FUNCTION = "updateFromUI";
    private static final String BATCH_COLUMN_NAMES_FUNCTION = "batchColumnNames";
    private static final String INPUT_WIDGETS_FUNCTION = "inputWidgets";
    private static final String UPDATE_FROM_BATCH_INPUT_FUNCTION = "updateFromBatchInput";
    private static final String UPDATE_FROM_REGISTRATION_FORM_FUNCTION = "updateFromRegistrationForm";
    private static final String PROPERTY_VARIABLE_NAME = "property";
    private static final String PROPERTY_PE_VARIABLE_NAME = "propertyPE";
    private static final String PERSON_VARIABLE_NAME = "person";
    private final IEvaluationRunner runner;
    private final List<String> columnNames;
    private final boolean updateFromBatchFunctionDefined;
    private final boolean updateFromRegistrationFormFunctionDefined;
    private List<IManagedInputWidgetDescription> inputWidgetDescriptions;

    public JythonManagedPropertyEvaluator(final String scriptExpression) {
        this(new IEvaluationRunner(){
            private IJythonEvaluator evaluator;
            {
                this.evaluator = Evaluator.getFactory().create("", ManagedPropertyFunctions.class, scriptExpression);
            }

            @Override
            public <T> T evaluate(IAtomicEvaluation<T> evaluation) {
                return evaluation.evaluate(this.evaluator);
            }
        });
    }

    public JythonManagedPropertyEvaluator(IEvaluationRunner runner) {
        UniqunessChecker uniqunessChecker;
        this.runner = runner;
        this.updateFromBatchFunctionDefined = runner.evaluate(new IAtomicEvaluation<Boolean>(){

            @Override
            public Boolean evaluate(IJythonEvaluator evaluator) {
                return evaluator.hasFunction(JythonManagedPropertyEvaluator.UPDATE_FROM_BATCH_INPUT_FUNCTION);
            }
        });
        this.updateFromRegistrationFormFunctionDefined = runner.evaluate(new IAtomicEvaluation<Boolean>(){

            @Override
            public Boolean evaluate(IJythonEvaluator evaluator) {
                return evaluator.hasFunction(JythonManagedPropertyEvaluator.UPDATE_FROM_REGISTRATION_FORM_FUNCTION);
            }
        });
        boolean batchColumnNamesFunctionDefined = runner.evaluate(new IAtomicEvaluation<Boolean>(){

            @Override
            public Boolean evaluate(IJythonEvaluator evaluator) {
                return evaluator.hasFunction(JythonManagedPropertyEvaluator.BATCH_COLUMN_NAMES_FUNCTION);
            }
        });
        boolean inputWidgetsFunctionDefined = runner.evaluate(new IAtomicEvaluation<Boolean>(){

            @Override
            public Boolean evaluate(IJythonEvaluator evaluator) {
                return evaluator.hasFunction(JythonManagedPropertyEvaluator.INPUT_WIDGETS_FUNCTION);
            }
        });
        this.checkCombinationsOfDefinedFunctions(batchColumnNamesFunctionDefined, inputWidgetsFunctionDefined);
        this.columnNames = new ArrayList<String>();
        this.inputWidgetDescriptions = new ArrayList<IManagedInputWidgetDescription>();
        if (inputWidgetsFunctionDefined) {
            List<?> widgets = this.evalFunction(INPUT_WIDGETS_FUNCTION);
            uniqunessChecker = new UniqunessChecker("an input widget", "code");
            for (int i = 0; i < widgets.size(); ++i) {
                Object widget = widgets.get(i);
                if (widget == null) {
                    throw new EvaluatorException("Function inputWidgets has returned a list where the " + (i + 1) + ". element is null.");
                }
                if (!(widget instanceof IManagedInputWidgetDescription)) {
                    throw new EvaluatorException("Function inputWidgets has returned a list where the " + (i + 1) + ". element isn't of type " + IManagedInputWidgetDescription.class.getName() + " but " + widget.getClass().getName() + ".");
                }
                IManagedInputWidgetDescription widgetDescription = (IManagedInputWidgetDescription)widget;
                this.inputWidgetDescriptions.add(widgetDescription);
                if (batchColumnNamesFunctionDefined) continue;
                String code = widgetDescription.getCode();
                uniqunessChecker.check(code);
                this.columnNames.add(code);
            }
        }
        if (batchColumnNamesFunctionDefined) {
            List<?> list = this.evalFunction(BATCH_COLUMN_NAMES_FUNCTION);
            uniqunessChecker = new UniqunessChecker("a batch column", "name in uppercase");
            ManagedUiActionDescriptionFactory descriptionFactory = new ManagedUiActionDescriptionFactory();
            for (Object element : list) {
                String columnName = element.toString();
                String code = columnName.toUpperCase();
                uniqunessChecker.check(code);
                this.columnNames.add(code);
                if (inputWidgetsFunctionDefined) continue;
                this.inputWidgetDescriptions.add(descriptionFactory.createTextInputField(columnName));
            }
        }
    }

    private void checkCombinationsOfDefinedFunctions(boolean batchColumnNamesFunctionDefined, boolean inputWidgetsFunctionDefined) {
        if (batchColumnNamesFunctionDefined && !this.updateFromBatchFunctionDefined) {
            StringBuilder builder = new StringBuilder("Function ");
            builder.append(UPDATE_FROM_BATCH_INPUT_FUNCTION);
            builder.append(" is not defined although function ");
            builder.append(BATCH_COLUMN_NAMES_FUNCTION);
            builder.append(" is defined.");
            throw new EvaluatorException(builder.toString());
        }
        if (inputWidgetsFunctionDefined && !this.updateFromRegistrationFormFunctionDefined) {
            StringBuilder builder = new StringBuilder("Function ");
            builder.append(UPDATE_FROM_REGISTRATION_FORM_FUNCTION);
            builder.append(" is not defined although function ");
            builder.append(INPUT_WIDGETS_FUNCTION);
            builder.append(" is defined.");
            throw new EvaluatorException(builder.toString());
        }
    }

    private List<?> evalFunction(final String functionName) {
        Object result = this.runner.evaluate(new IAtomicEvaluation<Object>(){

            @Override
            public Object evaluate(IJythonEvaluator evaluator) {
                return evaluator.evalFunction(functionName, new Object[0]);
            }
        });
        if (!(result instanceof List)) {
            throw new EvaluatorException("Function '" + functionName + "' doesn't return a List but an object of type '" + result.getClass().getName() + "': " + result);
        }
        return (List)result;
    }

    @Override
    public void configureUI(final IManagedProperty managedProperty, final IEntityPropertyAdaptor entityProperty) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Evaluating managed property ui configuration'%s'.", managedProperty));
        }
        this.runner.evaluate(new IAtomicEvaluation<Void>(){

            @Override
            public Void evaluate(IJythonEvaluator evaluator) {
                evaluator.set(JythonManagedPropertyEvaluator.PROPERTY_VARIABLE_NAME, (Object)managedProperty);
                evaluator.set(JythonManagedPropertyEvaluator.PROPERTY_PE_VARIABLE_NAME, (Object)entityProperty);
                evaluator.evalFunction(JythonManagedPropertyEvaluator.CONFIGURE_UI_FUNCTION, new Object[0]);
                return null;
            }
        });
    }

    @Override
    public void updateFromUI(final IManagedProperty managedProperty, final IPerson person, final IManagedUiAction action) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Evaluating managed property value update '%s'.", managedProperty));
        }
        this.runner.evaluate(new IAtomicEvaluation<Void>(){

            @Override
            public Void evaluate(IJythonEvaluator evaluator) {
                evaluator.set(JythonManagedPropertyEvaluator.PROPERTY_VARIABLE_NAME, (Object)managedProperty);
                evaluator.set(JythonManagedPropertyEvaluator.PERSON_VARIABLE_NAME, (Object)person);
                evaluator.evalFunction(JythonManagedPropertyEvaluator.UPDATE_FROM_UI_FUNCTION, new Object[]{action});
                return null;
            }
        });
    }

    @Override
    public List<String> getBatchColumnNames() {
        return this.columnNames;
    }

    @Override
    public List<IManagedInputWidgetDescription> getInputWidgetDescriptions() {
        return this.inputWidgetDescriptions;
    }

    @Override
    public void updateFromBatchInput(final IManagedProperty managedProperty, final IPerson person, final Map<String, String> bindings) {
        if (!this.updateFromBatchFunctionDefined) {
            if (bindings.containsKey("")) {
                managedProperty.setValue(bindings.get(""));
            }
        } else {
            this.runner.evaluate(new IAtomicEvaluation<Void>(){

                @Override
                public Void evaluate(IJythonEvaluator evaluator) {
                    evaluator.set(JythonManagedPropertyEvaluator.PROPERTY_VARIABLE_NAME, (Object)managedProperty);
                    evaluator.set(JythonManagedPropertyEvaluator.PERSON_VARIABLE_NAME, (Object)person);
                    evaluator.evalFunction(JythonManagedPropertyEvaluator.UPDATE_FROM_BATCH_INPUT_FUNCTION, new Object[]{bindings});
                    return null;
                }
            });
        }
    }

    @Override
    public void updateFromRegistrationForm(final IManagedProperty managedProperty, final IPerson person, final List<Map<String, String>> bindings) {
        if (this.updateFromRegistrationFormFunctionDefined) {
            this.runner.evaluate(new IAtomicEvaluation<Void>(){

                @Override
                public Void evaluate(IJythonEvaluator evaluator) {
                    evaluator.set(JythonManagedPropertyEvaluator.PROPERTY_VARIABLE_NAME, (Object)managedProperty);
                    evaluator.set(JythonManagedPropertyEvaluator.PERSON_VARIABLE_NAME, (Object)person);
                    evaluator.evalFunction(JythonManagedPropertyEvaluator.UPDATE_FROM_REGISTRATION_FORM_FUNCTION, new Object[]{bindings});
                    return null;
                }
            });
        }
    }

    private static final class UniqunessChecker {
        private final Set<String> codes = new HashSet<String>();
        private final String type;
        private final String codeName;

        UniqunessChecker(String type, String codeName) {
            this.type = type;
            this.codeName = codeName;
        }

        void check(String code) {
            if (!this.codes.add(code)) {
                throw new EvaluatorException("There is already " + this.type + " with " + this.codeName + ": " + code);
            }
        }
    }
}

