/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property.api;

public enum EntityLinkElementKind {
    EXPERIMENT("Experiment"),
    SAMPLE("Sample"),
    DATA_SET("Dataset", "Data Set"),
    MATERIAL("Material");

    private final String elementName;
    private final String label;

    private EntityLinkElementKind(String elementName) {
        this(elementName, elementName);
    }

    private EntityLinkElementKind(String elementName, String label) {
        this.elementName = elementName;
        this.label = label;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getLabel() {
        return this.label;
    }

    public static EntityLinkElementKind tryGetForElementName(String elementName) {
        for (EntityLinkElementKind kind : EntityLinkElementKind.values()) {
            if (!kind.getElementName().equalsIgnoreCase(elementName)) continue;
            return kind;
        }
        return null;
    }
}

