/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property.structured;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.EntityLinkElementKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IElement;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IElementFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IStructuredPropertyConverter;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.Element;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.EntityLinkElement;
import ch.systemsx.cisd.openbis.generic.shared.util.XmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlStructuredPropertyConverter
implements IStructuredPropertyConverter {
    private static final String ROOT_NAME = "root";
    private final IElementFactory factory;

    public XmlStructuredPropertyConverter(IElementFactory factory) {
        this.factory = factory;
    }

    public boolean canHandle(IManagedProperty property) {
        return this.canHandle(property.getValue());
    }

    public boolean canHandle(String string) {
        return string.startsWith("<root") || ManagedProperty.isSpecialValue(string) || StringUtils.isBlank((String)string);
    }

    @Override
    public List<IElement> convertToElements(IManagedProperty property) {
        return this.convertStringToElements(property.getValue());
    }

    @Override
    public List<IElement> convertStringToElements(String propertyValue) {
        if (ManagedProperty.isSpecialValue(propertyValue) || StringUtils.isBlank((String)propertyValue)) {
            return Collections.emptyList();
        }
        Document document = XmlUtils.parseXmlDocument(propertyValue);
        IElement root = this.transformFromDOM(document.getDocumentElement());
        return root.getChildren();
    }

    @Override
    public String convertToString(List<IElement> elements) {
        IElement root = this.createRootElement(elements);
        Document doc = this.createEmptyDocument();
        Node rootNode = this.transformToDOM(root, doc);
        doc.appendChild(rootNode);
        return XmlUtils.serializeDocument(doc);
    }

    private IElement createRootElement(List<IElement> elements) {
        Element root = new Element(ROOT_NAME);
        root.setChildren(elements);
        return root;
    }

    private Node transformToDOM(IElement element, Document document) {
        org.w3c.dom.Element result = document.createElement(element.getName());
        for (IElement child : element.getChildren()) {
            Node childNode = this.transformToDOM(child, document);
            result.appendChild(childNode);
        }
        this.transformAttributesToDOM(element, document, result);
        this.transformDataToDOM(element, document, result);
        return result;
    }

    private IElement transformFromDOM(Node node) {
        IElement result = this.createElementForNode(node);
        this.transformAttributesFromDOM(node, result);
        NodeList domChildren = node.getChildNodes();
        ArrayList<IElement> children = new ArrayList<IElement>();
        if (domChildren != null) {
            for (int i = 0; i < domChildren.getLength(); ++i) {
                Node domChild = domChildren.item(i);
                if (domChild.getNodeType() == 1) {
                    IElement child = this.transformFromDOM(domChild);
                    children.add(child);
                    continue;
                }
                if (domChild.getNodeType() != 3) continue;
                String textContent = domChild.getNodeValue().trim();
                if (StringUtils.isBlank((String)(textContent = StringEscapeUtils.unescapeXml((String)textContent)))) continue;
                result.setData(textContent);
            }
        }
        result.setChildren(children);
        return result;
    }

    private void transformAttributesFromDOM(Node node, IElement result) {
        NamedNodeMap domAttributes = node.getAttributes();
        if (domAttributes != null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (int i = 0; i < domAttributes.getLength(); ++i) {
                Attr domAttr = (Attr)domAttributes.item(i);
                String unescapedValue = StringEscapeUtils.unescapeXml((String)domAttr.getValue());
                attributes.put(domAttr.getName(), unescapedValue);
            }
            result.setAttributes(attributes);
        }
    }

    private IElement createElementForNode(Node node) {
        String nodeName = node.getLocalName();
        EntityLinkElementKind linkKind = EntityLinkElementKind.tryGetForElementName(nodeName);
        if (linkKind != null) {
            String permId = this.getAttrValueOrFail(node, "permId");
            return new EntityLinkElement(linkKind, permId);
        }
        return this.factory.createElement(nodeName);
    }

    private String getAttrValueOrFail(Node node, String attrName) {
        Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
        if (attr == null) {
            String error = String.format("Attribute [%s] expected in nodes with name %s", attrName, node.getNodeName());
            throw new IllegalArgumentException(error);
        }
        return attr.getValue();
    }

    private void transformAttributesToDOM(IElement element, Document document, Node node) {
        Map<String, String> attributes = element.getAttributes();
        for (String key : element.getAttributes().keySet()) {
            Attr domAttr = document.createAttribute(key);
            String escapedValue = StringEscapeUtils.escapeXml((String)attributes.get(key));
            domAttr.setValue(escapedValue);
            node.getAttributes().setNamedItem(domAttr);
        }
    }

    private void transformDataToDOM(IElement element, Document document, Node node) {
        String data = element.getData();
        if (!StringUtils.isBlank((String)data)) {
            String escapedXmlContent = StringEscapeUtils.escapeXml((String)data);
            Text textNode = document.createTextNode(escapedXmlContent);
            node.appendChild(textNode);
        }
    }

    private Document createEmptyDocument() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            Document doc = parser.newDocument();
            return doc;
        }
        catch (ParserConfigurationException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }
}

