/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.parser;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.NamedReader;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.ParsingException;
import ch.systemsx.cisd.common.parser.TabFileLoader;
import java.io.Reader;
import java.util.List;
import java.util.Map;

public final class BisTabFileLoader<T>
extends TabFileLoader<T> {
    private static final String MESSAGE_FORMAT = "A problem has occurred while parsing line %d of file '%s':\n  %s";
    private static final String ERROR_IN_FILE_MESSAGE_FORMAT = "A problem has occurred while parsing file '%s':\n  %s";
    private final boolean acceptEmptyFiles;

    public BisTabFileLoader(IParserObjectFactoryFactory<T> factory, boolean acceptEmptyFiles) {
        super(factory);
        this.acceptEmptyFiles = acceptEmptyFiles;
    }

    private static final void translateParsingException(ParsingException parsingException, NamedReader namedReader) {
        RuntimeException causeException = parsingException.getCauseRuntimeException();
        String message = causeException == null ? parsingException.getMessage() : causeException.getMessage();
        throw UserFailureException.fromTemplate((String)MESSAGE_FORMAT, (Object[])new Object[]{parsingException.getLineNumber(), namedReader.getReaderName(), message});
    }

    private static final void translateParserException(ParserException ex, NamedReader namedReader) {
        String message = ex.getMessage();
        throw UserFailureException.fromTemplate((String)ERROR_IN_FILE_MESSAGE_FORMAT, (Object[])new Object[]{namedReader.getReaderName(), message});
    }

    public List<T> load(Reader reader, Map<String, String> defaults) throws ParserException, ParsingException, IllegalArgumentException {
        assert (reader instanceof NamedReader) : "Must be a NamedReader.";
        NamedReader namedReader = (NamedReader)reader;
        try {
            List list = super.load((Reader)namedReader, defaults);
            if (!this.acceptEmptyFiles && list.size() == 0) {
                throw new UserFailureException("Given file '" + namedReader.getReaderName() + "' is empty or does not contain any meaningful information.");
            }
            return list;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UserFailureException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        catch (ParsingException e) {
            BisTabFileLoader.translateParsingException(e, namedReader);
            return null;
        }
        catch (ParserException e) {
            BisTabFileLoader.translateParserException(e, namedReader);
            return null;
        }
    }
}

