/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.parser;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.DelegatedReader;
import ch.systemsx.cisd.common.parser.ExcelFileLoader;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.TabFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.parser.BisExcelFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.parser.BisTabFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.parser.ExcelFileSection;
import ch.systemsx.cisd.openbis.generic.shared.parser.FileSection;
import ch.systemsx.cisd.openbis.generic.shared.parser.NamedInputStream;
import ch.systemsx.cisd.openbis.generic.shared.parser.NewSampleParserObjectFactory;
import ch.systemsx.cisd.openbis.generic.shared.parser.UpdatedSampleParserObjectFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;

public class SampleUploadSectionsParser {
    public static BatchSamplesOperation prepareSamples(SampleType sampleType, String spaceIdentifierSilentOverrideOrNull, String experimentIdentifierSilentOverrideOrNull, Collection<NamedInputStream> files, String defaultGroupIdentifier, SampleCodeGenerator sampleCodeGeneratorOrNull, boolean allowExperiments, String excelSheetName, BatchOperationKind operationKind) {
        return SampleUploadSectionsParser.prepareSamples(false, sampleType, spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, files, defaultGroupIdentifier, sampleCodeGeneratorOrNull, allowExperiments, excelSheetName, operationKind);
    }

    public static BatchSamplesOperation prepareSamples(boolean projectSamplesEnabled, SampleType sampleType, String spaceIdentifierSilentOverrideOrNull, String experimentIdentifierSilentOverrideOrNull, Collection<NamedInputStream> files, String defaultGroupIdentifier, SampleCodeGenerator sampleCodeGeneratorOrNull, boolean allowExperiments, String excelSheetName, BatchOperationKind operationKind) {
        ArrayList<NewSamplesWithTypes> newSamples = new ArrayList<NewSamplesWithTypes>();
        boolean isAutoGenerateCodes = sampleCodeGeneratorOrNull != null;
        List<BatchRegistrationResult> results = SampleUploadSectionsParser.loadSamplesFromFiles(files, sampleType, spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, isAutoGenerateCodes, newSamples, allowExperiments, excelSheetName, operationKind);
        if (defaultGroupIdentifier != null) {
            switch (operationKind) {
                case REGISTRATION: {
                    if (!isAutoGenerateCodes) break;
                    SampleUploadSectionsParser.generateIdentifiers(projectSamplesEnabled, defaultGroupIdentifier, sampleCodeGeneratorOrNull, isAutoGenerateCodes, newSamples);
                    break;
                }
                case UPDATE: {
                    SampleUploadSectionsParser.fillIdentifiers(defaultGroupIdentifier, newSamples);
                }
            }
        }
        return new BatchSamplesOperation(newSamples, results, SampleUploadSectionsParser.parseCodes(newSamples));
    }

    private static String[] parseCodes(List<NewSamplesWithTypes> newSamples) {
        ArrayList<String> codes = new ArrayList<String>();
        for (NewSamplesWithTypes st : newSamples) {
            for (NewSample s : st.getNewEntities()) {
                codes.add(SampleIdentifierFactory.parse(s.getIdentifier()).getSampleCode());
            }
        }
        return codes.toArray(new String[0]);
    }

    private static BisTabFileLoader<NewSample> createSampleLoader(final SampleType sampleType, final boolean isAutoGenerateCodes, final boolean allowExperiments, final BatchOperationKind operationKind) {
        BisTabFileLoader<NewSample> tabFileLoader = new BisTabFileLoader<NewSample>(new IParserObjectFactoryFactory<NewSample>(){

            public final IParserObjectFactory<NewSample> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                switch (operationKind) {
                    case REGISTRATION: {
                        return new NewSampleParserObjectFactory(sampleType, propertyMapper, !isAutoGenerateCodes, allowExperiments);
                    }
                    case UPDATE: {
                        return new UpdatedSampleParserObjectFactory(sampleType, propertyMapper, !isAutoGenerateCodes, allowExperiments);
                    }
                }
                throw new UnsupportedOperationException(operationKind + " is not supported");
            }
        }, true);
        return tabFileLoader;
    }

    private static BisExcelFileLoader<NewSample> createSampleLoaderFromExcel(final SampleType sampleType, final boolean isAutoGenerateCodes, final boolean allowExperiments, final BatchOperationKind operationKind) {
        BisExcelFileLoader<NewSample> tabFileLoader = new BisExcelFileLoader<NewSample>(new IParserObjectFactoryFactory<NewSample>(){

            public final IParserObjectFactory<NewSample> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                switch (operationKind) {
                    case REGISTRATION: {
                        return new NewSampleParserObjectFactory(sampleType, propertyMapper, !isAutoGenerateCodes, allowExperiments);
                    }
                    case UPDATE: {
                        return new UpdatedSampleParserObjectFactory(sampleType, propertyMapper, !isAutoGenerateCodes, allowExperiments);
                    }
                }
                throw new UnsupportedOperationException(operationKind + " is not supported");
            }
        }, true);
        return tabFileLoader;
    }

    public static String getIdentifierOrNull(String identifierOrNullOrDelete) {
        switch (identifierOrNullOrDelete) {
            case "--DELETE--": {
                return null;
            }
            case "__DELETE__": {
                return null;
            }
        }
        return identifierOrNullOrDelete;
    }

    private static void setSilentOverrides(String spaceIdentifierSilentOverrideOrNull, String experimentIdentifierSilentOverrideOrNull, List<NewSample> newSamples) {
        for (NewSample newSample : newSamples) {
            if (spaceIdentifierSilentOverrideOrNull != null) {
                if (newSample.getIdentifier() != null) {
                    int endOfSpaceIdentfier = StringUtils.ordinalIndexOf((CharSequence)newSample.getIdentifier(), (CharSequence)"/", (int)2);
                    String sampleIdentifierSilentOverrideOrNull = spaceIdentifierSilentOverrideOrNull + newSample.getIdentifier().substring(endOfSpaceIdentfier);
                    newSample.setIdentifier(sampleIdentifierSilentOverrideOrNull);
                }
                newSample.setDefaultSpaceIdentifier(SampleUploadSectionsParser.getIdentifierOrNull(spaceIdentifierSilentOverrideOrNull));
            }
            if (experimentIdentifierSilentOverrideOrNull == null) continue;
            newSample.setExperimentIdentifier(SampleUploadSectionsParser.getIdentifierOrNull(experimentIdentifierSilentOverrideOrNull));
        }
    }

    private static List<BatchRegistrationResult> loadSamplesFromFiles(Collection<NamedInputStream> uploadedFiles, SampleType sampleType, String spaceIdentifierSilentOverrideOrNull, String experimentIdentifierSilentOverrideOrNull, boolean isAutoGenerateCodes, List<NewSamplesWithTypes> newSamples, boolean allowExperiments, String excelSheetName, BatchOperationKind operationKind) {
        ArrayList<BatchRegistrationResult> results = new ArrayList<BatchRegistrationResult>(uploadedFiles.size());
        for (NamedInputStream multipartFile : uploadedFiles) {
            HashMap<String, String> defaults;
            int sampleCounter;
            ArrayList<Object> sampleSections;
            String fileName = multipartFile.getOriginalFilename();
            String loweredFileName = fileName.toLowerCase();
            if (loweredFileName.endsWith("xls") || loweredFileName.endsWith("xlsx")) {
                sampleSections = new ArrayList<Object>();
                if (sampleType.isDefinedInFileEntityTypeCode()) {
                    sampleSections.addAll(ExcelFileSection.extractSections(multipartFile.getInputStream(), excelSheetName, loweredFileName));
                } else {
                    sampleSections.add(ExcelFileSection.createFromInputStream(multipartFile.getInputStream(), sampleType.getCode(), loweredFileName));
                }
                sampleCounter = 0;
                defaults = new HashMap<String, String>();
                for (Object fs : sampleSections) {
                    if (((ExcelFileSection)fs).getSectionName().equals("DEFAULT")) {
                        defaults.putAll(ExcelFileLoader.parseDefaults((Sheet)((ExcelFileSection)fs).getSheet(), (int)((ExcelFileSection)fs).getBegin(), (int)((ExcelFileSection)fs).getEnd()));
                        continue;
                    }
                    SampleType typeFromSection = new SampleType();
                    typeFromSection.setCode(((ExcelFileSection)fs).getSectionName());
                    BisExcelFileLoader<NewSample> excelFileLoader = SampleUploadSectionsParser.createSampleLoaderFromExcel(typeFromSection, isAutoGenerateCodes, allowExperiments, operationKind);
                    String sectionInFile = sampleSections.size() == 1 ? "" : " (section:" + ((ExcelFileSection)fs).getSectionName() + ")";
                    List<NewSample> loadedSamples = excelFileLoader.load(((ExcelFileSection)fs).getSheet(), ((ExcelFileSection)fs).getBegin(), ((ExcelFileSection)fs).getEnd(), fileName + sectionInFile, defaults);
                    SampleUploadSectionsParser.setSilentOverrides(spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, loadedSamples);
                    if (loadedSamples.size() <= 0) continue;
                    newSamples.add(new NewSamplesWithTypes(typeFromSection, loadedSamples));
                    sampleCounter += loadedSamples.size();
                }
                results.add(new BatchRegistrationResult(fileName, String.format("%s of %d sample(s) is complete.", operationKind.getDescription(), sampleCounter)));
                continue;
            }
            sampleSections = new ArrayList();
            if (sampleType.isDefinedInFileEntityTypeCode()) {
                sampleSections.addAll(FileSection.extractSections(multipartFile.getUnicodeReader()));
            } else {
                sampleSections.add(FileSection.createFromInputStream(multipartFile.getInputStream(), sampleType.getCode()));
            }
            sampleCounter = 0;
            defaults = new HashMap();
            for (Object fs : sampleSections) {
                if (((FileSection)fs).getSectionName().equals("DEFAULT")) {
                    defaults.putAll(TabFileLoader.parseDefaults((Reader)((FileSection)fs).getContentReader()));
                    continue;
                }
                Reader reader = ((FileSection)fs).getContentReader();
                SampleType typeFromSection = new SampleType();
                typeFromSection.setCode(((FileSection)fs).getSectionName());
                BisTabFileLoader<NewSample> tabFileLoader = SampleUploadSectionsParser.createSampleLoader(typeFromSection, isAutoGenerateCodes, allowExperiments, operationKind);
                String sectionInFile = sampleSections.size() == 1 ? "" : " (section:" + ((FileSection)fs).getSectionName() + ")";
                List<NewSample> loadedSamples = tabFileLoader.load((Reader)new DelegatedReader(reader, fileName + sectionInFile), defaults);
                SampleUploadSectionsParser.setSilentOverrides(spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, loadedSamples);
                if (loadedSamples.size() <= 0) continue;
                newSamples.add(new NewSamplesWithTypes(typeFromSection, loadedSamples));
                sampleCounter += loadedSamples.size();
            }
            results.add(new BatchRegistrationResult(fileName, String.format("%s of %d sample(s) is complete.", operationKind.getDescription(), sampleCounter)));
        }
        return results;
    }

    static void generateIdentifiers(boolean projectSamplesEnabled, String defaultGroupIdentifier, SampleCodeGenerator sampleCodeGenerator, boolean isAutoGenerateCodes, List<NewSamplesWithTypes> newSamplesWithTypes) {
        assert (sampleCodeGenerator != null);
        assert (isAutoGenerateCodes);
        for (NewSamplesWithTypes st : newSamplesWithTypes) {
            List newSamples = st.getNewEntities();
            List<String> codes = sampleCodeGenerator.generateCodes(newSamples.size());
            for (int i = 0; i < newSamples.size(); ++i) {
                NewSample sample = (NewSample)newSamples.get(i);
                String spaceCodeOrNull = null;
                spaceCodeOrNull = StringUtils.isBlank((CharSequence)sample.getDefaultSpaceIdentifier()) ? defaultGroupIdentifier : sample.getDefaultSpaceIdentifier();
                spaceCodeOrNull = spaceCodeOrNull.substring(1);
                String projectCodeOrNull = null;
                if (projectSamplesEnabled && StringUtils.isNotBlank((CharSequence)sample.getExperimentIdentifier())) {
                    String[] experimentIdentifierParts = sample.getExperimentIdentifier().split("/");
                    if (experimentIdentifierParts.length != 4) {
                        throw new UserFailureException("Incorrect format for the experiment identifier: " + sample.getExperimentIdentifier());
                    }
                    spaceCodeOrNull = experimentIdentifierParts[experimentIdentifierParts.length - 3];
                    projectCodeOrNull = experimentIdentifierParts[experimentIdentifierParts.length - 2];
                }
                sample.setIdentifier(SampleUploadSectionsParser.createIdentifier(spaceCodeOrNull, projectCodeOrNull, codes.get(i)));
            }
        }
    }

    private static String createIdentifier(String spaceCodeOrNull, String projectCodeOrNull, String sampleCode) {
        StringBuilder builder = new StringBuilder("/");
        if (spaceCodeOrNull != null) {
            builder.append(spaceCodeOrNull).append("/");
        }
        if (projectCodeOrNull != null) {
            builder.append(projectCodeOrNull).append("/");
        }
        return builder.append(sampleCode).toString();
    }

    private static void fillIdentifiers(String defaultGroupIdentifier, List<NewSamplesWithTypes> newSamplesWithTypes) {
        for (NewSamplesWithTypes st : newSamplesWithTypes) {
            List newSamples = st.getNewEntities();
            for (int i = 0; i < newSamples.size(); ++i) {
                String identifierFromFile = ((NewSample)newSamples.get(i)).getIdentifier();
                if (identifierFromFile.contains("/")) continue;
                ((NewSample)newSamples.get(i)).setIdentifier(defaultGroupIdentifier + "/" + identifierFromFile);
            }
        }
    }

    public static interface SampleCodeGenerator {
        public List<String> generateCodes(int var1);
    }

    public static class BatchSamplesOperation {
        private final List<NewSamplesWithTypes> samples;
        private final List<BatchRegistrationResult> resultList;
        private final String[] sampleCodes;

        public BatchSamplesOperation(List<NewSamplesWithTypes> samples, List<BatchRegistrationResult> resultList, String[] sampleCodes) {
            this.samples = samples;
            this.resultList = resultList;
            this.sampleCodes = sampleCodes;
        }

        public List<NewSamplesWithTypes> getSamples() {
            return this.samples;
        }

        public List<BatchRegistrationResult> getResultList() {
            return this.resultList;
        }

        public String[] getCodes() {
            return this.sampleCodes;
        }
    }
}

