/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.common.collection.IValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.AttachmentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DeletionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ProjectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ScriptTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ExperimentTranslator {
    private ExperimentTranslator() {
    }

    private static void setProperties(ExperimentPE experiment, Experiment result, boolean rawManagedProperties, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator) {
        if (experiment.isPropertiesInitialized()) {
            HashMap<MaterialTypePE, MaterialType> materialTypeCache = new HashMap<MaterialTypePE, MaterialType>();
            HashMap<PropertyTypePE, PropertyType> cache = new HashMap<PropertyTypePE, PropertyType>();
            if (rawManagedProperties) {
                result.setProperties(EntityPropertyTranslator.translateRaw(experiment.getProperties(), materialTypeCache, cache, managedPropertyEvaluatorFactory, samplePropertyAccessValidator));
            } else {
                result.setProperties(EntityPropertyTranslator.translate(experiment.getProperties(), materialTypeCache, cache, managedPropertyEvaluatorFactory, samplePropertyAccessValidator));
            }
        } else {
            result.setProperties(new ArrayList<IEntityProperty>());
        }
    }

    public static final Experiment translateWithoutRevealingData(ExperimentPE experiment, Collection<Metaproject> metaprojects) {
        Experiment result = new Experiment(true);
        result.setId(HibernateUtils.getId(experiment));
        result.setPermId(experiment.getPermId());
        result.setProperties(new ArrayList<IEntityProperty>());
        result.setMetaprojects(metaprojects);
        return result;
    }

    public static final Experiment translateWithoutRevealingData(Experiment experiment) {
        Experiment result = new Experiment(true);
        result.setId(HibernateUtils.getId(experiment));
        result.setPermId(experiment.getPermId());
        result.setProperties(new ArrayList<IEntityProperty>());
        result.setMetaprojects(experiment.getMetaprojects());
        return result;
    }

    public static final Experiment translate(ExperimentPE experiment, String baseIndexURL, Collection<Metaproject> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator, LoadableFields ... withFields) {
        return ExperimentTranslator.translate(experiment, baseIndexURL, false, metaprojects, managedPropertyEvaluatorFactory, samplePropertyAccessValidator, withFields);
    }

    public static final Experiment translate(ExperimentPE experiment, String baseIndexURL, boolean rawManagedProperties, Collection<Metaproject> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator, LoadableFields ... withFields) {
        if (experiment == null) {
            return null;
        }
        Experiment result = new Experiment();
        result.setId(HibernateUtils.getId(experiment));
        result.setModificationDate(experiment.getModificationDate());
        result.setCode(experiment.getCode());
        result.setPermId(experiment.getPermId());
        result.setPermlink(PermlinkUtilities.createPermlinkURL(baseIndexURL, EntityKind.EXPERIMENT, experiment.getPermId()));
        result.setExperimentType(ExperimentTranslator.translate(experiment.getExperimentType(), new HashMap<MaterialTypePE, MaterialType>(), new HashMap<PropertyTypePE, PropertyType>()));
        result.setIdentifier(experiment.getIdentifier());
        result.setProject(ProjectTranslator.translate(experiment.getProject()));
        result.setRegistrationDate(experiment.getRegistrationDate());
        result.setRegistrator(PersonTranslator.translate(experiment.getRegistrator()));
        result.setModifier(PersonTranslator.translate(experiment.getModifier()));
        result.setDeletion(DeletionTranslator.translate(experiment.getDeletion()));
        result.setVersion(experiment.getVersion());
        block4: for (LoadableFields field : withFields) {
            switch (field) {
                case PROPERTIES: {
                    ExperimentTranslator.setProperties(experiment, result, rawManagedProperties, managedPropertyEvaluatorFactory, samplePropertyAccessValidator);
                    continue block4;
                }
                case ATTACHMENTS: {
                    result.setAttachments(AttachmentTranslator.translate(experiment.getAttachments(), baseIndexURL));
                    continue block4;
                }
            }
        }
        if (metaprojects != null) {
            result.setMetaprojects(metaprojects);
        }
        return result;
    }

    public static final List<Experiment> translate(List<ExperimentPE> experiments, String baseIndexURL, Map<Long, Set<Metaproject>> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator) {
        ArrayList<Experiment> result = new ArrayList<Experiment>(experiments.size());
        for (ExperimentPE experiment : experiments) {
            HibernateUtils.initialize(experiment.getProperties());
            result.add(ExperimentTranslator.translate(experiment, baseIndexURL, true, (Collection<Metaproject>)metaprojects.get(experiment.getId()), managedPropertyEvaluatorFactory, samplePropertyAccessValidator, LoadableFields.PROPERTIES));
        }
        return result;
    }

    public static final ExperimentType translate(ExperimentTypePE experimentType, Map<MaterialTypePE, MaterialType> materialTypeCache, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        ExperimentType result = new ExperimentType();
        result.setCode(experimentType.getCode());
        result.setDescription(experimentType.getDescription());
        result.setModificationDate(experimentType.getModificationDate());
        result.setValidationScript(ScriptTranslator.translate(experimentType.getValidationScript()));
        result.setExperimentTypePropertyTypes(ExperimentTypePropertyTypeTranslator.translate(experimentType.getExperimentTypePropertyTypes(), result, materialTypeCache, cacheOrNull));
        return result;
    }

    public static final ExperimentTypePE translate(ExperimentType experimentType) {
        ExperimentTypePE result = new ExperimentTypePE();
        result.setCode(experimentType.getCode());
        result.setDescription(experimentType.getDescription());
        return result;
    }

    public static final List<ExperimentType> translate(List<ExperimentTypePE> experimentTypes) {
        ArrayList<ExperimentType> result = new ArrayList<ExperimentType>(experimentTypes.size());
        for (ExperimentTypePE experimentType : experimentTypes) {
            result.add(ExperimentTranslator.translate(experimentType, new HashMap<MaterialTypePE, MaterialType>(), new HashMap<PropertyTypePE, PropertyType>()));
        }
        return result;
    }

    public static enum LoadableFields {
        ATTACHMENTS,
        PROPERTIES;

    }
}

