/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.ExpressionUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExpression;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomFilter;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractExpressionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomColumnPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomFilterPE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;

public final class GridCustomExpressionTranslator {
    private GridCustomExpressionTranslator() {
    }

    public static void translateExpression(AbstractExpressionPE<?> expression, AbstractExpression result) {
        result.setId(HibernateUtils.getId(expression));
        result.setModificationDate(expression.getModificationDate());
        result.setExpression(expression.getExpression());
        result.setDescription(expression.getDescription());
        result.setRegistrator(PersonTranslator.translate(expression.getRegistrator()));
        result.setRegistrationDate(expression.getRegistrationDate());
        result.setModificationDate(expression.getModificationDate());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate());
        result.setPublic(expression.isPublic());
    }

    public static final class GridCustomFilterTranslator {
        public static final List<GridCustomFilter> translate(List<GridCustomFilterPE> filters) {
            ArrayList<GridCustomFilter> result = new ArrayList<GridCustomFilter>();
            for (GridCustomFilterPE filter : filters) {
                result.add(GridCustomFilterTranslator.translate(filter));
            }
            return result;
        }

        public static final GridCustomFilter translate(GridCustomFilterPE original) {
            if (original == null) {
                return null;
            }
            GridCustomFilter result = new GridCustomFilter();
            result.setName(original.getName());
            result.setupParameters(ExpressionUtil.extractParameters(original.getExpression()));
            GridCustomExpressionTranslator.translateExpression(original, result);
            return result;
        }
    }

    public static class GridCustomColumnTranslator {
        public static final List<GridCustomColumn> translate(List<GridCustomColumnPE> columns) {
            ArrayList<GridCustomColumn> result = new ArrayList<GridCustomColumn>();
            for (GridCustomColumnPE column : columns) {
                result.add(GridCustomColumnTranslator.translate(column));
            }
            return result;
        }

        private static final GridCustomColumn translate(GridCustomColumnPE original) {
            if (original == null) {
                return null;
            }
            GridCustomColumn result = new GridCustomColumn();
            result.setCode(original.getCode());
            result.setName(original.getLabel());
            GridCustomExpressionTranslator.translateExpression(original, result);
            return result;
        }
    }
}

