/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.IEntityValidatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.ICommonPropertyBasedHotDeployPlugin;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class ScriptTranslator {
    private ScriptTranslator() {
    }

    public static final List<Script> translate(List<ScriptPE> scripts) {
        ArrayList<Script> result = new ArrayList<Script>();
        for (ScriptPE script : scripts) {
            result.add(ScriptTranslator.translate(script));
        }
        return result;
    }

    public static Script translate(ScriptPE script) {
        EntityKind[] entityKindArray;
        if (script == null) {
            return null;
        }
        Script result = new Script();
        result.setId(HibernateUtils.getId(script));
        result.setScriptType(script.getScriptType());
        result.setPluginType(script.getPluginType());
        if (script.getEntityKind() == null) {
            entityKindArray = null;
        } else {
            EntityKind[] entityKindArray2 = new EntityKind[1];
            entityKindArray = entityKindArray2;
            entityKindArray2[0] = script.getEntityKind();
        }
        result.setEntityKind(entityKindArray);
        result.setName(script.getName());
        result.setDescription(script.getDescription());
        result.setScript(script.getScript());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate());
        result.setRegistrationDate(script.getRegistrationDate());
        result.setRegistrator(PersonTranslator.translate(script.getRegistrator()));
        result.setModificationDate(script.getModificationDate());
        result.setAvailable(script.isAvailable());
        return result;
    }

    public static List<Script> enhancePredeployedPlugins(List<Script> scripts, IEntityValidatorFactory entityValidationFactory, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        for (Script script : scripts) {
            ScriptTranslator.enhancePredeployedPlugin(script, entityValidationFactory, dynamicPropertyCalculatorFactory, managedPropertyEvaluatorFactory);
        }
        return scripts;
    }

    public static Script enhancePredeployedPlugin(Script script, IEntityValidatorFactory entityValidationFactory, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        if (script.getPluginType() == PluginType.PREDEPLOYED) {
            ICommonPropertyBasedHotDeployPlugin plugin = null;
            switch (script.getScriptType()) {
                case ENTITY_VALIDATION: {
                    plugin = (ICommonPropertyBasedHotDeployPlugin)entityValidationFactory.tryGetPredeployedPluginByName(script.getName());
                    break;
                }
                case DYNAMIC_PROPERTY: {
                    plugin = (ICommonPropertyBasedHotDeployPlugin)dynamicPropertyCalculatorFactory.tryGetPredeployedPluginByName(script.getName());
                    break;
                }
                case MANAGED_PROPERTY: {
                    plugin = (ICommonPropertyBasedHotDeployPlugin)managedPropertyEvaluatorFactory.tryGetPredeployedPluginByName(script.getName());
                }
            }
            if (plugin != null) {
                script.setEntityKind(ScriptTranslator.translateEntityKinds(plugin.getSupportedEntityKinds()));
            }
        }
        return script;
    }

    public static EntityKind[] translateEntityKinds(EnumSet<ICommonPropertyBasedHotDeployPlugin.EntityKind> entityKinds) {
        if (entityKinds == null) {
            return null;
        }
        if (entityKinds.size() == ICommonPropertyBasedHotDeployPlugin.EntityKind.values().length) {
            return null;
        }
        EntityKind[] kinds = new EntityKind[entityKinds.size()];
        int counter = 0;
        for (ICommonPropertyBasedHotDeployPlugin.EntityKind kind : entityKinds) {
            kinds[counter++] = EntityKind.valueOf((String)kind.name());
        }
        return kinds;
    }
}

