/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.lang.reflect.Field;
import java.sql.Connection;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.engine.transaction.internal.TransactionImpl;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;

public class EodSqlUtils {
    public static void setManagedConnection(Transaction transaction) throws IllegalAccessException {
        try {
            TransactionCoordinator.TransactionDriver transactionDriver = ((TransactionImpl)transaction).internalGetTransactionDriverControl();
            Class<?> transactionDriverClass = transactionDriver.getClass();
            Field jdbcResourceTransactionField = transactionDriverClass.getDeclaredField("jdbcResourceTransaction");
            jdbcResourceTransactionField.setAccessible(true);
            LogicalConnectionImplementor logicalConnectionImplementor = (LogicalConnectionImplementor)jdbcResourceTransactionField.get(transactionDriver);
            Connection connection = logicalConnectionImplementor.getPhysicalConnection();
            QueryTool.setManagedDatabaseConnection((Connection)connection);
        }
        catch (ClassCastException | NoSuchFieldException e) {
            Logger log = LogFactory.getLogger((LogCategory)LogCategory.TRACKING, EodSqlUtils.class);
            log.warn((Object)("Attempt to create an EodSql managed transaction with an underlying transaction that has no JDBC context: " + transaction));
        }
    }

    public static void clearManagedConnection() {
        QueryTool.clearManagedDatabaseConnection();
    }
}

