/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.collection.UnmodifiableCollectionDecorator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public final class HibernateUtils {
    private HibernateUtils() {
    }

    private static final Object getRealProxy(Object proxy) {
        boolean unmodifiable = proxy instanceof UnmodifiableCollectionDecorator;
        Object realProxy = unmodifiable ? ((UnmodifiableCollectionDecorator)proxy).getDecorated() : proxy;
        return realProxy;
    }

    public static final void initialize(Object proxy) {
        Hibernate.initialize((Object)HibernateUtils.getRealProxy(proxy));
    }

    public static final boolean isInitialized(Object proxy) {
        return Hibernate.isInitialized((Object)HibernateUtils.getRealProxy(proxy));
    }

    public static final Long getId(IIdHolder idHolder) {
        if (idHolder instanceof HibernateProxy) {
            return (Long)((HibernateProxy)idHolder).getHibernateLazyInitializer().getIdentifier();
        }
        return idHolder.getId();
    }

    public static final <T> T unproxy(T proxy) {
        if (proxy instanceof HibernateProxy && Hibernate.isInitialized(proxy)) {
            LazyInitializer lazyInitializer = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            SharedSessionContractImplementor sessionImplementor = lazyInitializer.getSession();
            if (sessionImplementor != null) {
                return (T)sessionImplementor.getPersistenceContext().unproxy(proxy);
            }
            return (T)lazyInitializer.getImplementation();
        }
        return proxy;
    }

    public static final void setBatchUpdateMode(Session session, boolean batchMode) {
        CacheMode cacheMode = batchMode ? CacheMode.IGNORE : CacheMode.NORMAL;
        session.setCacheMode(cacheMode);
        FlushMode mode = batchMode ? FlushMode.COMMIT : FlushMode.AUTO;
        session.setFlushMode(mode);
    }
}

