/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class RelationshipUtils {
    public static void updateModificationDateAndModifierOfRelatedProjectsOfExperiments(List<ExperimentPE> experiments, IAuthSession session, Date modificationTimestamp) {
        for (ExperimentPE experiment : experiments) {
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment.getProject(), session, modificationTimestamp);
        }
    }

    public static void updateModificationDateAndModifierOfRelatedEntitiesOfSamples(List<SamplePE> samples, IAuthSession session, Date modificationTimestamp) {
        for (SamplePE sample : samples) {
            Set<SampleRelationshipPE> childRelationships;
            List<SamplePE> parents;
            SamplePE container;
            ExperimentPE experiment = sample.getExperiment();
            if (experiment != null) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session, modificationTimestamp);
            }
            if ((container = sample.getContainer()) != null) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)container, session, modificationTimestamp);
            }
            if ((parents = sample.getParents()) != null) {
                for (SamplePE parent : parents) {
                    RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session, modificationTimestamp);
                }
            }
            if ((childRelationships = sample.getChildRelationships()) == null) continue;
            for (SampleRelationshipPE childRelationship : childRelationships) {
                SamplePE childSample = childRelationship.getChildSample();
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)childSample, session, modificationTimestamp);
            }
        }
    }

    public static void updateModificationDateAndModifierOfRelatedEntitiesOfDataSets(List<DataPE> dataSets, IAuthSession session, Date modificationTimestamp) {
        for (DataPE dataSet : dataSets) {
            ExperimentPE experiment = dataSet.getExperiment();
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session, modificationTimestamp);
            SamplePE sample = dataSet.tryGetSample();
            if (sample != null) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, modificationTimestamp);
            }
            RelationshipUtils.updateModificationDateAndModifierOfDataSets(dataSet.getChildren(), session, modificationTimestamp);
            RelationshipUtils.updateModificationDateAndModifierOfDataSets(dataSet.getParents(), session, modificationTimestamp);
            Set<DataSetRelationshipPE> relationships = dataSet.getParentRelationships();
            for (DataSetRelationshipPE relationship : RelationshipUtils.getContainerComponentRelationships(relationships)) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)relationship.getParentDataSet(), session, modificationTimestamp);
            }
        }
    }

    private static void updateModificationDateAndModifierOfDataSets(List<DataPE> dataSets, IAuthSession session, Date modificationTimestamp) {
        if (dataSets != null) {
            for (DataPE child : dataSets) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)child, session, modificationTimestamp);
            }
        }
    }

    public static boolean isParentChildRelationship(DataSetRelationshipPE relationship) {
        return RelationshipUtils.isRelationshipOfType(relationship, "$PARENT_CHILD");
    }

    public static boolean isContainerComponentRelationship(DataSetRelationshipPE relationship) {
        return RelationshipUtils.isRelationshipOfType(relationship, "$CONTAINER_COMPONENT");
    }

    private static boolean isRelationshipOfType(DataSetRelationshipPE relationship, String code) {
        return relationship.getRelationshipType().getCode().equals(code);
    }

    public static List<DataSetRelationshipPE> getParentChildRelationships(Collection<DataSetRelationshipPE> relationships) {
        return RelationshipUtils.filterRelationships(relationships, "$PARENT_CHILD");
    }

    public static List<DataSetRelationshipPE> getContainerComponentRelationships(Collection<DataSetRelationshipPE> relationships) {
        return RelationshipUtils.filterRelationships(relationships, "$CONTAINER_COMPONENT");
    }

    private static List<DataSetRelationshipPE> filterRelationships(Collection<DataSetRelationshipPE> relationships, String code) {
        ArrayList<DataSetRelationshipPE> result = new ArrayList<DataSetRelationshipPE>();
        for (DataSetRelationshipPE relationship : relationships) {
            if (!relationship.getRelationshipType().getCode().equals(code)) continue;
            result.add(relationship);
        }
        return result;
    }

    public static void setSampleForDataSet(DataPE dataSet, SamplePE sample, IAuthSession session, Date modificationTimestamp) {
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet.tryGetSample(), session, modificationTimestamp);
        dataSet.setSample(sample);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, modificationTimestamp);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet, session, modificationTimestamp);
    }

    public static void setContainerForSample(SamplePE sample, SamplePE container, IAuthSession session, Date modificationTimestamp) {
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample.getContainer(), session, modificationTimestamp);
        sample.setContainer(container);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)container, session, modificationTimestamp);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, modificationTimestamp);
    }

    public static void setExperimentForDataSet(DataPE dataSet, ExperimentPE experiment, IAuthSession session, Date modificationTimestamp) {
        Long eid;
        Long deid = dataSet.getExperiment() == null ? null : dataSet.getExperiment().getId();
        Long l = eid = experiment == null ? null : experiment.getId();
        if (deid == eid) {
            return;
        }
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet.getExperiment(), session, modificationTimestamp);
        dataSet.setExperiment(experiment);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session, modificationTimestamp);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet, session, modificationTimestamp);
    }

    public static void updateModificationDateAndModifierOfExperimentAndProject(ExperimentPE experiment, ProjectPE previousProject, IAuthSession session, Date modificationTimestamp) {
        ProjectPE project;
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session, modificationTimestamp);
        if (SamplePE.projectSamplesEnabled && (project = experiment.getProject()) != previousProject) {
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)project, session, modificationTimestamp);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)previousProject, session, modificationTimestamp);
        }
    }

    public static void updateModificationDateAndModifier(IModifierAndModificationDateBean beanOrNull, IAuthSession session, Date modificationTimestamp) {
        if (beanOrNull == null) {
            return;
        }
        RelationshipUtils.log(beanOrNull, session);
        PersonPE person = session.tryGetPerson();
        RelationshipUtils.updateModificationDateAndModifier(beanOrNull, person, modificationTimestamp);
    }

    public static void updateModificationDateAndModifier(IModifierAndModificationDateBean beanOrNull, PersonPE personOrNull, Date modificationTimestamp) {
        if (personOrNull != null) {
            beanOrNull.setModifier(personOrNull);
        }
        beanOrNull.setModificationDate(modificationTimestamp);
    }

    private static void log(IModifierAndModificationDateBean beanOrNull, IAuthSession session) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().contains("OptimisticLockingTest")) continue;
            System.out.println("===== UPDATE modification date and modifier ===== " + stackTraceElement.getMethodName());
            System.out.println("bean: " + beanOrNull);
            System.out.println("user: " + session.tryGetPerson());
            System.out.println("\t" + stackTrace[3]);
            System.out.println("\t" + stackTrace[4]);
            System.out.println("\t" + stackTrace[5]);
            System.out.println("\t...");
            System.out.println("\t" + stackTraceElement);
            break;
        }
    }
}

