/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.demo.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.IValidator;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewSamplePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SamplePropertyAccessValidator;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.ISampleTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleParentWithDerivedDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.MetaprojectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import ch.systemsx.cisd.openbis.plugin.demo.server.DemoServerLogger;
import ch.systemsx.cisd.openbis.plugin.demo.server.IDemoBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.demo.shared.IDemoServer;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="demo-plugin-server")
public final class DemoServer
extends AbstractServer<IDemoServer>
implements IDemoServer {
    @Resource(name="demo-business-object-factory")
    private IDemoBusinessObjectFactory businessObjectFactory;
    @Resource(name="managed-property-evaluator-factory")
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public DemoServer() {
    }

    @Private
    DemoServer(IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, IDemoBusinessObjectFactory businessObjectFactory, ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin, IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin) {
        super(sessionManager, daoFactory, propertiesBatchManager, sampleTypeSlaveServerPlugin, dataSetTypeSlaveServerPlugin);
        this.businessObjectFactory = businessObjectFactory;
    }

    public final IDemoServer createLogger(IInvocationLoggerContext context) {
        return new DemoServerLogger(this.getSessionManager(), context);
    }

    public final SampleParentWithDerived getSampleInfo(String sessionToken, SampleIdentifier identifier) {
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadBySampleIdentifier(identifier);
        SamplePE sample = sampleBO.getSample();
        return this.getSampleInfo(session, sample);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public SampleParentWithDerived getSampleInfo(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId sampleId) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadDataByTechId(sampleId);
        SamplePE sample = sampleBO.getSample();
        return this.getSampleInfo(session, sample);
    }

    private SampleParentWithDerived getSampleInfo(Session session, SamplePE sample) {
        ISampleTypeSlaveServerPlugin plugin = this.getSampleTypeSlaveServerPlugin(sample.getSampleType());
        SampleParentWithDerivedDTO sampleInfo = plugin.getSampleInfo(session, sample);
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), sample);
        return SampleTranslator.translate(sampleInfo, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory, (IValidator<IIdentifierHolder>)new SamplePropertyAccessValidator(session, this.getDAOFactory()));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_USER})
    public void registerSample(String sessionToken, @AuthorizationGuard(guardClass=NewSamplePredicate.class) NewSample newSample, Collection<NewAttachment> attachments) {
        throw new NotImplementedException();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public int getNumberOfExperiments(String sessionToken) {
        return this.getDAOFactory().getExperimentDAO().listExperiments().size();
    }
}

