/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DatastoreServiceDescriptionModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDirectlyConnectedController;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.AbstractDataSetsSection;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.EntityConnectionTypeProvider;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.CheckBox;

public abstract class AbstractEntityDataSetsSection
extends AbstractDataSetsSection {
    public static final String SHOW_ONLY_DIRECTLY_CONNECTED_CHECKBOX_ID_POSTFIX = "-show_only_directly_connected_checkbox";
    private final CheckBox showOnlyDirectlyConnectedCheckBox = this.createShowOnlyDirectlyConnectedCheckBox();
    private final TechId entityId;
    private final BasicEntityType entityType;

    public AbstractEntityDataSetsSection(IViewContext<?> viewContext, TechId entityId, BasicEntityType entityType) {
        super(viewContext.getMessage("external_data_heading", new Object[0]), viewContext, (IIdHolder)entityId);
        this.entityId = entityId;
        this.entityType = entityType;
    }

    private CheckBox createShowOnlyDirectlyConnectedCheckBox() {
        CheckBox result = new CheckBox();
        result.setId(this.getId() + SHOW_ONLY_DIRECTLY_CONNECTED_CHECKBOX_ID_POSTFIX);
        result.setBoxLabel(this.viewContext.getMessage("show_only_directly_connected", new Object[0]));
        result.setValue(Boolean.valueOf(true));
        return result;
    }

    @Override
    protected void initWidgets(AbstractExternalDataGrid browser) {
        this.getHeader().addTool((Component)this.showOnlyDirectlyConnectedCheckBox);
        this.reportSelectionWidget.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<DatastoreServiceDescriptionModel>(){

            public void selectionChanged(SelectionChangedEvent<DatastoreServiceDescriptionModel> se) {
                DatastoreServiceDescriptionModel selectedItem = (DatastoreServiceDescriptionModel)se.getSelectedItem();
                if (selectedItem != null) {
                    DatastoreServiceDescription service = selectedItem.getBaseObject();
                    if (service.getLabel().equals("Overview")) {
                        AbstractEntityDataSetsSection.this.showOnlyDirectlyConnectedCheckBox.show();
                    } else {
                        AbstractEntityDataSetsSection.this.showOnlyDirectlyConnectedCheckBox.hide();
                    }
                }
            }
        });
        super.initWidgets(browser);
    }

    @Override
    protected IDisposableComponent createDatasetBrowserComponent() {
        return this.createDataSetBrowser(this.entityType, this.entityId, new EntityConnectionTypeProvider(this.showOnlyDirectlyConnectedCheckBox));
    }

    protected abstract IDisposableComponent createDataSetBrowser(BasicEntityType var1, TechId var2, IDirectlyConnectedController var3);
}

