/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeFieldWithGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MetaprojectArea;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MetaprojectChooserButton;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ButtonWithConfirmations;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.PropertiesEditor;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractGenericEntityRegistrationForm<T extends EntityType, S extends EntityTypePropertyType<T>>
extends AbstractRegistrationForm
implements IDatabaseModificationObserver {
    public static final String ID_PREFIX = "openbis_";
    public static final String ID_SUFFIX_CODE = "code";
    protected final EntityKind entityKind;
    protected final IViewContext<IGenericClientServiceAsync> viewContext;
    protected final TechId techIdOrNull;
    protected CodeFieldWithGenerator codeField;
    protected PropertiesEditor<T, S> propertiesEditor;
    protected MetaprojectArea metaprojectArea;
    protected MetaprojectChooserButton metaprojectChooserButton;
    private final Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions;

    protected AbstractGenericEntityRegistrationForm(IViewContext<IGenericClientServiceAsync> viewContext, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptionsOrNull, IIdAndCodeHolder identifiableOrNull, EntityKind entityKind) {
        super(viewContext, AbstractGenericEntityRegistrationForm.createId(identifiableOrNull, entityKind), 190, 500);
        this.viewContext = viewContext;
        this.inputWidgetDescriptions = inputWidgetDescriptionsOrNull == null ? Collections.emptyMap() : inputWidgetDescriptionsOrNull;
        this.entityKind = entityKind;
        this.techIdOrNull = TechId.create((IIdHolder)identifiableOrNull);
    }

    protected AbstractGenericEntityRegistrationForm(IViewContext<IGenericClientServiceAsync> viewContext, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, EntityKind entityKind) {
        this(viewContext, inputWidgetDescriptions, null, entityKind);
    }

    protected final void onRender(Element target, int index) {
        super.onRender(target, index);
        this.setLoading(true);
        this.loadForm();
    }

    public static final String createId(IIdAndCodeHolder identifiable, EntityKind entityKind) {
        return ID_PREFIX + AbstractGenericEntityRegistrationForm.createSimpleId(identifiable, entityKind);
    }

    public static final String createId(TechId techId, EntityKind entityKind) {
        return ID_PREFIX + AbstractGenericEntityRegistrationForm.createSimpleId(techId, entityKind);
    }

    protected static final String createSimpleId(IIdAndCodeHolder identifiable, EntityKind entityKind) {
        return AbstractGenericEntityRegistrationForm.createSimpleId(TechId.create((IIdHolder)identifiable), entityKind);
    }

    protected static final String createSimpleId(TechId techId, EntityKind entityKind) {
        String editOrRegister = techId == null ? "register" : "edit_" + techId;
        return "generic-" + entityKind.name().toLowerCase() + "-" + editOrRegister + "_form";
    }

    @Override
    public final void update(Set<DatabaseModificationKind> observedModifications) {
        this.createDatabaseModificationObserver().update(observedModifications);
    }

    @Override
    public final DatabaseModificationKind[] getRelevantModifications() {
        return this.createDatabaseModificationObserver().getRelevantModifications();
    }

    private IDatabaseModificationObserver createDatabaseModificationObserver() {
        CompositeDatabaseModificationObserver compositeObserver = new CompositeDatabaseModificationObserver();
        compositeObserver.addObservers(this.getFormFieldsWithoutPropertyFields());
        compositeObserver.addObservers(this.getFormPropertyFields());
        return compositeObserver;
    }

    private final void createCommonFormFields() {
        this.propertiesEditor = this.createPropertiesEditor(AbstractGenericEntityRegistrationForm.createId(this.techIdOrNull, this.entityKind), this.inputWidgetDescriptions, this.viewContext.getCommonViewContext());
        this.codeField = new CodeFieldWithGenerator(this.viewContext, this.viewContext.getMessage(ID_SUFFIX_CODE, new Object[0]), this.getGeneratedCodePrefix(), this.entityKind, this.isAutoGenerateCode());
        this.codeField.setId(this.getId() + ID_SUFFIX_CODE);
        boolean codeReadonly = this.techIdOrNull != null || this.isAutoGenerateCode();
        this.codeField.setReadOnly(codeReadonly);
        this.codeField.setHideTrigger(codeReadonly);
        if (this.techIdOrNull != null) {
            this.codeField.disable();
        }
        if (this.isAutoGenerateCode()) {
            this.formPanel.addDirtyCheckIgnoredField((Field<?>)this.codeField);
        }
        this.metaprojectArea = new MetaprojectArea(this.viewContext, this.getId());
        this.metaprojectChooserButton = new MetaprojectChooserButton(this.viewContext, this.getId(), new IChosenEntitiesProvider<String>(){

            @Override
            public List<String> getEntities() {
                String[] metaprojects = AbstractGenericEntityRegistrationForm.this.metaprojectArea.tryGetMetaprojects();
                return metaprojects != null ? Arrays.asList(metaprojects) : null;
            }

            @Override
            public boolean isBlackList() {
                return true;
            }
        });
        this.metaprojectChooserButton.addChosenEntityListener(new IChosenEntitiesListener<TableModelRowWithObject<Metaproject>>(){

            @Override
            public void entitiesChosen(List<TableModelRowWithObject<Metaproject>> entities) {
                for (TableModelRowWithObject<Metaproject> entity : entities) {
                    AbstractGenericEntityRegistrationForm.this.metaprojectArea.appendItem(entity.getObjectOrNull().getName());
                }
            }
        });
    }

    @Override
    protected void addSaveButtonConfirmationListener(ButtonWithConfirmations button) {
        super.addSaveButtonConfirmationListener(button);
        button.addConfirmation(new ButtonWithConfirmations.IConfirmation(){

            @Override
            public void confirm(ButtonWithConfirmations.IConfirmationChain confirmationChain) {
                String[] requestedMetaprojects = AbstractGenericEntityRegistrationForm.this.metaprojectArea.tryGetMetaprojects();
                if (AbstractGenericEntityRegistrationForm.this.formPanel.isValid() && requestedMetaprojects != null && requestedMetaprojects.length > 0) {
                    AbstractGenericEntityRegistrationForm.this.viewContext.getCommonService().listMetaprojects(new CreateNonExistingMetaprojectsConfirmationCallback(AbstractGenericEntityRegistrationForm.this.viewContext, confirmationChain, requestedMetaprojects));
                } else {
                    confirmationChain.next();
                }
            }
        });
    }

    protected boolean isAutoGenerateCode() {
        return false;
    }

    protected String getGeneratedCodePrefix() {
        return this.entityKind.name().substring(0, 1);
    }

    protected void updatePropertyFieldsOriginalValues() {
        for (DatabaseModificationAwareField<?> f : this.propertiesEditor.getPropertyFields()) {
            this.updateFieldOriginalValue((Field)f.get());
        }
    }

    protected <D> void updateFieldOriginalValue(Field<D> field) {
        field.updateOriginalValue(field.getValue());
    }

    private final List<DatabaseModificationAwareField<?>> getFormFieldsWithoutPropertyFields() {
        ArrayList fields = new ArrayList();
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.codeField));
        for (DatabaseModificationAwareField<?> specificField : this.getEntitySpecificFormFields()) {
            fields.add(specificField);
        }
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.metaprojectArea));
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.metaprojectChooserButton.getField()));
        return fields;
    }

    private final List<DatabaseModificationAwareField<?>> getFormPropertyFields() {
        return this.propertiesEditor.getPropertyFields();
    }

    protected void initGUI() {
        this.createCommonFormFields();
        this.createEntitySpecificFormFields();
        this.initializeFormFields();
        this.addFormFieldsToPanel(this.formPanel);
        this.layout();
        this.postRenderingTask();
        this.setLoading(false);
    }

    protected void postRenderingTask() {
    }

    protected void addFormFieldsToPanel(FormPanel panel) {
        for (DatabaseModificationAwareField<?> fieldHolder : this.getFormFieldsWithoutPropertyFields()) {
            panel.add((Widget)fieldHolder.get());
        }
        this.propertiesEditor.addPropertyFieldsWithFieldsetToPanel(panel);
    }

    protected final List<IEntityProperty> extractProperties() {
        return this.propertiesEditor.extractProperties();
    }

    protected abstract void createEntitySpecificFormFields();

    protected abstract List<DatabaseModificationAwareField<?>> getEntitySpecificFormFields();

    protected abstract void initializeFormFields();

    protected abstract void loadForm();

    protected abstract PropertiesEditor<T, S> createPropertiesEditor(String var1, Map<String, List<IManagedInputWidgetDescription>> var2, IViewContext<ICommonClientServiceAsync> var3);

    private static class CreateNonExistingMetaprojectsConfirmationCallback
    extends AbstractAsyncCallback<List<Metaproject>> {
        private ButtonWithConfirmations.IConfirmationChain confirmationChain;
        private String[] requestedMetaprojects;

        public CreateNonExistingMetaprojectsConfirmationCallback(IViewContext<?> viewContext, ButtonWithConfirmations.IConfirmationChain confirmationChain, String[] requestedMetaprojects) {
            super(viewContext);
            this.confirmationChain = confirmationChain;
            this.requestedMetaprojects = requestedMetaprojects;
        }

        @Override
        protected void process(List<Metaproject> existingMetaprojectsList) {
            HashSet<String> existingMetaprojectsSet = new HashSet<String>();
            LinkedHashSet<String> notExistingMetaprojects = new LinkedHashSet<String>();
            if (existingMetaprojectsList != null) {
                for (Metaproject existingMetaproject : existingMetaprojectsList) {
                    existingMetaprojectsSet.add(existingMetaproject.getName().toLowerCase());
                }
            }
            if (this.requestedMetaprojects != null) {
                for (String requestedMetaproject : this.requestedMetaprojects) {
                    if (existingMetaprojectsSet.contains(requestedMetaproject.toLowerCase())) continue;
                    notExistingMetaprojects.add(requestedMetaproject);
                }
            }
            if (notExistingMetaprojects.isEmpty()) {
                this.confirmationChain.next();
            } else {
                new ConfirmationDialog(this.viewContext.getMessage("create_not_existing_metaprojects_confirmation_title", new Object[0]), this.viewContext.getMessage("create_not_existing_metaprojects_confirmation_msg", notExistingMetaprojects)){

                    @Override
                    protected void onYes() {
                        confirmationChain.next();
                    }
                }.show();
            }
        }
    }
}

