/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.ClientPluginAdapter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.GeneralImportComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.AbstractGenericEntityRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.GeneralImportForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.GenericViewContext;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.GenericDataSetBatchUpdateForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.GenericDataSetEditForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.GenericDataSetViewer;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentBatchRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentBatchUpdateForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentEditForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentViewer;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.material.GenericMaterialBatchRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.material.GenericMaterialBatchUpdateForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.material.GenericMaterialEditForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.material.GenericMaterialViewer;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.GenericSampleBatchRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.GenericSampleBatchUpdateForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.GenericSampleEditForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.GenericSampleRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.GenericSampleViewer;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClientPluginFactory
extends AbstractClientPluginFactory<GenericViewContext> {
    public ClientPluginFactory(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        super(originalViewContext);
    }

    @Override
    protected final GenericViewContext createViewContext(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        return new GenericViewContext(originalViewContext);
    }

    @Override
    public final <T extends BasicEntityType, I extends IIdAndCodeHolder> IClientPlugin<T, I> createClientPlugin(EntityKind entityKind) {
        if (entityKind == null) {
            return new ClientPluginAdapter<T, I>(){

                @Override
                public Widget createBatchRegistrationForEntityType(T entityType) {
                    return this.createBatchUpdateForEntityType((T)entityType);
                }

                @Override
                public Widget createBatchUpdateForEntityType(T entityType) {
                    return new GeneralImportForm((IViewContext<IGenericClientServiceAsync>)ClientPluginFactory.this.getViewContext(), GeneralImportComponent.createId(), "general-import");
                }
            };
        }
        if (EntityKind.EXPERIMENT.equals((Object)entityKind)) {
            return new ExperimentClientPlugin();
        }
        if (EntityKind.SAMPLE.equals((Object)entityKind)) {
            return new SampleClientPlugin();
        }
        if (EntityKind.MATERIAL.equals((Object)entityKind)) {
            return new MaterialClientPlugin();
        }
        if (EntityKind.DATA_SET.equals((Object)entityKind)) {
            return new DataSetClientPlugin();
        }
        throw new UnsupportedOperationException("IClientPlugin for entity kind '" + entityKind + "' not implemented yet.");
    }

    @Override
    public final Set<String> getEntityTypeCodes(EntityKind entityKind) {
        throw new UnsupportedOperationException("Generic plugin factory supports every sample type.");
    }

    private String getViewerTitle(String entityKindDictKey, IIdAndCodeHolder identifiable) {
        return AbstractViewer.getTitle(this.getViewContext(), entityKindDictKey, (ICodeHolder)identifiable);
    }

    private String getEditorTitle(String entityKindDictKey, IIdAndCodeHolder identifiable) {
        return AbstractRegistrationForm.getEditTitle(this.getViewContext(), entityKindDictKey, identifiable);
    }

    @Override
    protected IModule maybeCreateModule() {
        return null;
    }

    private final class DataSetClientPlugin
    extends ClientPluginAdapter<DataSetType, IIdAndCodeHolder> {
        private DataSetClientPlugin() {
        }

        @Override
        public final AbstractTabItemFactory createEntityViewer(final IEntityInformationHolderWithPermId entity) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DatabaseModificationAwareComponent dataSetViewer = GenericDataSetViewer.create(ClientPluginFactory.this.getViewContext(), entity);
                    return DefaultTabItem.create(this.getTabTitle(), dataSetViewer, ClientPluginFactory.this.getViewContext(), false);
                }

                @Override
                public String getId() {
                    return GenericDataSetViewer.createId(entity);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.DATA_SET, HelpPageIdentifier.HelpPageAction.VIEW);
                }

                @Override
                public String getTabTitle() {
                    return ClientPluginFactory.this.getViewerTitle("data_set", entity);
                }

                @Override
                public String tryGetLink() {
                    return LinkExtractor.tryExtract(entity);
                }
            };
        }

        @Override
        public AbstractTabItemFactory createEntityEditor(final IIdAndCodeHolder identifiable) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DatabaseModificationAwareComponent component = GenericDataSetEditForm.create(ClientPluginFactory.this.getViewContext(), identifiable);
                    return DefaultTabItem.create(this.getTabTitle(), component, ClientPluginFactory.this.getViewContext(), true);
                }

                @Override
                public String getId() {
                    return AbstractGenericEntityRegistrationForm.createId(identifiable, EntityKind.DATA_SET);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.DATA_SET, HelpPageIdentifier.HelpPageAction.EDIT);
                }

                @Override
                public String getTabTitle() {
                    return ClientPluginFactory.this.getEditorTitle("data_set", identifiable);
                }

                @Override
                public String tryGetLink() {
                    return null;
                }
            };
        }

        @Override
        public final Widget createBatchUpdateForEntityType(DataSetType dataSetType) {
            return new GenericDataSetBatchUpdateForm((IViewContext<IGenericClientServiceAsync>)ClientPluginFactory.this.getViewContext(), dataSetType);
        }
    }

    private final class ExperimentClientPlugin
    extends ClientPluginAdapter<ExperimentType, IIdAndCodeHolder> {
        private ExperimentClientPlugin() {
        }

        @Override
        public final AbstractTabItemFactory createEntityViewer(final IEntityInformationHolderWithPermId entity) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DatabaseModificationAwareComponent experimentViewer = GenericExperimentViewer.create(ClientPluginFactory.this.getViewContext(), entity.getEntityType(), entity);
                    return DefaultTabItem.create(this.getTabTitle(), experimentViewer, ClientPluginFactory.this.getViewContext(), false);
                }

                @Override
                public String getId() {
                    return GenericExperimentViewer.createId(entity);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.VIEW);
                }

                @Override
                public String getTabTitle() {
                    return ClientPluginFactory.this.getViewerTitle("experiment", entity);
                }

                @Override
                public String tryGetLink() {
                    return LinkExtractor.tryExtract(entity);
                }
            };
        }

        @Override
        public DatabaseModificationAwareWidget createRegistrationForEntityType(ExperimentType entityType, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, ActionContext context) {
            GenericExperimentRegistrationForm form = new GenericExperimentRegistrationForm((IViewContext<IGenericClientServiceAsync>)ClientPluginFactory.this.getViewContext(), inputWidgetDescriptions, context, entityType);
            return new DatabaseModificationAwareWidget((Widget)form, (IDatabaseModificationObserver)form);
        }

        @Override
        public final Widget createBatchRegistrationForEntityType(ExperimentType type) {
            return new GenericExperimentBatchRegistrationForm((IViewContext<IGenericClientServiceAsync>)ClientPluginFactory.this.getViewContext(), type);
        }

        @Override
        public Widget createBatchUpdateForEntityType(ExperimentType entityType) {
            return new GenericExperimentBatchUpdateForm((IViewContext<IGenericClientServiceAsync>)ClientPluginFactory.this.getViewContext(), entityType);
        }

        @Override
        public AbstractTabItemFactory createEntityEditor(final IIdAndCodeHolder identifiable) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DatabaseModificationAwareComponent component = GenericExperimentEditForm.create(ClientPluginFactory.this.getViewContext(), identifiable);
                    return DefaultTabItem.create(this.getTabTitle(), component, ClientPluginFactory.this.getViewContext(), true);
                }

                @Override
                public String getId() {
                    return AbstractGenericEntityRegistrationForm.createId(identifiable, EntityKind.EXPERIMENT);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.EDIT);
                }

                @Override
                public String getTabTitle() {
                    return ClientPluginFactory.this.getEditorTitle("experiment", identifiable);
                }

                @Override
                public String tryGetLink() {
                    return null;
                }
            };
        }
    }

    private final class MaterialClientPlugin
    extends ClientPluginAdapter<MaterialType, IIdAndCodeHolder> {
        private MaterialClientPlugin() {
        }

        @Override
        public final Widget createBatchRegistrationForEntityType(MaterialType materialType) {
            return new GenericMaterialBatchRegistrationForm((IViewContext<IGenericClientServiceAsync>)ClientPluginFactory.this.getViewContext(), materialType);
        }

        @Override
        public Widget createBatchUpdateForEntityType(MaterialType entityType) {
            return new GenericMaterialBatchUpdateForm((IViewContext<IGenericClientServiceAsync>)ClientPluginFactory.this.getViewContext(), entityType);
        }

        @Override
        public final AbstractTabItemFactory createEntityViewer(final IEntityInformationHolderWithPermId entity) {
            final TechId techId = TechId.create((IIdHolder)entity);
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DatabaseModificationAwareComponent materialViewer = GenericMaterialViewer.create(ClientPluginFactory.this.getViewContext(), techId);
                    return DefaultTabItem.create(this.getTabTitle(), materialViewer, ClientPluginFactory.this.getViewContext(), false);
                }

                @Override
                public String getId() {
                    return GenericMaterialViewer.createId(techId);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.MATERIAL, HelpPageIdentifier.HelpPageAction.VIEW);
                }

                @Override
                public String getTabTitle() {
                    return ClientPluginFactory.this.getViewerTitle("material", entity);
                }

                @Override
                public String tryGetLink() {
                    return LinkExtractor.tryExtract(entity);
                }
            };
        }

        @Override
        public AbstractTabItemFactory createEntityEditor(final IIdAndCodeHolder identifiable) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DatabaseModificationAwareComponent component = GenericMaterialEditForm.create(ClientPluginFactory.this.getViewContext(), identifiable, true);
                    return DefaultTabItem.create(this.getTabTitle(), component, ClientPluginFactory.this.getViewContext(), true);
                }

                @Override
                public String getId() {
                    return AbstractGenericEntityRegistrationForm.createId(identifiable, EntityKind.MATERIAL);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.MATERIAL, HelpPageIdentifier.HelpPageAction.EDIT);
                }

                @Override
                public String getTabTitle() {
                    return ClientPluginFactory.this.getEditorTitle("material", identifiable);
                }

                @Override
                public String tryGetLink() {
                    return null;
                }
            };
        }
    }

    private final class SampleClientPlugin
    implements IClientPlugin<SampleType, IIdAndCodeHolder> {
        private SampleClientPlugin() {
        }

        @Override
        public AbstractTabItemFactory createEntityViewer(final IEntityInformationHolderWithPermId entity) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DatabaseModificationAwareComponent sampleViewer = GenericSampleViewer.create(ClientPluginFactory.this.getViewContext(), entity);
                    return DefaultTabItem.create(this.getTabTitle(), sampleViewer, ClientPluginFactory.this.getViewContext(), false);
                }

                @Override
                public String getId() {
                    return GenericSampleViewer.createId(entity);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.VIEW);
                }

                @Override
                public String getTabTitle() {
                    return ClientPluginFactory.this.getViewerTitle("sample", entity);
                }

                @Override
                public String tryGetLink() {
                    return LinkExtractor.tryExtract(entity);
                }
            };
        }

        @Override
        public final DatabaseModificationAwareWidget createRegistrationForEntityType(SampleType sampleType, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, ActionContext context) {
            GenericSampleRegistrationForm form = new GenericSampleRegistrationForm((IViewContext<IGenericClientServiceAsync>)ClientPluginFactory.this.getViewContext(), inputWidgetDescriptions, sampleType, context);
            return new DatabaseModificationAwareWidget((Widget)form, (IDatabaseModificationObserver)form);
        }

        @Override
        public final Widget createBatchRegistrationForEntityType(SampleType sampleType) {
            return new GenericSampleBatchRegistrationForm((IViewContext<IGenericClientServiceAsync>)ClientPluginFactory.this.getViewContext(), sampleType);
        }

        @Override
        public final Widget createBatchUpdateForEntityType(SampleType sampleType) {
            return new GenericSampleBatchUpdateForm((IViewContext<IGenericClientServiceAsync>)ClientPluginFactory.this.getViewContext(), sampleType);
        }

        @Override
        public AbstractTabItemFactory createEntityEditor(final IIdAndCodeHolder identifiable) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DatabaseModificationAwareComponent component = GenericSampleEditForm.create(ClientPluginFactory.this.getViewContext(), identifiable);
                    return DefaultTabItem.create(this.getTabTitle(), component, ClientPluginFactory.this.getViewContext(), true);
                }

                @Override
                public String getId() {
                    return AbstractGenericEntityRegistrationForm.createId(identifiable, EntityKind.SAMPLE);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.EDIT);
                }

                @Override
                public String getTabTitle() {
                    return ClientPluginFactory.this.getEditorTitle("sample", identifiable);
                }

                @Override
                public String tryGetLink() {
                    return null;
                }
            };
        }
    }
}

