/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application;

import ch.systemsx.cisd.common.shared.basic.string.IgnoreCaseComparator;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PropertyTypeRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.EntityPropertyUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PropertiesPanelUtils {
    public static void addEntityProperties(IViewContext<?> viewContext, Map<String, Object> properties, List<IEntityProperty> entityProperties) {
        Collections.sort(entityProperties);
        List<PropertyType> types = EntityPropertyUtils.extractTypes(entityProperties);
        boolean isDebuggingEnabled = viewContext.getDisplaySettingsManager().isDebuggingModeEnabled();
        for (IEntityProperty property : entityProperties) {
            if (property.isManaged() && !isDebuggingEnabled) continue;
            String label = PropertyTypeRenderer.getDisplayName(property.getPropertyType(), types);
            properties.put(label, property);
        }
    }

    public static void addMetaprojects(IViewContext<?> viewContext, Map<String, Object> properties, Collection<Metaproject> metaprojects) {
        if (metaprojects != null && metaprojects.size() > 0) {
            Object[] names = new String[metaprojects.size()];
            int index = 0;
            for (Metaproject metaproject : metaprojects) {
                names[index++] = metaproject.getName();
            }
            Arrays.sort(names, new IgnoreCaseComparator());
            properties.put(viewContext.getMessage("metaprojects", new Object[0]), StringUtils.join((Object[])names, (String)", "));
        }
    }
}

