/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PropertyValueRenderers;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.PropertyGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ExternalHyperlink;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IContentCopy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.PropertiesPanelUtils;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataSetPropertiesPanel
extends ContentPanel {
    public static final String PROPERTIES_ID_PREFIX = "openbis_dataset-properties-section_";
    private final AbstractExternalData dataset;
    private final IViewContext<?> viewContext;

    public DataSetPropertiesPanel(AbstractExternalData dataset, IViewContext<?> viewContext) {
        this.setHeading("Data Set Properties");
        this.dataset = dataset;
        this.viewContext = viewContext;
        PropertyGrid propertyGrid = this.createPropertyGrid();
        this.add((Widget)propertyGrid);
    }

    private final PropertyGrid createPropertyGrid() {
        IViewContext<?> messageProvider = this.viewContext;
        Map<String, Object> properties = this.createProperties(this.viewContext);
        PropertyGrid propertyGrid = new PropertyGrid(this.viewContext, properties.size());
        propertyGrid.getElement().setId(PROPERTIES_ID_PREFIX + this.dataset.getIdentifier());
        propertyGrid.registerPropertyValueRenderer(DataSetType.class, PropertyValueRenderers.createDataSetTypePropertyValueRenderer(messageProvider));
        propertyGrid.registerPropertyValueRenderer(DataStore.class, PropertyValueRenderers.createDataStorePropertyValueRenderer(messageProvider));
        propertyGrid.setProperties(properties);
        return propertyGrid;
    }

    private final Map<String, Object> createProperties(IMessageProvider messageProvider) {
        PhysicalDataSet concreteDataSet;
        Experiment experiment;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        DataSetType datasetType = this.dataset.getDataSetType();
        Deletion deletion = this.dataset.getDeletion();
        Sample sample = this.dataset.getSample();
        properties.put(messageProvider.getMessage("data_set", new Object[0]), (Object)new ExternalHyperlink(this.dataset.getPermId(), this.dataset.getPermlink()));
        properties.put(messageProvider.getMessage("data_set_type", new Object[0]), (Object)datasetType);
        if (this.dataset.isLinkData()) {
            LinkDataSet linkDataSet = this.dataset.tryGetAsLinkDataSet();
            int counter = 1;
            for (IContentCopy copy : linkDataSet.getCopies()) {
                properties.put("Copy " + counter++, copy.getLocation());
            }
        }
        properties.put(messageProvider.getMessage("data_set_kind", new Object[0]), (Object)this.dataset.getDataSetKind());
        properties.put(messageProvider.getMessage("source_type", new Object[0]), this.dataset.getSourceType());
        properties.put(messageProvider.getMessage("data_producer_code", new Object[0]), this.dataset.getDataProducerCode());
        properties.put(messageProvider.getMessage("production_date", new Object[0]), this.dataset.getProductionDate());
        properties.put(messageProvider.getMessage("registrator", new Object[0]), this.dataset.getRegistrator());
        properties.put(messageProvider.getMessage("registration_date", new Object[0]), this.dataset.getRegistrationDate());
        List<ContainerDataSet> containerDataSets = this.dataset.getContainerDataSets();
        if (containerDataSets.size() == 1) {
            properties.put(messageProvider.getMessage("container_dataset", new Object[0]), containerDataSets.get(0));
        }
        if ((experiment = this.dataset.getExperiment()) != null) {
            properties.put(messageProvider.getMessage("project", new Object[0]), experiment.getProject());
            properties.put(messageProvider.getMessage("experiment", new Object[0]), experiment);
        }
        if ((concreteDataSet = this.dataset.tryGetAsDataSet()) != null) {
            properties.put(messageProvider.getMessage("location", new Object[0]), concreteDataSet.getFullLocation());
            if (this.viewContext.getModel().getApplicationInfo().isArchivingConfigured()) {
                properties.put(messageProvider.getMessage("archiving_status", new Object[0]), concreteDataSet.getStatus().getDescription());
                properties.put(messageProvider.getMessage("present_in_archive", new Object[0]), concreteDataSet.isPresentInArchive());
            }
            properties.put(messageProvider.getMessage("data_store", new Object[0]), (Object)concreteDataSet.getDataStore());
            properties.put(messageProvider.getMessage("is_complete", new Object[0]), concreteDataSet.getComplete());
            properties.put(messageProvider.getMessage("file_format_type", new Object[0]), concreteDataSet.getFileFormatType().getCode());
        }
        if (sample != null) {
            properties.put(messageProvider.getMessage("sample", new Object[0]), sample);
        }
        if (deletion != null) {
            properties.put(messageProvider.getMessage("deletion", new Object[0]), (Object)deletion);
        }
        PropertiesPanelUtils.addMetaprojects(this.viewContext, properties, this.dataset.getMetaprojects());
        PropertiesPanelUtils.addEntityProperties(this.viewContext, properties, this.dataset.getProperties());
        return properties;
    }
}

