/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetReportGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetReportLinkRetriever;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DatastoreServiceDescriptionModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGeneratedCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DataSetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailViewConfiguration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionProvider;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.Util;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;

public class DataViewSection
extends TabContent {
    private static String DEFAULT_SERVICE_KEY_PREFIX = "default-";
    private static String FILES_SMART_VIEW = "Files (Smart View)";
    private static String FILES_HOME_VIEW = "Files (Home)";
    private final AbstractExternalData dataset;
    private IDisposableComponent currentReportOrNull = null;

    public DataViewSection(IViewContext<?> viewContext, AbstractExternalData dataset) {
        super(viewContext.getMessage("data_view", new Object[0]), viewContext, dataset);
        this.dataset = dataset;
        this.setIds(DisplayTypeIDGenerator.DATA_SET_DATA_SECTION);
    }

    @Override
    public void disposeComponents() {
        this.disposeCurrentReport();
    }

    private void disposeCurrentReport() {
        if (this.currentReportOrNull != null) {
            this.currentReportOrNull.dispose();
        }
    }

    @Override
    protected void showContent() {
        boolean hideFileView = false;
        boolean hideSmartView = false;
        DetailViewConfiguration viewSettingsOrNull = this.viewContext.getDisplaySettingsManager().tryGetDetailViewSettings(this.getParentDisplayID());
        if (viewSettingsOrNull != null) {
            hideFileView = viewSettingsOrNull.isHideFileView();
            hideSmartView = viewSettingsOrNull.isHideSmartView();
        }
        DatastoreServiceSelectionWidget serviceSelectionWidget = new DatastoreServiceSelectionWidget(this.viewContext, this.dataset, hideFileView, hideSmartView);
        this.getHeader().addTool((Component)serviceSelectionWidget);
        serviceSelectionWidget.addSelectionChangedListener(this.createServiceSelectionChangedListener());
    }

    private SelectionChangedListener<DatastoreServiceDescriptionModel> createServiceSelectionChangedListener() {
        return new SelectionChangedListener<DatastoreServiceDescriptionModel>(){
            private Widget currentViewerOrNull;

            public void selectionChanged(SelectionChangedEvent<DatastoreServiceDescriptionModel> se) {
                DatastoreServiceDescriptionModel selectedItem = (DatastoreServiceDescriptionModel)se.getSelectedItem();
                if (selectedItem != null) {
                    DatastoreServiceDescription service = selectedItem.getBaseObject();
                    if (service.getLabel().equals(FILES_SMART_VIEW)) {
                        this.showDataSetFilesView(true, !DataViewSection.this.dataset.isAvailable());
                    } else if (service.getLabel().equals(FILES_HOME_VIEW)) {
                        this.showDataSetFilesView(false, !DataViewSection.this.dataset.isAvailable());
                    } else {
                        ReportingPluginType reportingPluginTypeOrNull = service.tryReportingPluginType();
                        if (reportingPluginTypeOrNull == ReportingPluginType.DSS_LINK) {
                            this.showGeneratedDssLink(service);
                        } else if (reportingPluginTypeOrNull == ReportingPluginType.TABLE_MODEL) {
                            this.showGeneratedReportComponentView(service);
                        }
                    }
                }
            }

            private void showGeneratedDssLink(DatastoreServiceDescription service) {
                AbstractAsyncCallback<LinkModel> action = new AbstractAsyncCallback<LinkModel>(DataViewSection.this.viewContext){

                    @Override
                    protected void process(LinkModel result) {
                        this.showDssUrl(DataSetReportLinkRetriever.convertLinkModelToUrl(result, this.viewContext.getModel()));
                    }
                };
                DataSetReportLinkRetriever.retrieveAndInvoke(DataViewSection.this.viewContext.getCommonViewContext(), service, DataViewSection.this.dataset.getCode(), (AsyncCallback<LinkModel>)action);
            }

            private void showGeneratedReportComponentView(DatastoreServiceDescription service) {
                ReportGeneratedCallback.IOnReportComponentGeneratedAction action = new ReportGeneratedCallback.IOnReportComponentGeneratedAction(){

                    @Override
                    public void execute(IDisposableComponent reportComponent) {
                        DataViewSection.this.disposeCurrentReport();
                        Component reportGrid = reportComponent.getComponent();
                        if (currentViewerOrNull != null) {
                            DataViewSection.this.remove(currentViewerOrNull);
                        }
                        DataViewSection.this.currentReportOrNull = reportComponent;
                        currentViewerOrNull = (Widget)reportGrid;
                        DataViewSection.this.add((Widget)reportGrid);
                        DataViewSection.this.layout();
                    }
                };
                DisplayedOrSelectedDatasetCriteria criteria = DisplayedOrSelectedDatasetCriteria.createSelectedItems(Arrays.asList(DataViewSection.this.dataset.getCode()));
                DataSetReportGenerator.generateAndInvoke(DataViewSection.this.viewContext.getCommonViewContext(), service, criteria, action);
            }

            private void showDataSetFilesView(boolean autoResolve, boolean disableLinks) {
                this.showDssUrl(DataSetUtils.createDataViewUrl(DataViewSection.this.dataset, DataViewSection.this.viewContext.getModel(), "simpleHtml", autoResolve, disableLinks));
            }

            private void showDssUrl(String url) {
                Frame iFrame;
                if (this.currentViewerOrNull == null) {
                    iFrame = new Frame();
                    DataViewSection.this.add((Widget)iFrame);
                } else if (this.currentViewerOrNull instanceof Frame) {
                    iFrame = (Frame)this.currentViewerOrNull;
                } else {
                    DataViewSection.this.remove(this.currentViewerOrNull);
                    iFrame = new Frame();
                    DataViewSection.this.add((Widget)iFrame);
                }
                this.currentViewerOrNull = iFrame;
                iFrame.setUrl(url);
                DataViewSection.this.layout();
            }
        };
    }

    private static class DatastoreServiceSelectionWidget
    extends DropDownList<DatastoreServiceDescriptionModel, DatastoreServiceDescription> {
        private final IViewContext<?> viewContext;
        private final AbstractExternalData dataset;
        private DatastoreServiceDescriptionModel defaultModel;
        private final boolean hideFileView;
        private final boolean hideSmartView;

        public DatastoreServiceSelectionWidget(IViewContext<?> viewContext, AbstractExternalData dataset, boolean hideFileView, boolean hideSmartView) {
            super(viewContext, "data-set_" + dataset.getCode() + "_viewer", "button_show", "label", "viewer", "viewers");
            this.viewContext = viewContext;
            this.dataset = dataset;
            this.hideFileView = hideFileView;
            this.hideSmartView = hideSmartView;
            this.addPostRefreshCallback(this.createDefaultServiceSelectionAction());
            if (!dataset.isAvailable()) {
                this.disable();
            }
        }

        private IDataRefreshCallback createDefaultServiceSelectionAction() {
            return new IDataRefreshCallback(){

                @Override
                public void postRefresh(boolean wasSuccessful) {
                    ListStore modelsStore = this.getStore();
                    for (int i = 0; i < modelsStore.getCount(); ++i) {
                        DatastoreServiceDescriptionModel serviceModel = (DatastoreServiceDescriptionModel)modelsStore.getAt(i);
                        if (!serviceModel.getBaseObject().getKey().startsWith(DEFAULT_SERVICE_KEY_PREFIX)) continue;
                        defaultModel = serviceModel;
                        break;
                    }
                    this.setSelection(Arrays.asList(defaultModel));
                    if (modelsStore.getCount() < 2) {
                        this.hide();
                    } else {
                        this.show();
                    }
                }
            };
        }

        @Override
        protected List<DatastoreServiceDescriptionModel> convertItems(List<DatastoreServiceDescription> result) {
            List<DatastoreServiceDescriptionModel> models = DatastoreServiceDescriptionModel.convert(result, this.dataset);
            if (!this.hideFileView) {
                models.add(0, DatastoreServiceDescriptionModel.createFakeReportingServiceModel(FILES_HOME_VIEW));
            }
            if (!this.hideSmartView) {
                this.defaultModel = DatastoreServiceDescriptionModel.createFakeReportingServiceModel(FILES_SMART_VIEW);
                models.add(0, this.defaultModel);
            }
            return models;
        }

        @Override
        protected void loadData(AbstractAsyncCallback<List<DatastoreServiceDescription>> callback) {
            this.viewContext.getCommonService().listDataStoreServices(DataStoreServiceKind.QUERIES, callback);
        }

        @Override
        public DatabaseModificationKind[] getRelevantModifications() {
            return new DatabaseModificationKind[0];
        }

        public void setValue(DatastoreServiceDescriptionModel value) {
            DatastoreServiceDescriptionModel oldValue = (DatastoreServiceDescriptionModel)((Object)this.getValue());
            super.setValue((ModelData)value);
            if (Util.equalWithNull((Object)((Object)oldValue), (Object)((Object)value))) {
                SelectionChangedEvent se = new SelectionChangedEvent((SelectionProvider)this, this.getSelection());
                this.fireEvent(Events.SelectionChange, (BaseEvent)se);
            }
        }
    }
}

