/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IComponentWithRefresh;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ActionMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.IActionMenuItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewerWithVerticalSplit;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetUploadConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.RevertDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.EntityHistoryGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SectionsPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityWithDeletionInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebAppContext;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.DataSetChildrenSection;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.DataSetContainedSection;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.DataSetContainerSection;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.DataSetParentsSection;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.DataSetPropertiesPanel;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.DataViewSection;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class GenericDataSetViewer
extends AbstractViewerWithVerticalSplit<AbstractExternalData>
implements IDatabaseModificationObserver,
IComponentWithRefresh {
    public static final String PREFIX = "generic-dataset-viewer_";
    public static final String ID_PREFIX = "openbis_generic-dataset-viewer_";
    private final ProcessButtonHolder processButtonHolder;
    protected final TechId datasetId;
    private boolean toolbarInitialized;
    private SectionsPanel rightPanel;

    public static DatabaseModificationAwareComponent create(final IViewContext<IGenericClientServiceAsync> localViewContext, IIdAndCodeHolder identifiable) {
        GenericDataSetViewer viewer = new GenericDataSetViewer(localViewContext, identifiable){

            @Override
            protected void loadDatasetInfo(TechId datasetTechId, AsyncCallback<AbstractExternalData> asyncCallback) {
                ((IGenericClientServiceAsync)localViewContext.getService()).getDataSetInfo(datasetTechId, asyncCallback);
            }
        };
        viewer.reloadAllData();
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    protected GenericDataSetViewer(IViewContext<?> viewContext, IIdAndCodeHolder identifiable) {
        super(viewContext, GenericDataSetViewer.createId(identifiable));
        this.setLayout((Layout)new BorderLayout());
        this.datasetId = TechId.create((IIdHolder)identifiable);
        this.processButtonHolder = new ProcessButtonHolder();
    }

    protected abstract void loadDatasetInfo(TechId var1, AsyncCallback<AbstractExternalData> var2);

    protected List<TabContent> createAdditionalSectionPanels(AbstractExternalData dataset) {
        return new ArrayList<TabContent>();
    }

    @Override
    protected void fillBreadcrumbWidgets(List<Widget> widgets) {
        Sample sample;
        Widget spaceBreadcrumb = this.createSpaceLink(((AbstractExternalData)this.originalData).getSpace());
        widgets.add(spaceBreadcrumb);
        Experiment experiment = ((AbstractExternalData)this.originalData).getExperiment();
        if (experiment != null) {
            Widget projectBreadcrumb = this.createProjectLink(experiment.getProject());
            Widget experimentBreadcrumb = this.createEntityLink(experiment);
            widgets.add(projectBreadcrumb);
            widgets.add(experimentBreadcrumb);
        }
        if ((sample = ((AbstractExternalData)this.originalData).getSample()) != null) {
            Project project = sample.getProject();
            if (project != null && experiment == null) {
                widgets.add(this.createProjectLink(project));
            }
            Widget sampleBreadcrumb = this.createEntityLink(sample);
            widgets.add(sampleBreadcrumb);
        }
        super.fillBreadcrumbWidgets(widgets);
    }

    private void extendToolBar(AbstractExternalData result) {
        if (this.toolbarInitialized) {
            return;
        }
        this.toolbarInitialized = true;
        if (!result.isLinkData()) {
            Button exportButton = new Button(this.viewContext.getMessage("button_upload_datasets", new Object[0]));
            exportButton.addListener(Events.Select, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    TableModelRowWithObject<AbstractExternalData> row = new TableModelRowWithObject<AbstractExternalData>((AbstractExternalData)GenericDataSetViewer.this.originalData, Arrays.asList(new ISerializableComparable[0]));
                    final List<TableModelRowWithObject<AbstractExternalData>> dataSets = Arrays.asList(row);
                    IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems> action = new IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems>(){

                        @Override
                        public AbstractExternalDataGrid.SelectedAndDisplayedItems execute() {
                            return new AbstractExternalDataGrid.SelectedAndDisplayedItems(dataSets, null, 1);
                        }
                    };
                    new DataSetUploadConfirmationDialog(dataSets, action, 1, GenericDataSetViewer.this.viewContext).show();
                }
            });
            this.addToolBarButton(exportButton);
        }
        if (this.getViewContext().isSimpleOrEmbeddedMode()) {
            return;
        }
        this.addToolBarButton(this.createDeleteButton(new IDelegatedAction(){

            @Override
            public void execute() {
                AbstractAsyncCallback callback = GenericDataSetViewer.this.isTrashEnabled() ? GenericDataSetViewer.this.createDeletionCallback() : GenericDataSetViewer.this.createPermanentDeletionCallback();
                TableModelRowWithObject<AbstractExternalData> row = new TableModelRowWithObject<AbstractExternalData>((AbstractExternalData)GenericDataSetViewer.this.getOriginalData(), Arrays.asList(new ISerializableComparable[0]));
                new DataSetListDeletionConfirmationDialog(GenericDataSetViewer.this.getViewContext().getCommonViewContext(), (AsyncCallback<Void>)callback, row).show();
            }
        }));
        this.addToolBarButton(this.createRevertDeletionButton(new IDelegatedAction(){

            @Override
            public void execute() {
                new RevertDeletionConfirmationDialog(GenericDataSetViewer.this.getViewContext().getCommonViewContext(), (IEntityWithDeletionInformation)GenericDataSetViewer.this.getOriginalData(), (AsyncCallback<Void>)GenericDataSetViewer.this.createRevertDeletionCallback()).show();
            }
        }));
        this.addToolBarButton(this.processButtonHolder.getButton());
    }

    public static final String createId(IIdAndCodeHolder identifiable) {
        return GenericDataSetViewer.createId(TechId.create((IIdHolder)identifiable));
    }

    public static final String createId(TechId datasetId) {
        return ID_PREFIX + datasetId;
    }

    @Override
    protected void reloadAllData() {
        this.loadDatasetInfo(this.datasetId, new DataSetInfoCallback(this.getViewContext(), this));
    }

    private final Component createLeftPanel(AbstractExternalData dataset) {
        ContentPanel panel = this.createDataSetPropertiesPanel(dataset);
        panel.setScrollMode(Style.Scroll.AUTOY);
        return panel;
    }

    private ContentPanel createDataSetPropertiesPanel(AbstractExternalData dataset) {
        return new DataSetPropertiesPanel(dataset, this.getViewContext());
    }

    private final SectionsPanel createRightPanel(AbstractExternalData dataset) {
        IViewContext<?> context = this.getViewContext();
        SectionsPanel container = new SectionsPanel(context.getCommonViewContext(), ID_PREFIX + dataset.getId());
        container.setDisplayID(DisplayTypeIDGenerator.GENERIC_DATASET_VIEWER, this.displayIdSuffix);
        List<TabContent> additionalPanels = this.createAdditionalSectionPanels(dataset);
        for (TabContent panel : additionalPanels) {
            container.addSection(panel);
        }
        container.addSection(new DataViewSection(context, dataset));
        if (dataset.isContainer()) {
            DataSetContainedSection containedSection = new DataSetContainedSection(context, dataset);
            container.addSection(containedSection);
        }
        DataSetContainerSection containerSection = new DataSetContainerSection(context, dataset);
        container.addSection(containerSection);
        DataSetParentsSection parentsSection = new DataSetParentsSection(context, dataset);
        container.addSection(parentsSection);
        DataSetChildrenSection childrenSection = new DataSetChildrenSection(context, dataset);
        container.addSection(childrenSection);
        container.addSection(EntityHistoryGrid.createPropertiesHistorySection(this.viewContext, EntityKind.DATA_SET, new TechId(dataset.getId())));
        this.attachManagedPropertiesSections(container, dataset);
        this.moduleSectionManager.initialize(container, dataset);
        this.attachWebAppsSections(container, dataset, WebAppContext.DATA_SET_DETAILS_VIEW);
        return container;
    }

    public void setupUnavailableDataSetView(PhysicalDataSet result) {
        this.setToolBarButtonsEnabled(false);
        this.updateTitle(this.getOriginalDataDescription() + " (not available)");
        String msg = this.getViewContext().getMessage("dataset_not_available_msg", result.getCode(), result.getStatus().getDescription().toLowerCase());
        MessageBox.info((String)"Data not available", (String)msg, null);
    }

    @Override
    protected void updateOriginalData(AbstractExternalData result) {
        super.updateOriginalData(result);
        this.processButtonHolder.setupData(result);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.DATA_SET), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.DATA_SET), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.EXPERIMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.EXPERIMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SAMPLE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.METAPROJECT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.METAPROJECT)};
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.reloadAllData();
    }

    @Override
    protected String getDeleteButtonLabel() {
        return this.viewContext.getMessage("button_delete_data_set", new Object[0]);
    }

    @Override
    public void refresh() {
        if (this.rightPanel != null) {
            this.rightPanel.tryApplyDisplaySettings();
        }
    }

    private static final class ProcessingDisplayCallback
    extends AbstractAsyncCallback<Void> {
        private final DatastoreServiceDescription service;

        private ProcessingDisplayCallback(IViewContext<?> viewContext, DatastoreServiceDescription service) {
            super(viewContext);
            this.service = service;
        }

        @Override
        public final void process(Void result) {
            String title = this.viewContext.getMessage("processing_info_title", new Object[0]);
            String msg = this.viewContext.getMessage("processing_info_msg", this.service.getLabel());
            MessageBox.info((String)title, (String)msg, null);
        }
    }

    private static final class ProcessingServicesCallback
    extends AbstractAsyncCallback<List<DatastoreServiceDescription>> {
        private final AbstractExternalData dataset;
        private final Button processButton;

        public ProcessingServicesCallback(IViewContext<?> viewContext, AbstractExternalData dataset, Button processButton) {
            super(viewContext);
            this.dataset = dataset;
            this.processButton = processButton;
        }

        @Override
        protected void process(List<DatastoreServiceDescription> result) {
            List<DatastoreServiceDescription> matchingServices = this.filterNotMatching(result);
            if (matchingServices.size() > 0) {
                this.processButton.setMenu(this.createPerformProcessingMenu(matchingServices));
                this.processButton.show();
            }
        }

        private List<DatastoreServiceDescription> filterNotMatching(List<DatastoreServiceDescription> services) {
            ArrayList<DatastoreServiceDescription> matchingServices = new ArrayList<DatastoreServiceDescription>();
            for (DatastoreServiceDescription service : services) {
                if (!DatastoreServiceDescription.isMatching(service, this.dataset)) continue;
                matchingServices.add(service);
            }
            return matchingServices;
        }

        private Menu createPerformProcessingMenu(List<DatastoreServiceDescription> services) {
            Menu result = new Menu();
            DisplayedOrSelectedDatasetCriteria criteria = DisplayedOrSelectedDatasetCriteria.createSelectedItems(Arrays.asList(this.dataset.getCode()));
            for (DatastoreServiceDescription service : services) {
                result.add((Component)new ActionMenu(this.createActionMenuItem(service), (IMessageProvider)this.viewContext, this.createProcessDatasetAction(service, criteria)));
            }
            return result;
        }

        private IActionMenuItem createActionMenuItem(final DatastoreServiceDescription service) {
            return new IActionMenuItem(){

                @Override
                public String getMenuId() {
                    return service.getKey();
                }

                @Override
                public String getMenuText(IMessageProvider messageProvider) {
                    return service.getLabel();
                }
            };
        }

        private IDelegatedAction createProcessDatasetAction(final DatastoreServiceDescription service, final DisplayedOrSelectedDatasetCriteria criteria) {
            return new IDelegatedAction(){

                @Override
                public void execute() {
                    viewContext.getCommonService().processDatasets(service, criteria, new ProcessingDisplayCallback(viewContext, service));
                }
            };
        }
    }

    private class ProcessButtonHolder {
        private final Button button = this.createProcessButton();

        private Button createProcessButton() {
            Button result = new Button(GenericDataSetViewer.this.getViewContext().getMessage("button_process", new Object[0]));
            result.setMenu(new Menu());
            result.hide();
            return result;
        }

        public Button getButton() {
            return this.button;
        }

        public void setupData(AbstractExternalData data) {
            GenericDataSetViewer.this.getViewContext().getCommonService().listDataStoreServices(DataStoreServiceKind.PROCESSING, new ProcessingServicesCallback(GenericDataSetViewer.this.getViewContext(), (AbstractExternalData)GenericDataSetViewer.this.getOriginalData(), this.button));
        }
    }

    private final class DataSetInfoCallback
    extends AbstractAsyncCallback<AbstractExternalData> {
        private final GenericDataSetViewer genericDataSetViewer;

        private DataSetInfoCallback(IViewContext<?> viewContext, GenericDataSetViewer genericSampleViewer) {
            super(viewContext);
            this.genericDataSetViewer = genericSampleViewer;
        }

        @Override
        protected final void process(AbstractExternalData result) {
            this.genericDataSetViewer.extendToolBar(result);
            this.genericDataSetViewer.updateOriginalData(result);
            PhysicalDataSet dataSet = result.tryGetAsDataSet();
            if (dataSet != null && !dataSet.getStatus().isAvailable()) {
                this.genericDataSetViewer.setupUnavailableDataSetView(dataSet);
            }
            this.genericDataSetViewer.removeAll();
            Component leftPanel = this.genericDataSetViewer.createLeftPanel(result);
            this.genericDataSetViewer.add((Widget)leftPanel, (LayoutData)this.genericDataSetViewer.createLeftBorderLayoutData());
            this.genericDataSetViewer.configureLeftPanel(leftPanel);
            GenericDataSetViewer.this.rightPanel = this.genericDataSetViewer.createRightPanel(result);
            this.genericDataSetViewer.add((Widget)GenericDataSetViewer.this.rightPanel, (LayoutData)GenericDataSetViewer.createRightBorderLayoutData());
            this.genericDataSetViewer.layout();
        }

        @Override
        public void finishOnFailure(Throwable caught) {
            this.genericDataSetViewer.setupRemovedEntityView();
        }
    }
}

