/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.UrlParamsHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ProjectSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.AttachmentsFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.BasicFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.AbstractGenericEntityRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.ExperimentPropertyEditor;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.ExperimentSamplesArea;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.PropertiesEditor;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractGenericExperimentRegisterEditForm
extends AbstractGenericEntityRegistrationForm<ExperimentType, ExperimentTypePropertyType> {
    protected AttachmentsFileFieldManager attachmentsManager;
    protected String attachmentsSessionKey;
    protected ProjectSelectionWidget projectChooser;
    private String initialProjectIdentifierOrNull;
    protected ExperimentSamplesArea samplesArea;
    protected final String samplesSessionKey;
    protected BasicFileFieldManager importSamplesFileManager;
    private SampleTypeSelectionWidget importSampleTypeSelection;
    protected Radio existingSamplesRadio;
    private Radio importSamplesRadio;
    protected CheckBoxField autoGenerateCodes;
    protected String simpleId;
    private LabelField templateField;

    protected AbstractGenericExperimentRegisterEditForm(IViewContext<IGenericClientServiceAsync> viewContext, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, ActionContext context) {
        this(viewContext, inputWidgetDescriptions, context, null);
    }

    protected AbstractGenericExperimentRegisterEditForm(IViewContext<IGenericClientServiceAsync> viewContext, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, ActionContext actionContext, IIdAndCodeHolder identifiable) {
        super(viewContext, inputWidgetDescriptions, identifiable, EntityKind.EXPERIMENT);
        this.simpleId = AbstractGenericExperimentRegisterEditForm.createSimpleId(identifiable, EntityKind.EXPERIMENT);
        this.attachmentsSessionKey = this.simpleId + "_attachments";
        this.samplesSessionKey = this.simpleId + "_samples";
        ArrayList<String> sesionKeys = new ArrayList<String>();
        sesionKeys.add(this.attachmentsSessionKey);
        sesionKeys.add(this.samplesSessionKey);
        this.addUploadFeatures(sesionKeys);
        this.extractInitialValues(actionContext);
    }

    private void extractInitialValues(ActionContext context) {
        this.initialProjectIdentifierOrNull = context.tryGetProjectIdentifier();
    }

    protected void updateSamples() {
        Boolean useExistingSamples = this.existingSamplesRadio.getValue();
        FieldUtil.setVisibility(useExistingSamples, new Field[]{this.samplesArea});
        FieldUtil.setVisibility(useExistingSamples == false, new Field[]{this.importSampleTypeSelection, this.autoGenerateCodes, (Field)this.importSamplesFileManager.getFields().get(0), this.templateField});
    }

    private void redefineSaveListeners() {
        this.saveButton.removeAllListeners();
        this.addSaveButtonConfirmationListener();
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractGenericExperimentRegisterEditForm.this.formPanel.isValid()) {
                    if (AbstractGenericExperimentRegisterEditForm.this.attachmentsManager.filesDefined() > 0 || AbstractGenericExperimentRegisterEditForm.this.importSamplesFileManager.filesDefined() > 0) {
                        AbstractGenericExperimentRegisterEditForm.this.setUploadEnabled(false);
                        AbstractGenericExperimentRegisterEditForm.this.formPanel.submit();
                    } else {
                        AbstractGenericExperimentRegisterEditForm.this.save();
                    }
                }
            }
        });
    }

    protected abstract void save();

    protected String extractProjectIdentifier() {
        return this.projectChooser.tryGetSelectedProject().getIdentifier();
    }

    @Override
    public final void submitValidForm() {
    }

    @Override
    protected PropertiesEditor<ExperimentType, ExperimentTypePropertyType> createPropertiesEditor(String id, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, IViewContext<ICommonClientServiceAsync> context) {
        ExperimentPropertyEditor editor = new ExperimentPropertyEditor(id, inputWidgetDescriptions, context);
        return editor;
    }

    RadioGroup createSamplesSourceRadio(Radio existing, Radio importFromFile) {
        RadioGroup result = new RadioGroup();
        result.setSelectionRequired(true);
        result.setFieldLabel(this.viewContext.getMessage("samples", new Object[0]));
        result.setOrientation(Style.Orientation.HORIZONTAL);
        result.add(existing);
        result.add(importFromFile);
        result.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                AbstractGenericExperimentRegisterEditForm.this.updateSamples();
            }
        });
        return result;
    }

    @Override
    protected List<DatabaseModificationAwareField<?>> getEntitySpecificFormFields() {
        ArrayList fields = new ArrayList();
        fields.add(this.projectChooser.asDatabaseModificationAware());
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.createSamplesSourceRadio(this.existingSamplesRadio, this.importSamplesRadio)));
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.samplesArea));
        fields.add(this.importSampleTypeSelection.asDatabaseModificationAware());
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.autoGenerateCodes));
        for (FileUploadField samplesFileField : this.importSamplesFileManager.getFields()) {
            fields.add(DatabaseModificationAwareField.wrapUnaware(samplesFileField));
        }
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.templateField));
        return fields;
    }

    @Override
    protected void addFormFieldsToPanel(FormPanel panel) {
        super.addFormFieldsToPanel(panel);
        this.attachmentsManager.addAttachmentFieldSetsToPanel(panel);
    }

    @Override
    protected void resetPanel() {
        super.resetPanel();
        this.attachmentsManager.resetAttachmentFieldSetsInPanel(this.formPanel);
    }

    @Override
    protected void revertPanel() {
        super.revertPanel();
        this.attachmentsManager.resetAttachmentFieldSetsInPanel(this.formPanel);
    }

    private static LabelField createTemplateField(String label, final String sampleTypeName, final SampleTypeSelectionWidget typeSelection, final CheckBox autoGenerate) {
        LabelField result = new LabelField(LinkRenderer.renderAsLink(label));
        result.sinkEvents(1);
        result.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                if (typeSelection.tryGetSelectedSampleType() != null) {
                    WindowUtils.openWindow(UrlParamsHelper.createTemplateURL(EntityKind.SAMPLE, (EntityType)((Object)typeSelection.tryGetSelected()), autoGenerate.getValue(), false, false, BatchOperationKind.REGISTRATION));
                } else {
                    GWTUtils.alert(sampleTypeName + " not selected.", sampleTypeName + " must be selected before downloading file template.");
                }
            }
        });
        return result;
    }

    protected String[] getSamples() {
        if (this.existingSamplesRadio.getValue().booleanValue()) {
            return this.samplesArea.tryGetModifiedSampleCodes();
        }
        return null;
    }

    protected SampleType getSampleType() {
        if (!this.existingSamplesRadio.getValue().booleanValue()) {
            return this.importSampleTypeSelection.tryGetSelectedSampleType();
        }
        return null;
    }

    @Override
    protected void createEntitySpecificFormFields() {
        this.projectChooser = new ProjectSelectionWidget(this.viewContext, this.simpleId, this.initialProjectIdentifierOrNull);
        this.projectChooser.setFieldLabel(this.viewContext.getMessage("project", new Object[0]));
        FieldUtil.markAsMandatory(this.projectChooser);
        this.samplesArea = new ExperimentSamplesArea(this.viewContext, this.simpleId);
        this.importSamplesFileManager = new BasicFileFieldManager(this.samplesSessionKey, 1, "File");
        this.importSamplesFileManager.setMandatory();
        this.importSampleTypeSelection = new SampleTypeSelectionWidget(this.viewContext, this.simpleId, false, false, true, null, SampleTypeDisplayID.EXPERIMENT_REGISTRATION);
        FieldUtil.markAsMandatory(this.importSampleTypeSelection);
        this.existingSamplesRadio = this.cerateExistingSamplesRadio();
        this.importSamplesRadio = AbstractGenericExperimentRegisterEditForm.createImportRadio();
        this.autoGenerateCodes = AbstractGenericExperimentRegisterEditForm.createAutoGenerateCheckbox();
        this.templateField = AbstractGenericExperimentRegisterEditForm.createTemplateField(this.viewContext.getMessage("file_template_label", new Object[0]), this.viewContext.getMessage("sample_type", new Object[0]), this.importSampleTypeSelection, this.autoGenerateCodes);
        this.attachmentsManager = new AttachmentsFileFieldManager(this.attachmentsSessionKey, this.viewContext);
        this.formPanel.addListener(Events.Submit, new FormPanelListener(this.infoBox){

            @Override
            protected void onSuccessfullUpload() {
                AbstractGenericExperimentRegisterEditForm.this.save();
            }

            @Override
            protected void setUploadEnabled() {
                AbstractGenericExperimentRegisterEditForm.this.setUploadEnabled(true);
            }
        });
        this.redefineSaveListeners();
    }

    protected static Radio createImportRadio() {
        Radio importRadio = new Radio();
        importRadio.setBoxLabel("register from a file and attach");
        return importRadio;
    }

    protected static CheckBoxField createAutoGenerateCheckbox() {
        return new CheckBoxField("Generate codes automatically", false);
    }

    private Radio cerateExistingSamplesRadio() {
        Radio existingRadio = new Radio();
        existingRadio.setBoxLabel("specify the list of existing " + this.viewContext.getMessage("samples", new Object[0]).toLowerCase());
        existingRadio.setValue(Boolean.valueOf(true));
        return existingRadio;
    }
}

