/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractDatabaseModificationObserverWithCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserverWithCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PropertyValueRenderers;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.PropertyGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ExternalHyperlink;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.PropertiesPanelUtils;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentViewer;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ExperimentPropertiesPanel
extends ContentPanel {
    public static final String PROPERTIES_ID_PREFIX = "openbis_experiment-properties-section_";
    private final TechId experimentId;
    private final PropertyGrid grid;
    private final IViewContext<IGenericClientServiceAsync> viewContext;
    private final GenericExperimentViewer viewer;

    public ExperimentPropertiesPanel(Experiment experiment, IViewContext<IGenericClientServiceAsync> viewContext, GenericExperimentViewer viewer) {
        super((Layout)new BorderLayout());
        this.setHeading(viewContext.getMessage("experiment", new Object[0]) + " Properties");
        this.experimentId = new TechId((IIdAndCodeHolder)experiment);
        this.viewContext = viewContext;
        this.viewer = viewer;
        this.grid = this.createPropertyGrid(experiment);
        ContentPanel pp = new ContentPanel();
        pp.setHeaderVisible(false);
        pp.setScrollMode(Style.Scroll.AUTOY);
        pp.add((Widget)this.grid);
        this.add((Widget)pp, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
    }

    public void addSouthComponent(Component component) {
        this.add((Widget)component, (LayoutData)new BorderLayoutData(Style.LayoutRegion.SOUTH));
        this.layout();
    }

    private PropertyGrid createPropertyGrid(Experiment experiment) {
        return this.createPropertyGrid(ExperimentPropertiesPanel.createProperties(experiment, this.viewContext));
    }

    private final PropertyGrid createPropertyGrid(Map<String, Object> properties) {
        IViewContext<IGenericClientServiceAsync> messageProvider = this.viewContext;
        PropertyGrid propertyGrid = new PropertyGrid(this.viewContext, properties.size());
        propertyGrid.getElement().setId(PROPERTIES_ID_PREFIX + this.experimentId);
        propertyGrid.registerPropertyValueRenderer(ExperimentType.class, PropertyValueRenderers.createExperimentTypePropertyValueRenderer(messageProvider));
        propertyGrid.setProperties(properties);
        return propertyGrid;
    }

    private static Map<String, Object> createProperties(Experiment experiment, IViewContext<?> viewContext) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        ExperimentType experimentType = experiment.getExperimentType();
        Deletion deletion = experiment.getDeletion();
        properties.put(viewContext.getMessage("experiment", new Object[0]), experiment.getIdentifier());
        properties.put(viewContext.getMessage("perm_id", new Object[0]), (Object)new ExternalHyperlink(experiment.getPermId(), experiment.getPermlink()));
        properties.put(viewContext.getMessage("experiment_type", new Object[0]), (Object)experimentType);
        properties.put(viewContext.getMessage("registrator", new Object[0]), experiment.getRegistrator());
        properties.put(viewContext.getMessage("registration_date", new Object[0]), experiment.getRegistrationDate());
        if (deletion != null) {
            properties.put(viewContext.getMessage("deletion", new Object[0]), (Object)deletion);
        }
        properties.put(viewContext.getMessage("project", new Object[0]), experiment.getProject());
        PropertiesPanelUtils.addMetaprojects(viewContext, properties, experiment.getMetaprojects());
        PropertiesPanelUtils.addEntityProperties(viewContext, properties, experiment.getProperties());
        return properties;
    }

    private final void updateProperties(Experiment experiment) {
        Map<String, Object> properties = ExperimentPropertiesPanel.createProperties(experiment, this.viewContext);
        this.grid.resizeRows(properties.size());
        this.grid.setProperties(properties);
    }

    private void reloadData(AbstractAsyncCallback<Experiment> callback) {
        this.viewContext.getCommonService().getExperimentInfo(this.experimentId, callback);
    }

    public IDatabaseModificationObserverWithCallback getDatabaseModificationObserver() {
        return new PropertyGridDatabaseModificationObserver();
    }

    private class PropertyGridDatabaseModificationObserver
    extends AbstractDatabaseModificationObserverWithCallback {
        private PropertyGridDatabaseModificationObserver() {
        }

        @Override
        public DatabaseModificationKind[] getRelevantModifications() {
            return new DatabaseModificationKind[]{DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.EXPERIMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.EXPERIMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.METAPROJECT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.METAPROJECT)};
        }

        @Override
        public void update(Set<DatabaseModificationKind> observedModifications) {
            ExperimentPropertiesPanel.this.reloadData(new ExperimentInfoCallback(ExperimentPropertiesPanel.this.viewContext, ExperimentPropertiesPanel.this));
        }

        private final class ExperimentInfoCallback
        extends AbstractAsyncCallback<Experiment> {
            private final ExperimentPropertiesPanel section;

            private ExperimentInfoCallback(IViewContext<?> viewContext, ExperimentPropertiesPanel section) {
                super(viewContext);
                this.section = section;
            }

            @Override
            protected final void process(Experiment result) {
                ExperimentPropertiesPanel.this.viewer.updateOriginalData(result);
                this.section.updateProperties(result);
                PropertyGridDatabaseModificationObserver.this.executeSuccessfulUpdateCallback();
            }

            @Override
            public void finishOnFailure(Throwable caught) {
                ExperimentPropertiesPanel.this.viewer.setupRemovedEntityView();
            }
        }
    }
}

