/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.EntityLinkMessageElement;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.HtmlMessageElement;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IMessageElement;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.AbstractGenericExperimentRegisterEditForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.ExperimentPropertyEditor;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.PropertiesEditor;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GenericExperimentRegistrationForm
extends AbstractGenericExperimentRegisterEditForm {
    private final ExperimentType experimentType;

    public GenericExperimentRegistrationForm(IViewContext<IGenericClientServiceAsync> viewContext, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, ActionContext context, ExperimentType experimentType) {
        super(viewContext, inputWidgetDescriptions, context);
        this.setResetButtonVisible(true);
        this.experimentType = experimentType;
    }

    @Override
    protected void resetFieldsAfterSave() {
        this.codeField.reset();
        this.attachmentsManager.resetAttachmentFieldSetsInPanel(this.formPanel);
        for (FileUploadField importSamplesField : this.importSamplesFileManager.getFields()) {
            importSamplesField.reset();
        }
        this.samplesArea.reset();
        this.updateDirtyCheckAfterSave();
    }

    private final String createExperimentIdentifier() {
        Project project = this.projectChooser.tryGetSelectedProject();
        String code = (String)this.codeField.getValue();
        String result = project.getIdentifier() + "/" + code;
        return result.toUpperCase();
    }

    @Override
    protected void save() {
        NewExperiment newExp = new NewExperiment(this.createExperimentIdentifier(), this.experimentType.getCode());
        List<IEntityProperty> properties = this.extractProperties();
        newExp.setProperties(properties.toArray(IEntityProperty.EMPTY_ARRAY));
        newExp.setSamples(this.getSamples());
        newExp.setSampleType(this.getSampleType());
        newExp.setGenerateCodes(this.autoGenerateCodes.getValue());
        newExp.setRegisterSamples(this.existingSamplesRadio.getValue() == false);
        newExp.setAttachments(this.attachmentsManager.extractAttachments());
        newExp.setMetaprojectsOrNull(this.metaprojectArea.tryGetModifiedMetaprojects());
        ((IGenericClientServiceAsync)this.viewContext.getService()).registerExperiment(this.attachmentsSessionKey, this.samplesSessionKey, newExp, new RegisterExperimentCallback(this.viewContext));
    }

    @Override
    protected PropertiesEditor<ExperimentType, ExperimentTypePropertyType> createPropertiesEditor(String id, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, IViewContext<ICommonClientServiceAsync> context) {
        ExperimentPropertyEditor editor = new ExperimentPropertyEditor(id, inputWidgetDescriptions, context);
        return editor;
    }

    @Override
    protected void initializeFormFields() {
        this.propertiesEditor.initWithoutProperties(this.experimentType.getAssignedPropertyTypes());
        this.updateSamples();
    }

    @Override
    protected void loadForm() {
        this.initGUI();
    }

    private final class RegisterExperimentCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Experiment> {
        RegisterExperimentCallback(IViewContext<?> viewContext) {
            super(GenericExperimentRegistrationForm.this, viewContext);
        }

        @Override
        protected List<IMessageElement> createSuccessfullRegistrationInfo(Experiment experiment) {
            ArrayList<IMessageElement> message = new ArrayList<IMessageElement>();
            message.add(new HtmlMessageElement(this.viewContext.getMessage("experiment", new Object[0])));
            message.add(new EntityLinkMessageElement(this.viewContext, GenericExperimentRegistrationForm.this.createExperimentIdentifier(), EntityKind.EXPERIMENT, experiment.getPermId()));
            message.add(new HtmlMessageElement("successfully registered"));
            return message;
        }
    }
}

