/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PropertyTypeRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.PropertyFieldFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.ManagedPropertyField;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PropertiesEditor<T extends EntityType, S extends EntityTypePropertyType<T>> {
    private static final String ETPT = "PROPERTY_TYPE";
    private List<DatabaseModificationAwareField<?>> propertyFields;
    private final String id;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions;

    protected IEntityProperty createEntityProperty() {
        return new EntityProperty();
    }

    protected PropertiesEditor(String id, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, IViewContext<ICommonClientServiceAsync> viewContext) {
        this.id = id;
        this.inputWidgetDescriptions = inputWidgetDescriptions;
        this.viewContext = viewContext;
    }

    public void initWithProperties(List<S> entityTypesPropertyTypes, List<IEntityProperty> properties) {
        assert (properties != null) : "Undefined properties.";
        assert (this.propertyFields == null) : "Already initialized.";
        List<S> shownEtpts = this.getEtptsShownInEditView(entityTypesPropertyTypes, true);
        this.propertyFields = this.createPropertyFields(shownEtpts, this.createInitialProperties(properties));
    }

    public void initWithoutProperties(List<S> entityTypesPropertyTypes) {
        assert (this.propertyFields == null) : "Already initialized.";
        List<S> shownEtpts = this.getEtptsShownInEditView(entityTypesPropertyTypes, false);
        this.propertyFields = this.createPropertyFields(shownEtpts, this.createInitialProperties(new ArrayList<IEntityProperty>()));
    }

    private List<DatabaseModificationAwareField<?>> createPropertyFields(List<S> entityTypesPropertyTypes, Map<String, String> initialProperties) {
        ArrayList result = new ArrayList();
        List<PropertyType> propertyTypes = this.getPropertyTypes(entityTypesPropertyTypes);
        for (EntityTypePropertyType stpt : entityTypesPropertyTypes) {
            String value = initialProperties.get(stpt.getPropertyType().getCode());
            result.add(this.createPropertyField(stpt, value, propertyTypes));
        }
        return result;
    }

    private List<PropertyType> getPropertyTypes(List<S> entityTypesPropertyTypes) {
        ArrayList<PropertyType> propertyTypes = new ArrayList<PropertyType>();
        for (EntityTypePropertyType stpt : entityTypesPropertyTypes) {
            propertyTypes.add(stpt.getPropertyType());
        }
        return propertyTypes;
    }

    private Map<String, String> createInitialProperties(List<IEntityProperty> properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (IEntityProperty p : properties) {
            result.put(p.getPropertyType().getCode(), StringEscapeUtils.unescapeHtml(p.tryGetOriginalValue()));
        }
        return result;
    }

    private final DatabaseModificationAwareField<?> createPropertyField(S etpt, String value, List<PropertyType> propertyTypes) {
        DatabaseModificationAwareField<?> field;
        assert (this.viewContext != null);
        boolean isMandatory = ((EntityTypePropertyType)etpt).isMandatory();
        PropertyType propertyType = ((EntityTypePropertyType)etpt).getPropertyType();
        String label = PropertyTypeRenderer.getDisplayName(propertyType, propertyTypes);
        String propertyTypeCode = propertyType.getCode();
        if (this.hasInputWidgets(etpt)) {
            List<IManagedInputWidgetDescription> widgetDescriptions = this.inputWidgetDescriptions.get(propertyTypeCode);
            field = this.createManagedPropertySection(label, isMandatory, widgetDescriptions);
        } else {
            field = PropertyFieldFactory.createField(propertyType, isMandatory, label, PropertiesEditor.createFormFieldId(this.getId(), propertyTypeCode), value, this.viewContext);
        }
        ((Field)field.get()).setData(ETPT, etpt);
        GWTUtils.setToolTip((Component)field.get(), propertyTypeCode);
        return field;
    }

    private boolean hasInputWidgets(S etpt) {
        PropertyType propertyType = ((EntityTypePropertyType)etpt).getPropertyType();
        List<IManagedInputWidgetDescription> widgetDescriptions = this.inputWidgetDescriptions.get(propertyType.getCode());
        return widgetDescriptions != null && !widgetDescriptions.isEmpty();
    }

    private DatabaseModificationAwareField<?> createManagedPropertySection(String label, boolean isMandatory, List<IManagedInputWidgetDescription> widgetDescriptions) {
        return DatabaseModificationAwareField.wrapUnaware(new ManagedPropertyField(this.viewContext, label, isMandatory, widgetDescriptions));
    }

    private String getId() {
        return this.id;
    }

    private static final String createFormFieldId(String idPrefix, String propertyTypeCode) {
        return idPrefix + GWTUtils.escapeToFormId(propertyTypeCode);
    }

    public final List<IEntityProperty> extractProperties() {
        assert (this.propertyFields != null) : "Not initialized.";
        ArrayList<IEntityProperty> properties = new ArrayList<IEntityProperty>();
        for (DatabaseModificationAwareField<?> field : this.propertyFields) {
            Object value = ((Field)field.get()).getValue();
            EntityTypePropertyType etpt = (EntityTypePropertyType)((Field)field.get()).getData(ETPT);
            if (etpt == null) continue;
            IEntityProperty entityProperty = this.createEntityProperty();
            PropertyType propertyType = etpt.getPropertyType();
            String valueAsString = PropertyFieldFactory.valueToString(value);
            if (this.inputWidgetDescriptions.get(propertyType.getCode()) != null) {
                JSONArray jsonArray = new JSONArray();
                List rows = (List)value;
                for (int i = 0; i < rows.size(); ++i) {
                    Map row = (Map)rows.get(i);
                    JSONObject jsonObject = new JSONObject();
                    for (Map.Entry entry : row.entrySet()) {
                        jsonObject.put((String)entry.getKey(), (JSONValue)new JSONString((String)entry.getValue()));
                    }
                    jsonArray.set(i, (JSONValue)jsonObject);
                }
                valueAsString = "__JSON__:" + jsonArray.toString();
            }
            entityProperty.setValue(valueAsString);
            entityProperty.setPropertyType(propertyType);
            properties.add(entityProperty);
        }
        return properties;
    }

    public final List<DatabaseModificationAwareField<?>> getPropertyFields() {
        assert (this.propertyFields != null) : "Not initialized.";
        return this.propertyFields;
    }

    public void addPropertyFieldsWithFieldsetToPanel(FormPanel form) {
        String previousSection = null;
        FieldSet currentSectionFieldSet = null;
        for (DatabaseModificationAwareField<?> field : this.propertyFields) {
            EntityTypePropertyType etpt = (EntityTypePropertyType)((Field)field.get()).getData(ETPT);
            String currentSection = etpt.getSection();
            if (previousSection != null && !previousSection.equals(currentSection)) {
                form.add(currentSectionFieldSet);
            }
            if (currentSection != null) {
                if (!currentSection.equals(previousSection)) {
                    currentSectionFieldSet = this.createSectionFieldSet(currentSection);
                }
            } else {
                currentSectionFieldSet = null;
            }
            if (currentSectionFieldSet != null) {
                currentSectionFieldSet.add((Widget)field.get());
            } else if (field.get() instanceof ManagedPropertyField) {
                PropertyType propertyType = etpt.getPropertyType();
                String label = propertyType.getLabel();
                if (etpt.isMandatory()) {
                    label = label + " *";
                }
                FieldSet fieldSet = this.createSectionFieldSet(label);
                ManagedPropertyField managedPropertyField = (ManagedPropertyField)((Object)field.get());
                fieldSet.add(managedPropertyField.getWidget());
                form.add((Widget)managedPropertyField);
                form.add((Widget)fieldSet);
            } else {
                form.add((Widget)field.get());
            }
            previousSection = currentSection;
        }
        if (currentSectionFieldSet != null) {
            form.add(currentSectionFieldSet);
        }
    }

    private FieldSet createSectionFieldSet(String sectionName) {
        return new PropertiesSectionFieldSet(sectionName);
    }

    private List<S> getEtptsShownInEditView(List<S> allEntityTypesPropertyTypes, boolean editForm) {
        ArrayList<EntityTypePropertyType> result = new ArrayList<EntityTypePropertyType>();
        for (EntityTypePropertyType etpt : allEntityTypesPropertyTypes) {
            if (!this.shownInForm(etpt, editForm)) continue;
            result.add(etpt);
        }
        return result;
    }

    private boolean shownInForm(S etpt, boolean editForm) {
        if (!((EntityTypePropertyType)etpt).isShownInEditView()) {
            return false;
        }
        if (!((EntityTypePropertyType)etpt).isManaged()) {
            return true;
        }
        boolean showRawValue = ((EntityTypePropertyType)etpt).getShowRawValue();
        if (editForm) {
            return showRawValue;
        }
        return showRawValue || this.hasInputWidgets(etpt);
    }

    private static final class PropertiesSectionFieldSet
    extends FieldSet {
        public PropertiesSectionFieldSet(String sectionName) {
            this.createForm(sectionName);
        }

        private void createForm(String sectionName) {
            this.setHeading(sectionName);
            this.setLayout((Layout)this.createFormLayout());
            this.setWidth(689);
        }

        private final FormLayout createFormLayout() {
            FormLayout formLayout = new FormLayout();
            formLayout.setLabelWidth(109);
            formLayout.setDefaultWidth(500);
            return formLayout;
        }
    }
}

