/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.material;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractDatabaseModificationObserverWithCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserverWithMainObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewerWithVerticalSplit;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PropertyValueRenderers;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.EntityHistoryGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.PropertyGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SectionsPanel;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebAppContext;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.PropertiesPanelUtils;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GenericMaterialViewer
extends AbstractViewerWithVerticalSplit<Material>
implements IDatabaseModificationObserver {
    public static final String PROPERTIES_ID_PREFIX = "openbis_material-properties-section_";
    private static final String GENERIC_MATERIAL_VIEWER = "generic-material-viewer";
    private static final String PREFIX = "generic-material-viewer_";
    public static final String ID_PREFIX = "openbis_generic-material-viewer_";
    private PropertyGrid propertyGrid;
    protected final TechId materialId;

    public static DatabaseModificationAwareComponent create(IViewContext<IGenericClientServiceAsync> viewContext, TechId materialId) {
        GenericMaterialViewer viewer = new GenericMaterialViewer((IViewContext)viewContext, materialId){

            @Override
            protected void loadMaterialInfo(TechId materialTechId, AsyncCallback<Material> material) {
                this.viewContext.getCommonService().getMaterialInfo(materialTechId, material);
            }
        };
        viewer.reloadAllData();
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    protected abstract void loadMaterialInfo(TechId var1, AsyncCallback<Material> var2);

    protected GenericMaterialViewer(IViewContext<?> viewContext, TechId materialId) {
        super(viewContext, GenericMaterialViewer.createId(materialId));
        this.materialId = materialId;
        this.setLayout((Layout)new BorderLayout());
    }

    public static String createId(TechId materialId) {
        return ID_PREFIX + materialId;
    }

    @Override
    public void updateOriginalData(Material newData) {
        super.updateOriginalData(newData);
    }

    private final Component createRightPanel(Material material) {
        SectionsPanel container = new SectionsPanel(this.viewContext.getCommonViewContext(), ID_PREFIX + material.getId());
        container.setDisplayID(DisplayTypeIDGenerator.GENERIC_MATERIAL_VIEWER, this.displayIdSuffix);
        container.addSection(EntityHistoryGrid.createPropertiesHistorySection(this.viewContext, EntityKind.MATERIAL, new TechId(material.getId())));
        List<TabContent> additionalPanels = this.createAdditionalSectionPanels(material);
        for (TabContent panel : additionalPanels) {
            container.addSection(panel);
        }
        container.layout();
        this.attachManagedPropertiesSections(container, material);
        this.moduleSectionManager.initialize(container, material);
        this.attachWebAppsSections(container, material, WebAppContext.MATERIAL_DETAILS_VIEW);
        return container;
    }

    @Override
    protected void reloadAllData() {
        this.reloadMaterialData(new MaterialInfoCallback(this.viewContext, this));
    }

    protected void reloadMaterialData(AbstractAsyncCallback<Material> material) {
        this.loadMaterialInfo(this.materialId, material);
    }

    protected List<TabContent> createAdditionalSectionPanels(Material material) {
        return new ArrayList<TabContent>();
    }

    private final Component createLeftPanel(Material material) {
        ContentPanel panel = new ContentPanel();
        panel.setScrollMode(Style.Scroll.AUTOY);
        panel.setHeading(this.viewContext.getMessage("material_properties_heading", new Object[0]));
        this.propertyGrid = GenericMaterialViewer.createPropertyGrid(material, this.viewContext);
        panel.add((Widget)this.propertyGrid);
        return panel;
    }

    public PropertyGrid createPropertyGrid(Material material) {
        return GenericMaterialViewer.createPropertyGrid(material, this.viewContext);
    }

    private static final PropertyGrid createPropertyGrid(Material material, IViewContext<?> viewContext) {
        Map<String, Object> properties = GenericMaterialViewer.createProperties(viewContext, material);
        PropertyGrid propertyGrid = new PropertyGrid(viewContext, properties.size());
        propertyGrid.registerPropertyValueRenderer(MaterialType.class, PropertyValueRenderers.createMaterialTypePropertyValueRenderer(viewContext));
        propertyGrid.setProperties(properties);
        propertyGrid.getElement().setId(PROPERTIES_ID_PREFIX + material.getIdentifier());
        return propertyGrid;
    }

    private static final Map<String, Object> createProperties(IViewContext<?> viewContext, Material material) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        MaterialType materialType = material.getMaterialType();
        properties.put(viewContext.getMessage("material", new Object[0]), material.getCode());
        properties.put(viewContext.getMessage("material_type", new Object[0]), (Object)materialType);
        properties.put(viewContext.getMessage("registrator", new Object[0]), material.getRegistrator());
        properties.put(viewContext.getMessage("registration_date", new Object[0]), material.getRegistrationDate());
        PropertiesPanelUtils.addMetaprojects(viewContext, properties, material.getMetaprojects());
        PropertiesPanelUtils.addEntityProperties(viewContext, properties, material.getProperties());
        return properties;
    }

    public final void updateProperties(Material material) {
        Map<String, Object> properties = GenericMaterialViewer.createProperties(this.viewContext, material);
        this.propertyGrid.resizeRows(properties.size());
        this.propertyGrid.setProperties(properties);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.createDatabaseModificationObserver().getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.createDatabaseModificationObserver().update(observedModifications);
    }

    private IDatabaseModificationObserver createDatabaseModificationObserver() {
        return new CompositeDatabaseModificationObserverWithMainObserver(new PropertyGridDatabaseModificationObserver());
    }

    @Override
    protected String getDeleteButtonLabel() {
        return this.viewContext.getMessage("button_delete_material", new Object[0]);
    }

    private class PropertyGridDatabaseModificationObserver
    extends AbstractDatabaseModificationObserverWithCallback {
        private PropertyGridDatabaseModificationObserver() {
        }

        @Override
        public DatabaseModificationKind[] getRelevantModifications() {
            return new DatabaseModificationKind[]{DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.MATERIAL), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.METAPROJECT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.METAPROJECT)};
        }

        @Override
        public void update(Set<DatabaseModificationKind> observedModifications) {
            GenericMaterialViewer.this.reloadMaterialData(new ReloadPropertyGridCallback(GenericMaterialViewer.this.viewContext, GenericMaterialViewer.this));
        }

        private final class ReloadPropertyGridCallback
        extends AbstractAsyncCallback<Material> {
            private final GenericMaterialViewer viewer;

            private ReloadPropertyGridCallback(IViewContext<?> viewContext, GenericMaterialViewer viewer) {
                super(viewContext);
                this.viewer = viewer;
            }

            @Override
            protected final void process(Material result) {
                this.viewer.updateOriginalData(result);
                this.viewer.updateProperties(result);
                PropertyGridDatabaseModificationObserver.this.executeSuccessfulUpdateCallback();
            }

            @Override
            public void finishOnFailure(Throwable caught) {
                this.viewer.setupRemovedEntityView();
            }
        }
    }

    private static final class MaterialInfoCallback
    extends AbstractAsyncCallback<Material> {
        private final GenericMaterialViewer viewer;

        private MaterialInfoCallback(IViewContext<?> viewContext, GenericMaterialViewer viewer) {
            super(viewContext);
            this.viewer = viewer;
        }

        @Override
        protected final void process(Material result) {
            this.viewer.updateOriginalData(result);
            this.viewer.removeAll();
            Component leftPanel = this.viewer.createLeftPanel(result);
            this.viewer.add((Widget)leftPanel, (LayoutData)this.viewer.createLeftBorderLayoutData());
            this.viewer.configureLeftPanel(leftPanel);
            Component rightPanel = this.viewer.createRightPanel(result);
            this.viewer.add((Widget)rightPanel, (LayoutData)GenericMaterialViewer.createRightBorderLayoutData());
            this.viewer.layout();
        }
    }
}

