/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.UrlParamsHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractBatchRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.AbstractSampleBatchRegistrationForm;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.google.gwt.user.client.ui.Widget;

public final class GenericSampleBatchRegistrationForm
extends AbstractSampleBatchRegistrationForm {
    private static final String SESSION_KEY = "sample-batch-registration";
    private final CheckBoxField generateCodesCheckbox;
    private final CheckBoxField updateExistingCheckbox;
    private final SpaceSelectionWidget groupSelector;

    public GenericSampleBatchRegistrationForm(IViewContext<IGenericClientServiceAsync> viewContext, SampleType sampleType) {
        super(viewContext, sampleType, SESSION_KEY);
        this.setResetButtonVisible(true);
        this.generateCodesCheckbox = new CheckBoxField(viewContext.getMessage("auto_generate_codes_label", new Object[0]), false);
        this.updateExistingCheckbox = new CheckBoxField(viewContext.getMessage("update_existing_entities_label", new Object[0]), false);
        this.groupSelector = this.createGroupField(viewContext.getCommonViewContext(), "" + this.getId(), true, this.generateCodesCheckbox);
        this.generateCodesCheckbox.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                boolean selected = (Boolean)be.getValue();
                FieldUtil.setVisibility(selected, new Field[]{GenericSampleBatchRegistrationForm.this.groupSelector});
                if (selected) {
                    GenericSampleBatchRegistrationForm.this.updateExistingCheckbox.setValue(false);
                }
            }
        });
        this.updateExistingCheckbox.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                boolean selected = (Boolean)be.getValue();
                if (selected) {
                    GenericSampleBatchRegistrationForm.this.generateCodesCheckbox.setValue(false);
                }
            }
        });
    }

    private final SpaceSelectionWidget createGroupField(IViewContext<ICommonClientServiceAsync> context, String idSuffix, boolean addShared, final CheckBoxField checkbox) {
        SpaceSelectionWidget field = new SpaceSelectionWidget(context, idSuffix, addShared, false){

            protected boolean validateValue(String val) {
                if (checkbox.getValue().booleanValue() && this.tryGetSelectedSpace() == null) {
                    this.forceInvalid(GXT.MESSAGES.textField_blankText());
                    return false;
                }
                this.clearInvalid();
                return true;
            }
        };
        FieldUtil.markAsMandatory(field);
        field.setFieldLabel(this.genericViewContext.getMessage("default_group", new Object[0]));
        field.setVisible(false);
        return field;
    }

    @Override
    protected String createTemplateUrl() {
        return UrlParamsHelper.createTemplateURL(EntityKind.SAMPLE, this.sampleType, this.generateCodesCheckbox.getValue(), true, BatchOperationKind.REGISTRATION);
    }

    @Override
    protected void addSpecificFormFields(FormPanel form) {
        form.add((Widget)this.generateCodesCheckbox);
        form.add((Widget)this.groupSelector);
        form.add((Widget)this.updateExistingCheckbox);
    }

    @Override
    protected void resetPanel() {
        super.resetPanel();
        this.groupSelector.setVisible(false);
        this.groupSelector.setEnabled(false);
    }

    @Override
    protected void save() {
        String defaultGroupIdentifier = null;
        Space selectedGroup = this.groupSelector.tryGetSelectedSpace();
        if (this.generateCodesCheckbox.getValue().booleanValue() && selectedGroup != null) {
            defaultGroupIdentifier = selectedGroup.getIdentifier();
        }
        boolean updateExisting = this.updateExistingCheckbox.getValue();
        ((IGenericClientServiceAsync)this.genericViewContext.getService()).registerSamples(this.sampleType, SESSION_KEY, this.isAsync(), (String)this.emailField.getValue(), defaultGroupIdentifier, updateExisting, new AbstractBatchRegistrationForm.BatchRegistrationCallback(this, this.genericViewContext));
    }
}

