/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ProjectSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.EntityLinkMessageElement;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.HtmlMessageElement;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IMessageElement;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SampleRegistrationLinkMessageElement;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.AbstractGenericSampleRegisterEditForm;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GenericSampleRegistrationForm
extends AbstractGenericSampleRegisterEditForm {
    public GenericSampleRegistrationForm(IViewContext<IGenericClientServiceAsync> viewContext, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, SampleType sampleType, ActionContext actionContext) {
        super(viewContext, inputWidgetDescriptions, actionContext);
        this.setResetButtonVisible(true);
        this.sampleType = sampleType;
    }

    @Override
    protected void resetFieldsAfterSave() {
        this.codeField.reset();
        this.attachmentsManager.resetAttachmentFieldSetsInPanel(this.formPanel);
        this.updateDirtyCheckAfterSave();
    }

    @Override
    protected void initializeFormFields() {
        this.propertiesEditor.initWithoutProperties(this.sampleType.getAssignedPropertyTypes());
    }

    @Override
    protected void loadForm() {
        this.initGUI();
    }

    @Override
    protected void save() {
        Project project;
        String experimentIdentifier = this.experimentField != null && this.experimentField.tryToGetValue() != null ? this.experimentField.tryToGetValue().getIdentifier() : null;
        String projectIdentifier = null;
        if (this.projectChooser != null && this.projectChooser.getValue() != null && (project = (Project)((ProjectSelectionWidget.ProjectComboModel)((Object)this.projectChooser.getValue())).get("object")) != null) {
            projectIdentifier = project.getIdentifier();
        }
        String containerOrNull = StringUtils.trimToNull((String)this.container.getValue());
        NewSample newSample = NewSample.createWithParents(this.createSampleIdentifier(), this.sampleType, containerOrNull, this.getParents());
        List<IEntityProperty> properties = this.extractProperties();
        newSample.setProperties(properties.toArray(IEntityProperty.EMPTY_ARRAY));
        newSample.setAttachments(this.attachmentsManager.extractAttachments());
        newSample.setExperimentIdentifier(experimentIdentifier);
        newSample.setProjectIdentifier(projectIdentifier);
        newSample.setMetaprojectsOrNull(this.metaprojectArea.tryGetModifiedMetaprojects());
        ((IGenericClientServiceAsync)this.viewContext.getService()).registerSample(this.attachmentsSessionKey, newSample, this.enrichWithPostRegistration(new RegisterSampleCallback(this.viewContext)));
    }

    @Override
    protected boolean isAutoGenerateCode() {
        return this.sampleType.isAutoGeneratedCode();
    }

    public final class RegisterSampleCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Sample> {
        public RegisterSampleCallback(IViewContext<?> viewContext) {
            super(GenericSampleRegistrationForm.this, viewContext);
        }

        @Override
        protected List<? extends IMessageElement> createSuccessfullRegistrationInfo(Sample sample) {
            Space selectedGroup = GenericSampleRegistrationForm.this.groupSelectionWidget.tryGetSelectedSpace();
            String code = sample.getCode();
            boolean shared = SpaceSelectionWidget.isSharedSpace(selectedGroup);
            ArrayList<IMessageElement> result = new ArrayList<IMessageElement>();
            if (shared) {
                result.add(new HtmlMessageElement("Shared " + this.viewContext.getMessage("sample", new Object[0]).toLowerCase()));
                result.add(new EntityLinkMessageElement(this.viewContext, code, EntityKind.SAMPLE, sample.getPermId()));
                result.add(new HtmlMessageElement("successfully registered."));
            } else {
                result.add(new HtmlMessageElement(this.viewContext.getMessage("sample", new Object[0])));
                result.add(new EntityLinkMessageElement(this.viewContext, code, EntityKind.SAMPLE, sample.getPermId()));
                result.add(new HtmlMessageElement("successfully registered in space <b>" + selectedGroup.getCode() + "</b>."));
            }
            result.add(new SampleRegistrationLinkMessageElement(this.viewContext, sample));
            return result;
        }
    }
}

