/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ParentsPropertiesSectionBuilder {
    private final List<Sample> samples = new ArrayList<Sample>();

    ParentsPropertiesSectionBuilder() {
    }

    void addParent(Sample sample) {
        this.samples.add(sample);
    }

    Map<String, List<IEntityProperty>> getSections() {
        LinkedHashMap<String, List<IEntityProperty>> sections = new LinkedHashMap<String, List<IEntityProperty>>();
        HashSet<Key> commonKeys = new HashSet<Key>();
        if (this.samples.size() > 1) {
            Map<Key, List<IEntityProperty>> keys = this.getCommonPropertiesGroups();
            ArrayList<IEntityProperty> commonProperties = new ArrayList<IEntityProperty>();
            for (Map.Entry<Key, List<IEntityProperty>> entry : keys.entrySet()) {
                Key key = entry.getKey();
                List<IEntityProperty> list = entry.getValue();
                if (list.size() != this.samples.size()) continue;
                commonProperties.add(list.get(0));
                commonKeys.add(key);
            }
            if (!commonProperties.isEmpty()) {
                sections.put("Common Parent Properties:", commonProperties);
            }
        }
        Collections.sort(this.samples);
        for (Sample sample : this.samples) {
            List<IEntityProperty> properties = sample.getProperties();
            Iterator<IEntityProperty> iterator = properties.iterator();
            while (iterator.hasNext()) {
                if (!commonKeys.contains(new Key(iterator.next()))) continue;
                iterator.remove();
            }
            if (properties.isEmpty()) continue;
            sections.put(sample.getIdentifier() + " [" + sample.getSampleType().getCode() + "]:", properties);
        }
        return sections;
    }

    private Map<Key, List<IEntityProperty>> getCommonPropertiesGroups() {
        LinkedHashMap<Key, List<IEntityProperty>> keys = new LinkedHashMap<Key, List<IEntityProperty>>();
        for (Sample sample : this.samples) {
            List<IEntityProperty> properties = sample.getProperties();
            for (IEntityProperty property : properties) {
                Key key = new Key(property);
                ArrayList<IEntityProperty> list = (ArrayList<IEntityProperty>)keys.get(key);
                if (list == null) {
                    list = new ArrayList<IEntityProperty>();
                    keys.put(key, list);
                }
                list.add(property);
            }
        }
        return keys;
    }

    private static final class Key {
        private final String code;
        private final DataTypeCode dataType;
        private final String value;

        Key(IEntityProperty property) {
            this.code = property.getPropertyType().getCode();
            this.dataType = property.getPropertyType().getDataType().getCode();
            this.value = property.tryGetAsString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return this.code.equals(key.code) && this.dataType.equals((Object)key.dataType) && this.value.equals(key.value);
        }

        public int hashCode() {
            int hashCode = this.code.hashCode();
            hashCode = 37 * hashCode + this.dataType.hashCode();
            hashCode = 37 * hashCode + this.value.hashCode();
            return hashCode;
        }
    }
}

