/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractFileDownloadServlet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentWithContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.plugin.generic.shared.IGenericServer;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AttachmentDownloadServlet
extends AbstractFileDownloadServlet {
    @Resource(name="generic-plugin-server")
    private IGenericServer server;
    @Resource(name="common-service")
    private ICommonClientService commonService;

    public AttachmentDownloadServlet() {
        this.setRequireSession(false);
    }

    @Private
    public AttachmentDownloadServlet(IGenericServer server) {
        this.server = server;
    }

    @Override
    @RequestMapping(value={"/attachment-download", "/openbis/attachment-download"})
    protected void respondToRequest(HttpServletRequest request, HttpServletResponse response) throws Exception, IOException {
        super.respondToRequest(request, response);
    }

    @Override
    protected AbstractFileDownloadServlet.FileContent getFileContent(HttpServletRequest request) throws Exception {
        String versionStringOrNull = request.getParameter("version");
        Integer versionOrNull = null;
        if (versionStringOrNull != null) {
            versionOrNull = Integer.parseInt(versionStringOrNull);
        }
        String fileName = StringEscapeUtils.unescapeHtml4((String)request.getParameter("fileName"));
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        String techIdString = request.getParameter("id");
        String attachmentHolderKind = request.getParameter("attachmentHolder");
        TechId techId = null;
        if (StringUtils.isNotBlank((CharSequence)techIdString)) {
            techId = new TechId(Long.valueOf(Long.parseLong(techIdString)));
        } else {
            String permId = request.getParameter("permId");
            if (StringUtils.isNotBlank((CharSequence)permId)) {
                techId = new TechId(this.getTechId(attachmentHolderKind, permId));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)fileName) && techId != null && StringUtils.isNotBlank((CharSequence)attachmentHolderKind)) {
            if (attachmentHolderKind.equals(AttachmentHolderKind.EXPERIMENT.name())) {
                return this.getExperimentFile(request, versionOrNull, fileName, techId);
            }
            if (attachmentHolderKind.equals(AttachmentHolderKind.SAMPLE.name())) {
                return this.getSampleFile(request, versionOrNull, fileName, techId);
            }
            if (attachmentHolderKind.equals(AttachmentHolderKind.PROJECT.name())) {
                return this.getProjectFile(request, versionOrNull, fileName, techId);
            }
        }
        return null;
    }

    private Long getTechId(String attachmentHolderKind, String permId) {
        if (attachmentHolderKind.equals(AttachmentHolderKind.EXPERIMENT.name())) {
            return this.commonService.getEntityInformationHolder(EntityKind.EXPERIMENT, permId).getId();
        }
        if (attachmentHolderKind.equals(AttachmentHolderKind.SAMPLE.name())) {
            return this.commonService.getProjectInfoByPermId(permId).getId();
        }
        if (attachmentHolderKind.equals(AttachmentHolderKind.PROJECT.name())) {
            return this.commonService.getEntityInformationHolder(EntityKind.SAMPLE, permId).getId();
        }
        return null;
    }

    private AbstractFileDownloadServlet.FileContent getExperimentFile(HttpServletRequest request, Integer versionOrNull, String fileName, TechId experimentId) {
        AttachmentWithContent attachment = this.server.getExperimentFileAttachment(this.getSessionToken(request), experimentId, fileName, versionOrNull);
        return new AbstractFileDownloadServlet.FileContent(attachment.getContent(), attachment.getFileName());
    }

    private AbstractFileDownloadServlet.FileContent getSampleFile(HttpServletRequest request, Integer versionOrNull, String fileName, TechId sampleId) {
        AttachmentWithContent attachment = this.server.getSampleFileAttachment(this.getSessionToken(request), sampleId, fileName, versionOrNull);
        return new AbstractFileDownloadServlet.FileContent(attachment.getContent(), attachment.getFileName());
    }

    private AbstractFileDownloadServlet.FileContent getProjectFile(HttpServletRequest request, Integer versionOrNull, String fileName, TechId projectId) {
        AttachmentWithContent attachment = this.server.getProjectFileAttachment(this.getSessionToken(request), projectId, fileName, versionOrNull);
        return new AbstractFileDownloadServlet.FileContent(attachment.getContent(), attachment.getFileName());
    }
}

