/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server;

import ch.systemsx.cisd.common.io.DelegatedReader;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSet;
import ch.systemsx.cisd.openbis.generic.shared.parser.BisTabFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.parser.NamedInputStream;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser.UpdatedDataSetParserObjectFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DataSetLoader {
    private List<BatchRegistrationResult> results;
    private List<NewDataSet> newObjects;
    private BisTabFileLoader<NewDataSet> tabFileLoader;

    public void load(Collection<NamedInputStream> files) {
        this.tabFileLoader = new BisTabFileLoader<NewDataSet>(new IParserObjectFactoryFactory<NewDataSet>(){

            public final IParserObjectFactory<NewDataSet> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new UpdatedDataSetParserObjectFactory(propertyMapper);
            }
        }, false);
        this.newObjects = new ArrayList<NewDataSet>();
        this.results = new ArrayList<BatchRegistrationResult>(files.size());
        for (NamedInputStream file : files) {
            Reader reader = file.getUnicodeReader();
            Map<String, String> defaults = Collections.emptyMap();
            List<NewDataSet> loadedMaterials = this.tabFileLoader.load((Reader)new DelegatedReader(reader, file.getOriginalFilename()), defaults);
            this.newObjects.addAll(loadedMaterials);
            this.results.add(new BatchRegistrationResult(file.getOriginalFilename(), String.format("%d data set(s) found and registered.", loadedMaterials.size())));
        }
    }

    public List<BatchRegistrationResult> getResults() {
        return new ArrayList<BatchRegistrationResult>(this.results);
    }

    public List<NewDataSet> getNewDataSets() {
        return new ArrayList<NewDataSet>(this.newObjects);
    }
}

