/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.openbis.common.spring.IUncheckedMultipartFile;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DataSetUpdates;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SampleUpdates;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.AttachmentRegistrationHelper;
import ch.systemsx.cisd.openbis.generic.client.web.server.UploadedFilesBean;
import ch.systemsx.cisd.openbis.generic.client.web.server.queue.ConsumerQueue;
import ch.systemsx.cisd.openbis.generic.client.web.server.queue.ConsumerTask;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.UserFailureExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.exception.SampleUniqueCodeViolationException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.exception.SampleUniqueCodeViolationExceptionAbstract;
import ch.systemsx.cisd.openbis.generic.shared.IEntityImportService;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AsyncBatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialBatchUpdateResultMessage;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewBasicExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSetsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewEntitiesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperimentsWithType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedExperimentsWithType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.parser.NamedInputStream;
import ch.systemsx.cisd.openbis.generic.shared.parser.SampleUploadSectionsParser;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientService;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.DataSetLoader;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.ExperimentLoader;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.UpdatedExperimentLoader;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser.MaterialUploadSectionsParser;
import ch.systemsx.cisd.openbis.plugin.generic.shared.IGenericServerInternal;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="generic-plugin-service")
public class GenericClientService
extends AbstractClientService
implements IGenericClientService,
IEntityImportService {
    @Resource(name="generic-plugin-server")
    private IGenericServerInternal genericServer;
    @Resource(name="registration-queue")
    private ConsumerQueue asyncRegistrationQueue;

    public GenericClientService() {
    }

    @Private
    protected GenericClientService(IGenericServerInternal genericServer, IRequestContextProvider requestContextProvider) {
        super(requestContextProvider);
        this.genericServer = genericServer;
    }

    @Override
    protected final IServer getServer() {
        return this.genericServer;
    }

    @Override
    public final SampleParentWithDerived getSampleGenerationInfo(TechId sampleId) {
        try {
            String sessionToken = this.getSessionToken();
            SampleParentWithDerived sampleParentWithDerived = this.genericServer.getSampleInfo(sessionToken, sampleId);
            this.transformXML(sampleParentWithDerived.getParent());
            return sampleParentWithDerived;
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public final Sample getSampleInfo(TechId sampleId) {
        return this.getSampleGenerationInfo(sampleId).getParent();
    }

    @Override
    public final Sample registerSample(String sessionKey, final NewSample newSample) {
        final String sessionToken = this.getSessionToken();
        class SampleRegistrationHelper
        extends AttachmentRegistrationHelper {
            Sample sample;

            SampleRegistrationHelper() {
            }

            @Override
            public void register(Collection<NewAttachment> attachments) {
                this.sample = GenericClientService.this.genericServer.registerSample(sessionToken, newSample, attachments);
            }
        }
        SampleRegistrationHelper sampleRegistrationHelper = new SampleRegistrationHelper();
        sampleRegistrationHelper.process(sessionKey, this.getHttpSession(), newSample.getAttachments());
        return sampleRegistrationHelper.sample;
    }

    @Override
    public final List<BatchRegistrationResult> registerSamplesWithSilentOverrides(final SampleType sampleType, final String spaceIdentifierSilentOverrideOrNull, final String experimentIdentifierSilentOverrideOrNull, String sessionKey, boolean async, final String userEmail, final String defaultGroupIdentifier, boolean updateExisting) {
        List<BatchRegistrationResult> list;
        block14: {
            UploadedFilesBean uploadedFiles;
            HttpSession httpSession;
            block13: {
                SampleUploadSectionsParser.BatchSamplesOperation info;
                ConsumerTask asyncSamplesTask;
                boolean isCreateContinuousSampleCodes;
                String sessionToken;
                boolean isAutoGenerateCodes;
                block10: {
                    List<BatchRegistrationResult> list2;
                    block12: {
                        block11: {
                            isAutoGenerateCodes = defaultGroupIdentifier != null;
                            httpSession = this.getHttpSession();
                            sessionToken = this.getSessionToken();
                            isCreateContinuousSampleCodes = this.shouldContinuousSampleCodesCreated();
                            uploadedFiles = null;
                            asyncSamplesTask = null;
                            final BatchOperationKind operationKind = updateExisting ? BatchOperationKind.UPDATE : BatchOperationKind.REGISTRATION;
                            uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, httpSession);
                            info = this.parseSamples(sampleType, spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, uploadedFiles, defaultGroupIdentifier, isAutoGenerateCodes, true, null, operationKind, sessionToken);
                            if (!async) break block10;
                            asyncSamplesTask = new ConsumerTask(uploadedFiles){

                                @Override
                                public String getName() {
                                    return "Sample Batch Registration";
                                }

                                @Override
                                public String getUserEmail() {
                                    return userEmail;
                                }

                                @Override
                                public void doActionOrThrowException(Writer writer) {
                                    SampleUploadSectionsParser.BatchSamplesOperation asyncInfo = GenericClientService.this.parseSamples(sampleType, spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, this.getFilesForTask(), defaultGroupIdentifier, isAutoGenerateCodes, true, null, operationKind, sessionToken);
                                    GenericClientService.this.genericServer.registerOrUpdateSamples(sessionToken, asyncInfo.getSamples());
                                    if (isAutoGenerateCodes && isCreateContinuousSampleCodes) {
                                        GenericClientService.this.updateTemporaryCodes(sessionToken, asyncInfo);
                                    }
                                }
                            };
                            String fileName = info.getResultList().get(0).getFileName();
                            list2 = AsyncBatchRegistrationResult.singletonList(fileName);
                            if (!async || asyncSamplesTask == null) break block11;
                            this.asyncRegistrationQueue.addTaskAsLast(asyncSamplesTask);
                            break block12;
                        }
                        GenericClientService.cleanUploadedFiles(sessionKey, httpSession, uploadedFiles);
                    }
                    return list2;
                }
                try {
                    this.genericServer.registerOrUpdateSamples(sessionToken, info.getSamples());
                    if (isAutoGenerateCodes && isCreateContinuousSampleCodes) {
                        this.updateTemporaryCodes(sessionToken, info);
                    }
                    list = info.getResultList();
                    if (!async || asyncSamplesTask == null) break block13;
                    this.asyncRegistrationQueue.addTaskAsLast(asyncSamplesTask);
                    break block14;
                }
                catch (UserFailureException e) {
                    try {
                        if (e.getCause() instanceof SampleUniqueCodeViolationExceptionAbstract) {
                            SampleUniqueCodeViolationExceptionAbstract codeException = (SampleUniqueCodeViolationExceptionAbstract)((Object)e.getCause());
                            if (isAutoGenerateCodes) {
                                throw new ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException(String.format("Import failed because the autogenerated codes are no longer unique. Somebody has created a sample (code: %s) that matched one of the autogenerated codes. Please run the import once again.", codeException.getSampleCode()));
                            }
                            throw new ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException(String.format("Import failed because sample (code: %s) already exists.", codeException.getSampleCode()));
                        }
                        throw UserFailureExceptionTranslator.translate(e);
                    }
                    catch (Throwable throwable) {
                        if (async && asyncSamplesTask != null) {
                            this.asyncRegistrationQueue.addTaskAsLast(asyncSamplesTask);
                        } else {
                            GenericClientService.cleanUploadedFiles(sessionKey, httpSession, uploadedFiles);
                        }
                        throw throwable;
                    }
                }
            }
            GenericClientService.cleanUploadedFiles(sessionKey, httpSession, uploadedFiles);
        }
        return list;
    }

    @Override
    public final List<BatchRegistrationResult> registerSamples(SampleType sampleType, String sessionKey, boolean async, String userEmail, String defaultGroupIdentifier, boolean updateExisting) {
        return this.registerSamplesWithSilentOverrides(sampleType, null, null, sessionKey, async, userEmail, defaultGroupIdentifier, updateExisting);
    }

    private boolean shouldContinuousSampleCodesCreated() {
        return PropertyUtils.getBoolean((Properties)this.getServiceProperties(), (String)"create-continuous-sample-codes", (boolean)false);
    }

    private void updateTemporaryCodes(String sessionToken, SampleUploadSectionsParser.BatchSamplesOperation info) {
        HashMap<String, List<String>> sampleTypeCodeToTemporaryIdentifiers = new HashMap<String, List<String>>();
        List<NewSamplesWithTypes> samples = info.getSamples();
        for (NewSamplesWithTypes newSamplesWithTypes : samples) {
            String sampleTypeCode = ((SampleType)newSamplesWithTypes.getEntityType()).getCode();
            for (NewSample newSample : newSamplesWithTypes.getNewEntities()) {
                ArrayList<String> temporaryIdentifiers = (ArrayList<String>)sampleTypeCodeToTemporaryIdentifiers.get(sampleTypeCode);
                if (temporaryIdentifiers == null) {
                    temporaryIdentifiers = new ArrayList<String>();
                    sampleTypeCodeToTemporaryIdentifiers.put(sampleTypeCode, temporaryIdentifiers);
                }
                temporaryIdentifiers.add(newSample.getIdentifier());
            }
        }
        while (true) {
            try {
                this.genericServer.updateTemporaryCodes(sessionToken, sampleTypeCodeToTemporaryIdentifiers);
                return;
            }
            catch (RuntimeException ex) {
                Throwable originalException;
                if ((originalException = ExceptionUtils.getEndOfChain((Throwable)ex)) instanceof SampleUniqueCodeViolationException) continue;
                throw ex;
            }
            break;
        }
    }

    @Override
    public final List<BatchRegistrationResult> updateSamplesWithSilentOverrides(final SampleType sampleType, final String spaceIdentifierSilentOverrideOrNull, final String experimentIdentifierSilentOverrideOrNull, String sessionKey, boolean async, final String userEmail, final String defaultGroupIdentifier) {
        List<BatchRegistrationResult> list;
        block11: {
            UploadedFilesBean uploadedFiles;
            HttpSession httpSession;
            block10: {
                SampleUploadSectionsParser.BatchSamplesOperation info;
                ConsumerTask asyncSamplesTask;
                String sessionToken;
                block7: {
                    List<BatchRegistrationResult> list2;
                    block9: {
                        block8: {
                            httpSession = this.getHttpSession();
                            sessionToken = this.getSessionToken();
                            uploadedFiles = null;
                            asyncSamplesTask = null;
                            uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, httpSession);
                            info = this.parseSamples(sampleType, spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, uploadedFiles, defaultGroupIdentifier, false, true, null, BatchOperationKind.UPDATE, sessionToken);
                            if (!async) break block7;
                            asyncSamplesTask = new ConsumerTask(uploadedFiles){

                                @Override
                                public String getName() {
                                    return "Sample Batch Update";
                                }

                                @Override
                                public String getUserEmail() {
                                    return userEmail;
                                }

                                @Override
                                public void doActionOrThrowException(Writer writer) {
                                    SampleUploadSectionsParser.BatchSamplesOperation asyncInfo = GenericClientService.this.parseSamples(sampleType, spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, this.getFilesForTask(), defaultGroupIdentifier, false, true, null, BatchOperationKind.UPDATE, sessionToken);
                                    GenericClientService.this.genericServer.updateSamples(sessionToken, asyncInfo.getSamples());
                                }
                            };
                            String fileName = info.getResultList().get(0).getFileName();
                            list2 = AsyncBatchRegistrationResult.singletonList(fileName);
                            if (!async || asyncSamplesTask == null) break block8;
                            this.asyncRegistrationQueue.addTaskAsLast(asyncSamplesTask);
                            break block9;
                        }
                        GenericClientService.cleanUploadedFiles(sessionKey, httpSession, uploadedFiles);
                    }
                    return list2;
                }
                try {
                    this.genericServer.updateSamples(sessionToken, info.getSamples());
                    list = info.getResultList();
                    if (!async || asyncSamplesTask == null) break block10;
                    this.asyncRegistrationQueue.addTaskAsLast(asyncSamplesTask);
                    break block11;
                }
                catch (UserFailureException e) {
                    try {
                        throw UserFailureExceptionTranslator.translate(e);
                    }
                    catch (Throwable throwable) {
                        if (async && asyncSamplesTask != null) {
                            this.asyncRegistrationQueue.addTaskAsLast(asyncSamplesTask);
                        } else {
                            GenericClientService.cleanUploadedFiles(sessionKey, httpSession, uploadedFiles);
                        }
                        throw throwable;
                    }
                }
            }
            GenericClientService.cleanUploadedFiles(sessionKey, httpSession, uploadedFiles);
        }
        return list;
    }

    @Override
    public final List<BatchRegistrationResult> updateSamples(SampleType sampleType, String sessionKey, boolean async, String userEmail, String defaultGroupIdentifier) {
        return this.updateSamplesWithSilentOverrides(sampleType, null, null, sessionKey, async, userEmail, defaultGroupIdentifier);
    }

    @Override
    public final List<BatchRegistrationResult> registerOrUpdateSamplesAndMaterials(String sessionKey, final String defaultGroupIdentifier, final boolean updateExisting, boolean async, final String userEmail) throws ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException {
        ArrayList<BatchRegistrationResult> arrayList;
        block11: {
            UploadedFilesBean uploadedFiles;
            HttpSession session;
            block10: {
                MaterialUploadSectionsParser.BatchMaterialsOperation materialsInfo;
                SampleUploadSectionsParser.BatchSamplesOperation samplesInfo;
                ConsumerTask asyncGeneralTask;
                String sessionToken;
                block7: {
                    List<BatchRegistrationResult> list;
                    block9: {
                        block8: {
                            final BatchOperationKind operationKind = updateExisting ? BatchOperationKind.UPDATE : BatchOperationKind.REGISTRATION;
                            sessionToken = this.getSessionToken();
                            session = this.getHttpSession();
                            final SampleType sampleType = new SampleType();
                            sampleType.setCode("(multiple)");
                            asyncGeneralTask = null;
                            uploadedFiles = null;
                            uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
                            samplesInfo = this.parseSamples(sampleType, null, null, uploadedFiles, defaultGroupIdentifier, defaultGroupIdentifier != null, true, "SAMPLES", operationKind, sessionToken);
                            final MaterialType materialType = new MaterialType();
                            materialType.setCode("(multiple)");
                            materialsInfo = this.parseMaterials(session, uploadedFiles, materialType, "MATERIALS", updateExisting);
                            if (!async) break block7;
                            asyncGeneralTask = new ConsumerTask(uploadedFiles){

                                @Override
                                public String getName() {
                                    return "General Batch Import";
                                }

                                @Override
                                public String getUserEmail() {
                                    return userEmail;
                                }

                                @Override
                                public void doActionOrThrowException(Writer writer) {
                                    SampleUploadSectionsParser.BatchSamplesOperation asyncSamplesInfo = GenericClientService.this.parseSamples(sampleType, null, null, this.getFilesForTask(), defaultGroupIdentifier, defaultGroupIdentifier != null, true, "SAMPLES", operationKind, sessionToken);
                                    MaterialUploadSectionsParser.BatchMaterialsOperation asyncMaterialsInfo = GenericClientService.this.parseMaterials(session, this.getFilesForTask(), materialType, "MATERIALS", updateExisting);
                                    GenericClientService.this.genericServer.registerOrUpdateSamplesAndMaterials(sessionToken, asyncSamplesInfo.getSamples(), asyncMaterialsInfo.getMaterials());
                                }
                            };
                            String fileName = uploadedFiles.iterable().iterator().next().getOriginalFilename();
                            list = AsyncBatchRegistrationResult.singletonList(fileName);
                            if (!async || asyncGeneralTask == null) break block8;
                            this.asyncRegistrationQueue.addTaskAsLast(asyncGeneralTask);
                            break block9;
                        }
                        GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                    }
                    return list;
                }
                try {
                    this.genericServer.registerOrUpdateSamplesAndMaterials(sessionToken, samplesInfo.getSamples(), materialsInfo.getMaterials());
                    ArrayList<BatchRegistrationResult> results = new ArrayList<BatchRegistrationResult>();
                    results.addAll(materialsInfo.getResultList());
                    results.addAll(samplesInfo.getResultList());
                    arrayList = results;
                    if (!async || asyncGeneralTask == null) break block10;
                    this.asyncRegistrationQueue.addTaskAsLast(asyncGeneralTask);
                    break block11;
                }
                catch (UserFailureException e) {
                    try {
                        throw UserFailureExceptionTranslator.translate(e);
                    }
                    catch (Throwable throwable) {
                        if (async && asyncGeneralTask != null) {
                            this.asyncRegistrationQueue.addTaskAsLast(asyncGeneralTask);
                        } else {
                            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                        }
                        throw throwable;
                    }
                }
            }
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
        return arrayList;
    }

    @Override
    public final AbstractExternalData getDataSetInfo(TechId datasetId) {
        try {
            String sessionToken = this.getSessionToken();
            AbstractExternalData dataset = this.genericServer.getDataSetInfo(sessionToken, datasetId);
            this.transformXML(dataset);
            return dataset;
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public Experiment registerExperiment(String attachmentsSessionKey, String samplesSessionKey, final NewExperiment experiment) {
        final String sessionToken = this.getSessionToken();
        boolean autoGenerateCodes = experiment.isGenerateCodes();
        SampleUploadSectionsParser.BatchSamplesOperation parsedSamples = null;
        if (experiment.isRegisterSamples()) {
            ExperimentIdentifier identifier = new ExperimentIdentifierFactory(experiment.getIdentifier()).createIdentifier();
            parsedSamples = this.parseSamples(experiment.getSampleType(), samplesSessionKey, new SpaceIdentifier(identifier.getSpaceCode()).toString(), autoGenerateCodes, false, null, BatchOperationKind.REGISTRATION);
            experiment.setNewSamples(parsedSamples.getSamples());
            experiment.setSamples(parsedSamples.getCodes());
        }
        class ExperimentRegistrationHelper
        extends AttachmentRegistrationHelper {
            Experiment exp;

            ExperimentRegistrationHelper() {
            }

            @Override
            public void register(Collection<NewAttachment> attachments) {
                this.exp = GenericClientService.this.genericServer.registerExperiment(sessionToken, experiment, attachments);
            }
        }
        ExperimentRegistrationHelper helper = new ExperimentRegistrationHelper();
        helper.process(attachmentsSessionKey, this.getHttpSession(), experiment.getAttachments());
        if (autoGenerateCodes && this.shouldContinuousSampleCodesCreated() && parsedSamples != null) {
            this.updateTemporaryCodes(sessionToken, parsedSamples);
        }
        return helper.exp;
    }

    private SampleUploadSectionsParser.BatchSamplesOperation parseSamples(SampleType sampleType, String spaceIdentifierSilentOverrideOrNull, String experimentIdentifierSilentOverrideOrNull, UploadedFilesBean uploadedFiles, String defaultGroupIdentifier, boolean isAutoGenerateCodes, boolean allowExperiments, String excelSheetName, BatchOperationKind operationKind, String sessionToken) {
        boolean updateExisting = operationKind == BatchOperationKind.UPDATE;
        boolean isCreateContinuousSampleCodes = this.shouldContinuousSampleCodesCreated();
        SampleUploadSectionsParser.SampleCodeGenerator sampleCodeGeneratorOrNull = this.tryGetSampleCodeGenerator(isAutoGenerateCodes, isCreateContinuousSampleCodes, sampleType.getGeneratedCodePrefix(), sessionToken);
        ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
        for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
            files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
        }
        boolean projectSamplesEnabled = this.genericServer.isProjectSamplesEnabled(sessionToken);
        SampleUploadSectionsParser.BatchSamplesOperation batchSamplesOperation = SampleUploadSectionsParser.prepareSamples(projectSamplesEnabled, sampleType, spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, files, defaultGroupIdentifier, sampleCodeGeneratorOrNull, allowExperiments, excelSheetName, operationKind);
        this.validateAutoGeneratedTypes(isAutoGenerateCodes, isCreateContinuousSampleCodes, batchSamplesOperation);
        GenericClientService.setUpdatePossibility(batchSamplesOperation.getSamples(), updateExisting);
        return batchSamplesOperation;
    }

    private void validateAutoGeneratedTypes(boolean isAutoGenerateCodes, boolean isCreateContinuousSampleCodes, SampleUploadSectionsParser.BatchSamplesOperation batchSamplesOperation) {
        if (isAutoGenerateCodes && isCreateContinuousSampleCodes) {
            HashMap<String, Integer> prefixes = new HashMap<String, Integer>();
            List<SampleType> sampleTypes = this.commonClientService.listSampleTypes();
            HashSet<String> usedSampleTypeCodes = new HashSet<String>();
            for (NewSamplesWithTypes newSampleWithType : batchSamplesOperation.getSamples()) {
                usedSampleTypeCodes.add(((SampleType)newSampleWithType.getEntityType()).getCode());
            }
            for (SampleType auxSampleType : sampleTypes) {
                if (!usedSampleTypeCodes.contains(auxSampleType.getCode())) continue;
                Integer repetitions = (Integer)prefixes.get(auxSampleType.getGeneratedCodePrefix());
                if (repetitions == null) {
                    repetitions = 0;
                }
                Integer n = repetitions;
                Integer n2 = repetitions = Integer.valueOf(repetitions + 1);
                prefixes.put(auxSampleType.getGeneratedCodePrefix(), repetitions);
                if (repetitions <= 1) continue;
                throw new ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException("The prefix '" + auxSampleType.getGeneratedCodePrefix() + "' found at " + auxSampleType.getCode() + " it's alreay used in other type, please change this to use continuous sample type codes by type.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SampleUploadSectionsParser.BatchSamplesOperation parseSamples(SampleType sampleType, String sessionKey, String defaultGroupIdentifier, boolean isAutoGenerateCodes, boolean allowExperiments, String excelSheetName, BatchOperationKind operationKind) {
        HttpSession httpSession = this.getHttpSession();
        String sessionToken = this.getSessionToken();
        UploadedFilesBean uploadedFiles = null;
        try {
            uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, httpSession);
            SampleUploadSectionsParser.BatchSamplesOperation batchSamplesOperation = this.parseSamples(sampleType, null, null, uploadedFiles, defaultGroupIdentifier, isAutoGenerateCodes, allowExperiments, excelSheetName, operationKind, sessionToken);
            return batchSamplesOperation;
        }
        finally {
            GenericClientService.cleanUploadedFiles(sessionKey, httpSession, uploadedFiles);
        }
    }

    private static void setUpdatePossibility(List<? extends NewEntitiesWithTypes<?, ?>> batchOperation, boolean updateExisting) {
        for (NewEntitiesWithTypes<?, ?> entitiesWithTypes : batchOperation) {
            entitiesWithTypes.setAllowUpdateIfExist(updateExisting);
        }
    }

    private SampleUploadSectionsParser.SampleCodeGenerator tryGetSampleCodeGenerator(boolean isAutoGenerateCodes, final boolean isCreateContinuousSampleCodes, final String codePrefix, final String sessionToken) {
        if (isAutoGenerateCodes) {
            return new SampleUploadSectionsParser.SampleCodeGenerator(){

                @Override
                public List<String> generateCodes(int size) {
                    if (isCreateContinuousSampleCodes) {
                        return GenericClientService.this.genericServer.generateTemporaryCodes(sessionToken, codePrefix, EntityKind.SAMPLE, size);
                    }
                    return GenericClientService.this.genericServer.generateCodes(sessionToken, codePrefix, EntityKind.SAMPLE, size);
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<BatchRegistrationResult> registerMaterials(final MaterialType materialType, final boolean updateExisting, String sessionKey, boolean async, final String userEmail) {
        List<BatchRegistrationResult> list;
        block9: {
            UploadedFilesBean uploadedFiles;
            HttpSession session;
            block8: {
                List<NewMaterialsWithTypes> materials;
                MaterialUploadSectionsParser.BatchMaterialsOperation results;
                ConsumerTask asyncMaterialTask;
                String sessionToken;
                block5: {
                    List<BatchRegistrationResult> list2;
                    block7: {
                        block6: {
                            sessionToken = this.getSessionToken();
                            session = this.getHttpSession();
                            uploadedFiles = null;
                            asyncMaterialTask = null;
                            try {
                                uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
                                results = this.parseMaterials(session, uploadedFiles, materialType, null, updateExisting);
                                String fileName = results.getResultList().get(0).getFileName();
                                materials = results.getMaterials();
                                if (!async) break block5;
                                asyncMaterialTask = new ConsumerTask(uploadedFiles){

                                    @Override
                                    public String getName() {
                                        return "Material Batch Registration";
                                    }

                                    @Override
                                    public String getUserEmail() {
                                        return userEmail;
                                    }

                                    @Override
                                    public void doActionOrThrowException(Writer writer) {
                                        MaterialUploadSectionsParser.BatchMaterialsOperation asyncResults = GenericClientService.this.parseMaterials(session, this.getFilesForTask(), materialType, null, updateExisting);
                                        List<NewMaterialsWithTypes> asyncMaterials = asyncResults.getMaterials();
                                        GenericClientService.this.genericServer.registerOrUpdateMaterials(sessionToken, asyncMaterials);
                                    }
                                };
                                list2 = AsyncBatchRegistrationResult.singletonList(fileName);
                                if (!async || asyncMaterialTask == null) break block6;
                                this.asyncRegistrationQueue.addTaskAsLast(asyncMaterialTask);
                                break block7;
                            }
                            catch (Throwable throwable) {
                                if (async && asyncMaterialTask != null) {
                                    this.asyncRegistrationQueue.addTaskAsLast(asyncMaterialTask);
                                } else {
                                    GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                                }
                                throw throwable;
                            }
                        }
                        GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                    }
                    return list2;
                }
                this.genericServer.registerOrUpdateMaterials(sessionToken, materials);
                list = results.getResultList();
                if (!async || asyncMaterialTask == null) break block8;
                this.asyncRegistrationQueue.addTaskAsLast(asyncMaterialTask);
                break block9;
            }
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BatchRegistrationResult> updateMaterials(final MaterialType materialType, String sessionKey, final boolean ignoreUnregisteredMaterials, boolean async, final String userEmail) {
        List<BatchRegistrationResult> list;
        block9: {
            UploadedFilesBean uploadedFiles;
            HttpSession session;
            block8: {
                String fileName;
                MaterialUploadSectionsParser.BatchMaterialsOperation results;
                ConsumerTask asyncMaterialTask;
                String sessionToken;
                block5: {
                    List<BatchRegistrationResult> list2;
                    block7: {
                        block6: {
                            sessionToken = this.getSessionToken();
                            session = this.getHttpSession();
                            uploadedFiles = null;
                            asyncMaterialTask = null;
                            try {
                                uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
                                results = this.parseMaterials(session, uploadedFiles, materialType, null, true);
                                fileName = results.getResultList().get(0).getFileName();
                                if (!async) break block5;
                                asyncMaterialTask = new ConsumerTask(uploadedFiles){

                                    @Override
                                    public String getName() {
                                        return "Material Batch Update";
                                    }

                                    @Override
                                    public String getUserEmail() {
                                        return userEmail;
                                    }

                                    @Override
                                    public void doActionOrThrowException(Writer writer) {
                                        try {
                                            MaterialUploadSectionsParser.BatchMaterialsOperation asyncResults = GenericClientService.this.parseMaterials(session, this.getFilesForTask(), materialType, null, true);
                                            int updateCount = GenericClientService.this.genericServer.updateMaterials(sessionToken, asyncResults.getMaterials(), ignoreUnregisteredMaterials);
                                            MaterialBatchUpdateResultMessage message = new MaterialBatchUpdateResultMessage(asyncResults.getMaterials(), updateCount, ignoreUnregisteredMaterials);
                                            writer.write(message.toString());
                                        }
                                        catch (IOException e) {
                                            CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
                                        }
                                    }
                                };
                                list2 = AsyncBatchRegistrationResult.singletonList(fileName);
                                if (!async || asyncMaterialTask == null) break block6;
                                this.asyncRegistrationQueue.addTaskAsLast(asyncMaterialTask);
                                break block7;
                            }
                            catch (Throwable throwable) {
                                if (async && asyncMaterialTask != null) {
                                    this.asyncRegistrationQueue.addTaskAsLast(asyncMaterialTask);
                                } else {
                                    GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                                }
                                throw throwable;
                            }
                        }
                        GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                    }
                    return list2;
                }
                int updateCount = this.genericServer.updateMaterials(sessionToken, results.getMaterials(), ignoreUnregisteredMaterials);
                MaterialBatchUpdateResultMessage message = new MaterialBatchUpdateResultMessage(results.getMaterials(), updateCount, ignoreUnregisteredMaterials);
                list = Arrays.asList(new BatchRegistrationResult(fileName, message.toString()));
                if (!async || asyncMaterialTask == null) break block8;
                this.asyncRegistrationQueue.addTaskAsLast(asyncMaterialTask);
                break block9;
            }
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BatchRegistrationResult> updateExperiments(final ExperimentType experimentType, String sessionKey, boolean async, final String userEmail) throws ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException {
        List<BatchRegistrationResult> list;
        block10: {
            UploadedFilesBean uploadedFiles;
            HttpSession session;
            block9: {
                UpdatedExperimentsWithType updatedExperiments;
                String sessionToken;
                UpdatedExperimentLoader loader;
                ConsumerTask asyncExperimentTask;
                block6: {
                    List<BatchRegistrationResult> list2;
                    block8: {
                        block7: {
                            session = this.getHttpSession();
                            uploadedFiles = null;
                            asyncExperimentTask = null;
                            try {
                                List<BatchRegistrationResult> batchRegistrationResults;
                                uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
                                ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
                                for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
                                    files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
                                }
                                loader = new UpdatedExperimentLoader();
                                loader.load(files);
                                sessionToken = this.getSessionToken();
                                this.applyDefaultSpaceProjectToExperiments(loader.getNewBasicExperiments(), sessionToken);
                                updatedExperiments = new UpdatedExperimentsWithType(experimentType, loader.getNewBasicExperiments());
                                if (!async) break block6;
                                asyncExperimentTask = new ConsumerTask(uploadedFiles){

                                    @Override
                                    public String getName() {
                                        return "Experiment Batch Update";
                                    }

                                    @Override
                                    public String getUserEmail() {
                                        return userEmail;
                                    }

                                    @Override
                                    public void doActionOrThrowException(Writer writer) {
                                        ArrayList<NamedInputStream> asyncFiles = new ArrayList<NamedInputStream>(this.getFilesForTask().size());
                                        for (IUncheckedMultipartFile f : this.getFilesForTask().iterable()) {
                                            asyncFiles.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
                                        }
                                        UpdatedExperimentLoader loaderAsync = new UpdatedExperimentLoader();
                                        loaderAsync.load(asyncFiles);
                                        GenericClientService.this.applyDefaultSpaceProjectToExperiments(loaderAsync.getNewBasicExperiments(), sessionToken);
                                        UpdatedExperimentsWithType updatedExperimentsAsync = new UpdatedExperimentsWithType(experimentType, loaderAsync.getNewBasicExperiments());
                                        GenericClientService.this.genericServer.updateExperiments(sessionToken, updatedExperimentsAsync);
                                    }
                                };
                                String fileName = loader.getResults().get(0).getFileName();
                                list2 = batchRegistrationResults = AsyncBatchRegistrationResult.singletonList(fileName);
                                if (!async || asyncExperimentTask == null) break block7;
                                this.asyncRegistrationQueue.addTaskAsLast(asyncExperimentTask);
                                break block8;
                            }
                            catch (Throwable throwable) {
                                if (async && asyncExperimentTask != null) {
                                    this.asyncRegistrationQueue.addTaskAsLast(asyncExperimentTask);
                                } else {
                                    GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                                }
                                throw throwable;
                            }
                        }
                        GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                    }
                    return list2;
                }
                this.genericServer.updateExperiments(sessionToken, updatedExperiments);
                list = loader.getResults();
                if (!async || asyncExperimentTask == null) break block9;
                this.asyncRegistrationQueue.addTaskAsLast(asyncExperimentTask);
                break block10;
            }
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
        return list;
    }

    private final ExperimentLoader getExperimentsFromFiles(UploadedFilesBean uploadedFiles) {
        ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
        for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
            files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
        }
        ExperimentLoader loader = new ExperimentLoader();
        loader.load(files);
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<BatchRegistrationResult> registerExperiments(final ExperimentType experimentType, String sessionKey, boolean async, final String userEmail) {
        List<BatchRegistrationResult> list;
        block9: {
            UploadedFilesBean uploadedFiles;
            HttpSession session;
            block8: {
                NewExperimentsWithType newExperiments;
                ExperimentLoader loader;
                String sessionToken;
                ConsumerTask asyncExperimentTask;
                block5: {
                    List<BatchRegistrationResult> list2;
                    block7: {
                        block6: {
                            session = this.getHttpSession();
                            uploadedFiles = null;
                            asyncExperimentTask = null;
                            try {
                                sessionToken = this.getSessionToken();
                                uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
                                loader = this.getExperimentsFromFiles(uploadedFiles);
                                this.applyDefaultSpaceProjectToExperiments(loader.getNewBasicExperiments(), sessionToken);
                                newExperiments = new NewExperimentsWithType(experimentType.getCode(), loader.getNewBasicExperiments());
                                if (!async) break block5;
                                asyncExperimentTask = new ConsumerTask(uploadedFiles){

                                    @Override
                                    public String getName() {
                                        return "Experiment Batch Registration";
                                    }

                                    @Override
                                    public String getUserEmail() {
                                        return userEmail;
                                    }

                                    @Override
                                    public void doActionOrThrowException(Writer writer) {
                                        ExperimentLoader asyncLoader = GenericClientService.this.getExperimentsFromFiles(this.getFilesForTask());
                                        GenericClientService.this.applyDefaultSpaceProjectToExperiments(asyncLoader.getNewBasicExperiments(), sessionToken);
                                        NewExperimentsWithType newExperiments = new NewExperimentsWithType(experimentType.getCode(), asyncLoader.getNewBasicExperiments());
                                        GenericClientService.this.genericServer.registerExperiments(sessionToken, newExperiments);
                                    }
                                };
                                String fileName = loader.getResults().get(0).getFileName();
                                list2 = AsyncBatchRegistrationResult.singletonList(fileName);
                                if (!async || asyncExperimentTask == null) break block6;
                                this.asyncRegistrationQueue.addTaskAsLast(asyncExperimentTask);
                                break block7;
                            }
                            catch (Throwable throwable) {
                                if (async && asyncExperimentTask != null) {
                                    this.asyncRegistrationQueue.addTaskAsLast(asyncExperimentTask);
                                } else {
                                    GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                                }
                                throw throwable;
                            }
                        }
                        GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                    }
                    return list2;
                }
                this.genericServer.registerExperiments(sessionToken, newExperiments);
                list = loader.getResults();
                if (!async || asyncExperimentTask == null) break block8;
                this.asyncRegistrationQueue.addTaskAsLast(asyncExperimentTask);
                break block9;
            }
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
        return list;
    }

    private String getUserDefaultProject(String sessionToken) {
        String projectIdentifier = null;
        PersonPE person = this.getServer().getAuthSession(sessionToken).tryGetPerson();
        if (person != null && person.getDisplaySettings() != null) {
            projectIdentifier = person.getDisplaySettings().getDefaultProject();
        }
        if (projectIdentifier != null) {
            return projectIdentifier;
        }
        return null;
    }

    private String getUserDefaultSpace(String sessionToken) {
        String spaceIdentifier = null;
        PersonPE person = this.getServer().getAuthSession(sessionToken).tryGetPerson();
        if (person != null && person.getHomeSpace() != null) {
            spaceIdentifier = person.getHomeSpace().getCode();
        }
        if (spaceIdentifier != null) {
            return spaceIdentifier;
        }
        return null;
    }

    private int count(char character, String string) {
        int count = 0;
        int fromIndex = -1;
        while (string.indexOf(character, fromIndex + 1) > fromIndex) {
            fromIndex = string.indexOf(character, fromIndex + 1);
            ++count;
        }
        return count;
    }

    private void applyDefaultSpaceProjectToExperiments(List<? extends NewBasicExperiment> experiments, String sessionToken) {
        String newExperimentIdentifier;
        String defaultProjectIdentifier = this.getUserDefaultProject(sessionToken);
        String defaultSpaceIdentifier = this.getUserDefaultSpace(sessionToken);
        for (NewBasicExperiment newBasicExperiment : experiments) {
            newExperimentIdentifier = newBasicExperiment.getIdentifier();
            int numberOfSlashes = this.count('/', newExperimentIdentifier);
            switch (numberOfSlashes) {
                case 0: {
                    if (defaultProjectIdentifier == null) break;
                    newBasicExperiment.setIdentifier(defaultProjectIdentifier + "/" + newExperimentIdentifier);
                    break;
                }
                case 1: {
                    if (defaultSpaceIdentifier == null || newExperimentIdentifier.startsWith("/") || newExperimentIdentifier.endsWith("/")) break;
                    newBasicExperiment.setIdentifier("/" + defaultSpaceIdentifier + "/" + newExperimentIdentifier);
                    break;
                }
            }
        }
        for (NewBasicExperiment newBasicExperiment : experiments) {
            newExperimentIdentifier = newBasicExperiment.getIdentifier();
            int numberSlash = this.count('/', newExperimentIdentifier);
            if (numberSlash == 3) continue;
            throw new ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException("The given identifier is not complete '" + newExperimentIdentifier + "' and the required home space or default project is missing.");
        }
    }

    private MaterialUploadSectionsParser.BatchMaterialsOperation parseMaterials(HttpSession session, UploadedFilesBean uploadedFiles, MaterialType materialType, String excelSheetName, boolean updateExisting) {
        ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
        for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
            files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
        }
        MaterialUploadSectionsParser.BatchMaterialsOperation batchMaterialsOperation = MaterialUploadSectionsParser.prepareMaterials(materialType, files, excelSheetName);
        GenericClientService.setUpdatePossibility(batchMaterialsOperation.getMaterials(), updateExisting);
        return batchMaterialsOperation;
    }

    @Override
    public SampleUpdateResult updateSample(final SampleUpdates updates) {
        final String sessionToken = this.getSessionToken();
        final SampleUpdateResult result = new SampleUpdateResult();
        new AttachmentRegistrationHelper(){

            @Override
            public void register(Collection<NewAttachment> attachments) {
                SampleIdentifier sampleOwner = null;
                ExperimentIdentifier convExperimentIdentifierOrNull = GenericClientService.this.getExperimentIdentifier(updates);
                ProjectIdentifier projectIdentifier = GenericClientService.this.getProjectIdentifier(updates);
                if (!StringUtils.isBlank((CharSequence)updates.getSampleIdentifier())) {
                    sampleOwner = new SampleIdentifierFactory(updates.getSampleIdentifier()).createIdentifier();
                }
                SampleUpdatesDTO updatesDTO = new SampleUpdatesDTO(updates.getSampleIdOrNull(), updates.getProperties(), convExperimentIdentifierOrNull, projectIdentifier, attachments, updates.getVersion(), sampleOwner, updates.getContainerIdentifierOrNull(), updates.getModifiedParentCodesOrNull());
                updatesDTO.setMetaprojectsOrNull(updates.getMetaprojectsOrNull());
                SampleUpdateResult updateResult = GenericClientService.this.genericServer.updateSample(sessionToken, updatesDTO);
                result.copyFrom(updateResult);
            }
        }.process(updates.getSessionKey(), this.getHttpSession(), updates.getAttachments());
        return result;
    }

    private ExperimentIdentifier getExperimentIdentifier(SampleUpdates updates) {
        ExperimentIdentifier convExperimentIdentifierOrNull = null;
        if (updates.getExperimentIdentifierOrNull() != null) {
            convExperimentIdentifierOrNull = new ExperimentIdentifierFactory(updates.getExperimentIdentifierOrNull().getIdentifier()).createIdentifier();
        }
        return convExperimentIdentifierOrNull;
    }

    private ProjectIdentifier getProjectIdentifier(SampleUpdates updates) {
        String identifier = updates.getProjectIdentifierOrNull();
        if (identifier == null) {
            return null;
        }
        return new ProjectIdentifierFactory(identifier).createIdentifier();
    }

    @Override
    public Date updateMaterial(TechId materialId, List<IEntityProperty> properties, String[] metaprojects, Date version) {
        try {
            String sessionToken = this.getSessionToken();
            return this.genericServer.updateMaterial(sessionToken, materialId, properties, metaprojects, version);
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public ExperimentUpdateResult updateExperiment(final ExperimentUpdates updates) {
        final String sessionToken = this.getSessionToken();
        final ExperimentUpdateResult result = new ExperimentUpdateResult();
        boolean autoGenerateCodes = updates.isGenerateCodes();
        SampleUploadSectionsParser.BatchSamplesOperation info = null;
        if (updates.isRegisterSamples()) {
            ProjectIdentifier newProject = new ProjectIdentifierFactory(updates.getProjectIdentifier()).createIdentifier();
            info = this.parseSamples(updates.getSampleType(), updates.getSamplesSessionKey(), new SpaceIdentifier(newProject.getSpaceCode()).toString(), autoGenerateCodes, false, null, BatchOperationKind.REGISTRATION);
            updates.setNewSamples(info.getSamples());
            updates.setSampleCodes(info.getCodes());
        }
        new AttachmentRegistrationHelper(){

            @Override
            public void register(Collection<NewAttachment> attachments) {
                ExperimentUpdatesDTO updatesDTO = GenericClientService.createExperimentUpdatesDTO(updates, attachments);
                ExperimentUpdateResult updateResult = GenericClientService.this.genericServer.updateExperiment(sessionToken, updatesDTO);
                result.copyFrom(updateResult);
            }
        }.process(updates.getAttachmentSessionKey(), this.getHttpSession(), updates.getAttachments());
        if (autoGenerateCodes && this.shouldContinuousSampleCodesCreated() && info != null) {
            this.updateTemporaryCodes(sessionToken, info);
        }
        return result;
    }

    private static ExperimentUpdatesDTO createExperimentUpdatesDTO(ExperimentUpdates updates, Collection<NewAttachment> attachments) {
        ExperimentUpdatesDTO updatesDTO = new ExperimentUpdatesDTO();
        updatesDTO.setExperimentId(updates.getExperimentId());
        ProjectIdentifier project = new ProjectIdentifierFactory(updates.getProjectIdentifier()).createIdentifier();
        updatesDTO.setProjectIdentifier(project);
        updatesDTO.setAttachments(attachments);
        updatesDTO.setProperties(updates.getProperties());
        updatesDTO.setSampleCodes(updates.getSampleCodes());
        updatesDTO.setVersion(updates.getVersion());
        updatesDTO.setRegisterSamples(updates.isRegisterSamples());
        updatesDTO.setNewSamples(updates.getNewSamples());
        updatesDTO.setSampleType(updates.getSampleType());
        updatesDTO.setMetaprojectsOrNull(updates.getMetaprojectsOrNull());
        return updatesDTO;
    }

    @Override
    public DataSetUpdateResult updateDataSet(DataSetUpdates updates) {
        String sessionToken = this.getSessionToken();
        return this.genericServer.updateDataSet(sessionToken, GenericClientService.createDataSetUpdatesDTO(updates));
    }

    private static DataSetUpdatesDTO createDataSetUpdatesDTO(DataSetUpdates updates) {
        DataSetUpdatesDTO updatesDTO = new DataSetUpdatesDTO();
        updatesDTO.setDatasetId(updates.getDatasetId());
        updatesDTO.setProperties(updates.getProperties());
        updatesDTO.setVersion(updates.getVersion());
        updatesDTO.setModifiedParentDatasetCodesOrNull(updates.getModifiedParentDatasetCodesOrNull());
        updatesDTO.setModifiedContainedDatasetCodesOrNull(updates.getModifiedContainedDatasetCodesOrNull());
        String sampleIdentifierOrNull = updates.getSampleIdentifierOrNull();
        updatesDTO.setSampleIdentifierOrNull(sampleIdentifierOrNull == null ? null : SampleIdentifierFactory.parse(sampleIdentifierOrNull));
        String experimentIdentifierOrNull = updates.getExperimentIdentifierOrNull();
        updatesDTO.setExperimentIdentifierOrNull(experimentIdentifierOrNull == null ? null : new ExperimentIdentifierFactory(experimentIdentifierOrNull).createIdentifier());
        updatesDTO.setFileFormatTypeCode(updates.getFileFormatTypeCode());
        updatesDTO.setExternalCode(updates.getExternalCode());
        updatesDTO.setExternalDataManagementSystemCode(updates.getExternalDataManagementSystemCode());
        updatesDTO.setMetaprojectsOrNull(updates.getMetaprojectsOrNull());
        return updatesDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BatchRegistrationResult> updateDataSets(final DataSetType dataSetType, String sessionKey, boolean async, final String userEmail) {
        List<BatchRegistrationResult> list;
        block10: {
            UploadedFilesBean uploadedFiles;
            HttpSession session;
            block9: {
                NewDataSetsWithTypes newDataSetsWithTypes;
                DataSetLoader loader;
                ConsumerTask asyncDatasetsTask;
                block6: {
                    List<BatchRegistrationResult> list2;
                    block8: {
                        block7: {
                            session = this.getHttpSession();
                            final String sessionToken = this.getSessionToken();
                            uploadedFiles = null;
                            asyncDatasetsTask = null;
                            try {
                                uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
                                ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
                                for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
                                    files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
                                }
                                loader = new DataSetLoader();
                                loader.load(files);
                                newDataSetsWithTypes = new NewDataSetsWithTypes(dataSetType, loader.getNewDataSets());
                                if (!async) break block6;
                                asyncDatasetsTask = new ConsumerTask(uploadedFiles){

                                    @Override
                                    public String getName() {
                                        return "Data Set Batch Update";
                                    }

                                    @Override
                                    public String getUserEmail() {
                                        return userEmail;
                                    }

                                    @Override
                                    public void doActionOrThrowException(Writer writer) {
                                        ArrayList<NamedInputStream> asyncFiles = new ArrayList<NamedInputStream>(this.getFilesForTask().size());
                                        for (IUncheckedMultipartFile f : this.getFilesForTask().iterable()) {
                                            asyncFiles.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
                                        }
                                        DataSetLoader asyncLoader = new DataSetLoader();
                                        asyncLoader.load(asyncFiles);
                                        NewDataSetsWithTypes asyncNewDataSetsWithTypes = new NewDataSetsWithTypes(dataSetType, asyncLoader.getNewDataSets());
                                        GenericClientService.this.genericServer.updateDataSets(sessionToken, asyncNewDataSetsWithTypes);
                                    }
                                };
                                String fileName = loader.getResults().get(0).getFileName();
                                list2 = AsyncBatchRegistrationResult.singletonList(fileName);
                                if (!async || asyncDatasetsTask == null) break block7;
                                this.asyncRegistrationQueue.addTaskAsLast(asyncDatasetsTask);
                                break block8;
                            }
                            catch (Throwable throwable) {
                                if (async && asyncDatasetsTask != null) {
                                    this.asyncRegistrationQueue.addTaskAsLast(asyncDatasetsTask);
                                } else {
                                    GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                                }
                                throw throwable;
                            }
                        }
                        GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
                    }
                    return list2;
                }
                this.genericServer.updateDataSets(this.getSessionToken(), newDataSetsWithTypes);
                list = loader.getResults();
                if (!async || asyncDatasetsTask == null) break block9;
                this.asyncRegistrationQueue.addTaskAsLast(asyncDatasetsTask);
                break block10;
            }
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
        return list;
    }

    @Override
    public Map<String, Object> uploadedSamplesInfo(SampleType sampleType, String sessionKey) {
        HashMap<String, Object> info;
        block3: {
            HttpSession httpSession = this.getHttpSession();
            UploadedFilesBean uploadedFiles = (UploadedFilesBean)httpSession.getAttribute(sessionKey);
            ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
            for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
                files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
            }
            info = new HashMap<String, Object>();
            try {
                boolean projectSamplesEnabled = this.genericServer.isProjectSamplesEnabled(this.getSessionToken());
                SampleUploadSectionsParser.BatchSamplesOperation batchSamplesOperation = SampleUploadSectionsParser.prepareSamples(projectSamplesEnabled, sampleType, null, null, files, null, null, true, null, BatchOperationKind.REGISTRATION);
                info.put("identifiersPressent", Boolean.TRUE);
            }
            catch (Exception ex) {
                if (ex.getMessage() == null || !ex.getMessage().contains("Mandatory column 'identifier' is missing.")) break block3;
                info.put("identifiersPressent", Boolean.FALSE);
            }
        }
        return info;
    }
}

