/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server;

import ch.systemsx.cisd.common.io.DelegatedReader;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.parser.BisTabFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.parser.NamedInputStream;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser.NewMaterialParserObjectFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MaterialLoader {
    private List<BatchRegistrationResult> results;
    private List<NewMaterial> newMaterials;
    private BisTabFileLoader<NewMaterial> tabFileLoader;

    public void load(Collection<NamedInputStream> files) {
        this.tabFileLoader = new BisTabFileLoader<NewMaterial>(new IParserObjectFactoryFactory<NewMaterial>(){

            public final IParserObjectFactory<NewMaterial> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new NewMaterialParserObjectFactory(propertyMapper);
            }
        }, false);
        this.newMaterials = new ArrayList<NewMaterial>();
        this.results = new ArrayList<BatchRegistrationResult>(files.size());
        for (NamedInputStream file : files) {
            Reader reader = file.getUnicodeReader();
            Map<String, String> defaults = Collections.emptyMap();
            List<NewMaterial> loadedMaterials = this.tabFileLoader.load((Reader)new DelegatedReader(reader, file.getOriginalFilename()), defaults);
            this.newMaterials.addAll(loadedMaterials);
            this.results.add(new BatchRegistrationResult(file.getOriginalFilename(), String.format("%d material(s) found and registered.", loadedMaterials.size())));
        }
    }

    public List<BatchRegistrationResult> getResults() {
        return new ArrayList<BatchRegistrationResult>(this.results);
    }

    public List<NewMaterial> getNewMaterials() {
        return new ArrayList<NewMaterial>(this.newMaterials);
    }
}

