/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server;

import ch.systemsx.cisd.common.io.DelegatedReader;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedBasicExperiment;
import ch.systemsx.cisd.openbis.generic.shared.parser.BisTabFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.parser.NamedInputStream;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser.UpdatedBasicExperimentParserObjectFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UpdatedExperimentLoader {
    private List<BatchRegistrationResult> results;
    private List<UpdatedBasicExperiment> newExperiments;
    private BisTabFileLoader<UpdatedBasicExperiment> tabFileLoader;

    public void load(Collection<NamedInputStream> files) {
        this.tabFileLoader = new BisTabFileLoader<UpdatedBasicExperiment>(new IParserObjectFactoryFactory<UpdatedBasicExperiment>(){

            public final IParserObjectFactory<UpdatedBasicExperiment> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new UpdatedBasicExperimentParserObjectFactory(propertyMapper);
            }
        }, false);
        this.newExperiments = new ArrayList<UpdatedBasicExperiment>();
        this.results = new ArrayList<BatchRegistrationResult>(files.size());
        for (NamedInputStream file : files) {
            Reader reader = file.getUnicodeReader();
            Map<String, String> defaults = Collections.emptyMap();
            List<UpdatedBasicExperiment> loadedExperiments = this.tabFileLoader.load((Reader)new DelegatedReader(reader, file.getOriginalFilename()), defaults);
            this.newExperiments.addAll(loadedExperiments);
            this.results.add(new BatchRegistrationResult(file.getOriginalFilename(), String.format("Update of %d experiment(s) is complete.", loadedExperiments.size())));
        }
    }

    public List<BatchRegistrationResult> getResults() {
        return new ArrayList<BatchRegistrationResult>(this.results);
    }

    public List<UpdatedBasicExperiment> getNewBasicExperiments() {
        return new ArrayList<UpdatedBasicExperiment>(this.newExperiments);
    }
}

