/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser;

import ch.systemsx.cisd.common.io.DelegatedReader;
import ch.systemsx.cisd.common.parser.ExcelFileLoader;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.TabFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.parser.BisExcelFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.parser.BisTabFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.parser.ExcelFileSection;
import ch.systemsx.cisd.openbis.generic.shared.parser.FileSection;
import ch.systemsx.cisd.openbis.generic.shared.parser.NamedInputStream;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser.NewMaterialParserObjectFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;

public class MaterialUploadSectionsParser {
    public static BatchMaterialsOperation prepareMaterials(MaterialType materialType, Collection<NamedInputStream> files, String excelSheetName) {
        ArrayList<NewMaterialsWithTypes> newSamples = new ArrayList<NewMaterialsWithTypes>();
        List<BatchRegistrationResult> results = MaterialUploadSectionsParser.loadMaterialsFromFiles(files, materialType, newSamples, excelSheetName);
        return new BatchMaterialsOperation(newSamples, results, MaterialUploadSectionsParser.parseCodes(newSamples));
    }

    private static String[] parseCodes(List<NewMaterialsWithTypes> newMaterials) {
        ArrayList<String> codes = new ArrayList<String>();
        for (NewMaterialsWithTypes st : newMaterials) {
            for (NewMaterial s : st.getNewEntities()) {
                codes.add(s.getCode());
            }
        }
        return codes.toArray(new String[0]);
    }

    private static List<BatchRegistrationResult> loadMaterialsFromFiles(Collection<NamedInputStream> uploadedFiles, MaterialType materialType, List<NewMaterialsWithTypes> newMaterials, String excelSheetName) {
        ArrayList<BatchRegistrationResult> results = new ArrayList<BatchRegistrationResult>(uploadedFiles.size());
        for (NamedInputStream multipartFile : uploadedFiles) {
            HashMap<String, String> defaults;
            ArrayList<Object> materialSections;
            String fileName = multipartFile.getOriginalFilename();
            String loweredFileName = fileName.toLowerCase();
            String registrationMessage = "Registration/update of %d material(s) is complete.";
            int materialCounter = 0;
            if (loweredFileName.endsWith("xls") || loweredFileName.endsWith("xlsx")) {
                materialSections = new ArrayList<Object>();
                if (materialType.isDefinedInFileEntityTypeCode()) {
                    materialSections.addAll(ExcelFileSection.extractSections(multipartFile.getInputStream(), excelSheetName, loweredFileName));
                } else {
                    materialSections.add(ExcelFileSection.createFromInputStream(multipartFile.getInputStream(), materialType.getCode(), loweredFileName));
                }
                defaults = new HashMap<String, String>();
                for (Object fs : materialSections) {
                    String sectionInFile;
                    if (((ExcelFileSection)fs).getSectionName().equals("DEFAULT")) {
                        defaults.putAll(ExcelFileLoader.parseDefaults((Sheet)((ExcelFileSection)fs).getSheet(), (int)((ExcelFileSection)fs).getBegin(), (int)((ExcelFileSection)fs).getEnd()));
                        continue;
                    }
                    MaterialType typeFromSection = new MaterialType();
                    typeFromSection.setCode(((ExcelFileSection)fs).getSectionName());
                    BisExcelFileLoader<NewMaterial> excelFileLoader = new BisExcelFileLoader<NewMaterial>(new IParserObjectFactoryFactory<NewMaterial>(){

                        public final IParserObjectFactory<NewMaterial> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                            return new NewMaterialParserObjectFactory(propertyMapper);
                        }
                    }, false);
                    String string = sectionInFile = materialSections.size() == 1 ? "" : " (section:" + ((ExcelFileSection)fs).getSectionName() + ")";
                    List<NewMaterial> loadedMaterials = excelFileLoader.load(((ExcelFileSection)fs).getSheet(), ((ExcelFileSection)fs).getBegin(), ((ExcelFileSection)fs).getEnd(), fileName + sectionInFile, defaults);
                    if (loadedMaterials.size() <= 0) continue;
                    newMaterials.add(new NewMaterialsWithTypes(typeFromSection, loadedMaterials));
                    materialCounter += loadedMaterials.size();
                }
            } else {
                materialSections = new ArrayList();
                if (materialType.isDefinedInFileEntityTypeCode()) {
                    materialSections.addAll(FileSection.extractSections(multipartFile.getUnicodeReader()));
                } else {
                    materialSections.add(FileSection.createFromInputStream(multipartFile.getInputStream(), materialType.getCode()));
                }
                defaults = new HashMap();
                for (Object fs : materialSections) {
                    String sectionInFile;
                    if (((FileSection)fs).getSectionName().equals("DEFAULT")) {
                        defaults.putAll(TabFileLoader.parseDefaults((Reader)((FileSection)fs).getContentReader()));
                        continue;
                    }
                    Reader reader = ((FileSection)fs).getContentReader();
                    MaterialType typeFromSection = new MaterialType();
                    typeFromSection.setCode(((FileSection)fs).getSectionName());
                    BisTabFileLoader<NewMaterial> tabFileLoader = new BisTabFileLoader<NewMaterial>(new IParserObjectFactoryFactory<NewMaterial>(){

                        public final IParserObjectFactory<NewMaterial> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                            return new NewMaterialParserObjectFactory(propertyMapper);
                        }
                    }, false);
                    String string = sectionInFile = materialSections.size() == 1 ? "" : " (section:" + ((FileSection)fs).getSectionName() + ")";
                    List<NewMaterial> loadedMaterials = tabFileLoader.load((Reader)new DelegatedReader(reader, fileName + sectionInFile), defaults);
                    if (loadedMaterials.size() <= 0) continue;
                    newMaterials.add(new NewMaterialsWithTypes(typeFromSection, loadedMaterials));
                    materialCounter += loadedMaterials.size();
                }
            }
            results.add(new BatchRegistrationResult(fileName, String.format(registrationMessage, materialCounter)));
        }
        return results;
    }

    public static class BatchMaterialsOperation {
        private final List<NewMaterialsWithTypes> materials;
        private final List<BatchRegistrationResult> resultList;
        private final String[] materialCodes;

        public BatchMaterialsOperation(List<NewMaterialsWithTypes> materials, List<BatchRegistrationResult> resultList, String[] materialCodes) {
            this.materials = materials;
            this.resultList = resultList;
            this.materialCodes = materialCodes;
        }

        public List<NewMaterialsWithTypes> getMaterials() {
            return this.materials;
        }

        public List<BatchRegistrationResult> getResultList() {
            return this.resultList;
        }

        public String[] getCodes() {
            return this.materialCodes;
        }
    }
}

