/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser;

import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedDataSet;
import java.util.ArrayList;
import java.util.HashSet;

public final class UpdatedDataSetParserObjectFactory
extends AbstractParserObjectFactory<NewDataSet> {
    private final DataSetBatchUpdateDetails basicBatchUpdateDetails = this.createBasicBatchUpdateDetails();

    public UpdatedDataSetParserObjectFactory(IPropertyMapper propertyMapper) {
        super(NewDataSet.class, propertyMapper);
    }

    public final NewDataSet createObject(String[] lineTokens) throws ParserException {
        NewDataSet newDataSet = (NewDataSet)super.createObject(lineTokens);
        this.setProperties(newDataSet, lineTokens);
        DataSetBatchUpdateDetails updateDetails = this.createBatchUpdateDetails(newDataSet);
        this.cleanUp(newDataSet);
        return new UpdatedDataSet(newDataSet, updateDetails);
    }

    private final void setProperties(NewDataSet newObject, String[] lineTokens) {
        ArrayList<EntityProperty> properties = new ArrayList<EntityProperty>();
        for (String unmatchedProperty : this.getUnmatchedProperties()) {
            String propertyDefault;
            IPropertyModel propertyModel = this.tryGetPropertyModel(unmatchedProperty);
            String propertyValue = this.getPropertyValue(lineTokens, propertyModel, propertyDefault = this.tryGetPropertyDefault(unmatchedProperty));
            if (!UpdatedDataSetParserObjectFactory.isNotEmpty((String)propertyValue)) continue;
            EntityProperty property = new EntityProperty();
            property.setPropertyType(this.createPropertyType(unmatchedProperty));
            property.setValue(propertyValue);
            properties.add(property);
        }
        newObject.setProperties(properties.toArray(IEntityProperty.EMPTY_ARRAY));
    }

    private final PropertyType createPropertyType(String propertyTypeCode) {
        PropertyType propertyType = new PropertyType();
        propertyType.setCode(propertyTypeCode);
        return propertyType;
    }

    private DataSetBatchUpdateDetails createBasicBatchUpdateDetails() {
        DataSetBatchUpdateDetails details = new DataSetBatchUpdateDetails();
        details.setExperimentUpdateRequested(this.isColumnAvailable("experiment"));
        details.setSampleUpdateRequested(this.isColumnAvailable("sample"));
        details.setParentsUpdateRequested(this.isColumnAvailable("parents"));
        details.setContainerUpdateRequested(this.isColumnAvailable("container"));
        details.setFileFormatUpdateRequested(this.isColumnAvailable("file_format"));
        return details;
    }

    private DataSetBatchUpdateDetails createBatchUpdateDetails(NewDataSet dataSet) {
        DataSetBatchUpdateDetails details = new DataSetBatchUpdateDetails();
        details.setExperimentUpdateRequested(this.basicBatchUpdateDetails.isExperimentUpdateRequested() && UpdatedDataSetParserObjectFactory.isNotEmpty((String)dataSet.getExperimentIdentifier()));
        details.setSampleUpdateRequested(this.basicBatchUpdateDetails.isSampleUpdateRequested() && UpdatedDataSetParserObjectFactory.isNotEmpty((String)dataSet.getSampleIdentifierOrNull()));
        details.setParentsUpdateRequested(this.basicBatchUpdateDetails.isParentsUpdateRequested() && UpdatedDataSetParserObjectFactory.isNotEmpty((String[])dataSet.getParentsIdentifiersOrNull()));
        details.setContainerUpdateRequested(this.basicBatchUpdateDetails.isContainerUpdateRequested() && UpdatedDataSetParserObjectFactory.isNotEmpty((String)dataSet.getContainerIdentifierOrNull()));
        details.setFileFormatUpdateRequested(this.basicBatchUpdateDetails.isFileFormatUpdateRequested() && UpdatedDataSetParserObjectFactory.isNotEmpty((String)dataSet.getFileFormatOrNull()));
        HashSet<String> propertiesToUpdate = new HashSet<String>();
        for (IEntityProperty property : dataSet.getProperties()) {
            propertiesToUpdate.add(property.getPropertyType().getCode());
        }
        details.setPropertiesToUpdate(propertiesToUpdate);
        return details;
    }

    private void cleanUp(NewDataSet newDataSet) {
        if (UpdatedDataSetParserObjectFactory.isDeletionMark((String)newDataSet.getExperimentIdentifier())) {
            throw new ParserException("experiment column is required and cannot be marked for deletetion.");
        }
        if (UpdatedDataSetParserObjectFactory.isEmpty((String)newDataSet.getExperimentIdentifier())) {
            newDataSet.setExperimentIdentifier(null);
        }
        if (UpdatedDataSetParserObjectFactory.isDeletionMark((String)newDataSet.getSampleIdentifierOrNull()) || UpdatedDataSetParserObjectFactory.isEmpty((String)newDataSet.getSampleIdentifierOrNull())) {
            newDataSet.setSampleIdentifierOrNull(null);
        }
        if (UpdatedDataSetParserObjectFactory.isDeletionMark((String[])newDataSet.getParentsIdentifiersOrNull()) || UpdatedDataSetParserObjectFactory.isEmpty((String[])newDataSet.getParentsIdentifiersOrNull())) {
            newDataSet.setParentsIdentifiersOrNull((String)null);
        }
        if (UpdatedDataSetParserObjectFactory.isDeletionMark((String)newDataSet.getContainerIdentifierOrNull()) || UpdatedDataSetParserObjectFactory.isEmpty((String)newDataSet.getContainerIdentifierOrNull())) {
            newDataSet.setContainerIdentifierOrNull(null);
        }
        if (UpdatedDataSetParserObjectFactory.isDeletionMark((String)newDataSet.getFileFormatOrNull()) || UpdatedDataSetParserObjectFactory.isEmpty((String)newDataSet.getFileFormatOrNull())) {
            newDataSet.setFileFormatOrNull(null);
        }
        ArrayList<IEntityProperty> updatedProperties = new ArrayList<IEntityProperty>();
        for (IEntityProperty property : newDataSet.getProperties()) {
            if (UpdatedDataSetParserObjectFactory.isDeletionMark((String)property.getValue())) continue;
            updatedProperties.add(property);
        }
        newDataSet.setProperties(updatedProperties.toArray(IEntityProperty.EMPTY_ARRAY));
    }

    protected final boolean ignoreUnmatchedProperties() {
        return true;
    }
}

