/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.SampleBatchRegistration;
import ch.systemsx.cisd.openbis.generic.server.batch.SampleBatchUpdate;
import ch.systemsx.cisd.openbis.generic.server.business.bo.SampleHierarchyFiller;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.plugin.ISampleTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleParentWithDerivedDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.plugin.generic.server.IGenericBusinessObjectFactory;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="generic-sample-type-slave-server-plugin")
public final class GenericSampleTypeSlaveServerPlugin
implements ISampleTypeSlaveServerPlugin {
    @Resource(name="generic-business-object-factory")
    private IGenericBusinessObjectFactory businessObjectFactory;
    @Resource(name="dao-factory")
    private IDAOFactory daoFactory;
    @Resource(name="propertyConfigurer")
    protected ExposablePropertyPlaceholderConfigurer configurer;
    private int sessionCacheEntityLimit = 50000;

    private GenericSampleTypeSlaveServerPlugin() {
    }

    @PostConstruct
    public void init() {
        Properties props = this.configurer.getResolvedProps();
        String text = props.getProperty("hibernate.batch.sessionCache.maxEntities");
        if (text != null) {
            try {
                this.sessionCacheEntityLimit = Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public final SampleParentWithDerivedDTO getSampleInfo(Session session, SamplePE sample) throws UserFailureException {
        assert (session != null) : "Unspecified session.";
        assert (sample != null) : "Unspecified sample.";
        HibernateUtils.initialize(sample.getProperties());
        SampleHierarchyFiller.enrichWithParentAndContainerHierarchy(sample);
        List<SamplePE> generated = this.daoFactory.getSampleDAO().listSamplesByGeneratedFrom(sample);
        return new SampleParentWithDerivedDTO(sample, generated);
    }

    @Override
    public final void registerSamples(Session session, List<NewSample> newSamples, PersonPE registratorOrNull) throws UserFailureException {
        assert (session != null) : "Unspecified session.";
        assert (newSamples != null && newSamples.size() > 0) : "Unspecified sample or empty samples.";
        BatchOperationExecutor.executeInBatches(new SampleBatchRegistration(this.businessObjectFactory.createSampleTable(session), newSamples, registratorOrNull, this.sessionCacheEntityLimit));
    }

    @Override
    public void updateSamples(Session session, List<SampleBatchUpdatesDTO> updateSamples) {
        assert (session != null) : "Unspecified session.";
        assert (updateSamples != null && updateSamples.size() > 0) : "Unspecified sample or empty samples.";
        BatchOperationExecutor.executeInBatches(new SampleBatchUpdate(this.businessObjectFactory.createSampleTable(session), updateSamples, this.sessionCacheEntityLimit));
    }
}

