/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.server;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;

class IdentifersExtractor {
    private final SampleIdentifier oldSampleIdentifier;
    private SampleIdentifier newSampleIdentifier;
    private ExperimentIdentifier experimentIdentifierOrNull;
    private ProjectIdentifier projectIdentifierOrNull;
    private final String containerIdentifierOrNull;

    IdentifersExtractor(NewSample updatedSample) {
        this.newSampleIdentifier = this.oldSampleIdentifier = SampleIdentifierFactory.parse(updatedSample);
        String experimentIdentifier = updatedSample.getExperimentIdentifier();
        String projectIdentifier = updatedSample.getProjectIdentifier();
        String defaultSpaceIdentifier = updatedSample.getDefaultSpaceIdentifier();
        String sampleCode = this.oldSampleIdentifier.getSampleCode();
        if (experimentIdentifier != null) {
            this.experimentIdentifierOrNull = new ExperimentIdentifierFactory(experimentIdentifier).createIdentifier(defaultSpaceIdentifier);
            this.newSampleIdentifier = new SampleIdentifier(new SpaceIdentifier(this.experimentIdentifierOrNull.getSpaceCode()), sampleCode);
        }
        if (projectIdentifier != null) {
            this.projectIdentifierOrNull = new ProjectIdentifierFactory(projectIdentifier).createIdentifier(defaultSpaceIdentifier);
            this.newSampleIdentifier = new SampleIdentifier(this.projectIdentifierOrNull, sampleCode);
        }
        this.containerIdentifierOrNull = updatedSample.getContainerIdentifier();
    }

    public SampleIdentifier getOldSampleIdentifier() {
        return this.oldSampleIdentifier;
    }

    public SampleIdentifier getNewSampleIdentifier() {
        return this.newSampleIdentifier;
    }

    public ExperimentIdentifier getExperimentIdentifierOrNull() {
        return this.experimentIdentifierOrNull;
    }

    public ProjectIdentifier getProjectIdentifier() {
        return this.projectIdentifierOrNull;
    }

    public String getContainerIdentifierOrNull() {
        return this.containerIdentifierOrNull;
    }
}

